/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapFloatBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class FloatBuffer
extends Buffer
implements Comparable<FloatBuffer> {
    final float[] hb;
    final int offset;
    boolean isReadOnly;

    FloatBuffer(int n, int n2, int n3, int n4, float[] fArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = fArray;
        this.offset = n5;
    }

    FloatBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static FloatBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapFloatBuffer(n, n);
    }

    public static FloatBuffer wrap(float[] fArray, int n, int n2) {
        try {
            return new HeapFloatBuffer(fArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public FloatBuffer get(float[] fArray, int n, int n2) {
        FloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            fArray[i] = this.get();
        }
        return this;
    }

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = floatBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(floatBuffer.get());
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        FloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(fArray[i]);
        }
        return this;
    }

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final float[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract FloatBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer floatBuffer = (FloatBuffer)object;
        if (this.remaining() != floatBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = floatBuffer.limit() - 1;
        while (n2 >= n) {
            if (!FloatBuffer.equals(this.get(n2), floatBuffer.get(n3))) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    private static boolean equals(float f, float f2) {
        return f == f2 || Float.isNaN(f) && Float.isNaN(f2);
    }

    @Override
    public int compareTo(FloatBuffer floatBuffer) {
        int n = this.position() + Math.min(this.remaining(), floatBuffer.remaining());
        int n2 = this.position();
        int n3 = floatBuffer.position();
        while (n2 < n) {
            int n4 = FloatBuffer.compare(this.get(n2), floatBuffer.get(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - floatBuffer.remaining();
    }

    private static int compare(float f, float f2) {
        return f < f2 ? -1 : (f > f2 ? 1 : (f == f2 ? 0 : (Float.isNaN(f) ? (Float.isNaN(f2) ? 0 : 1) : -1)));
    }

    public abstract ByteOrder order();
}

