/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;

public final class FileMonitor
extends BaseMonitor {
    private File home;
    private ProductVersionHolder engineVersion;
    private static final Map<String, Void> securityProperties = new HashMap<String, Void>();

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintWriter printWriter) {
        this.runWithState(properties, printWriter);
    }

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File file = new File(this.home, "derby.properties");
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    @Override
    public Object getEnvironment() {
        return this.home;
    }

    private ThreadGroup createDaemonGroup() {
        try {
            ThreadGroup threadGroup = new ThreadGroup("derby.daemons");
            threadGroup.setDaemon(true);
            return threadGroup;
        }
        catch (SecurityException securityException) {
            this.reportThread(securityException);
            return null;
        }
    }

    private boolean PBinitialize(boolean bl) {
        String string;
        if (!bl) {
            this.daemonGroup = this.createDaemonGroup();
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/DBMS.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
        try {
            string = System.getProperty("derby.system.home");
        }
        catch (SecurityException securityException) {
            this.report(securityException, "derby.system.home");
            string = null;
        }
        if (string != null) {
            this.home = new File(string);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + string + " does not represent a directory");
                    return false;
                }
            } else if (!bl) {
                boolean bl2 = false;
                try {
                    boolean bl3 = bl2 = this.home.mkdir() || this.home.mkdirs();
                    if (bl2) {
                        FileUtil.limitAccessToOwner(this.home);
                    }
                }
                catch (SecurityException securityException) {
                    this.report(securityException, this.home);
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            this.report(securityException, string);
            return null;
        }
    }

    private void report(SecurityException securityException, String string) {
        if (securityProperties.containsKey(string)) {
            this.report(MessageService.getTextMessage("M008", string, securityException.toString()));
        }
    }

    private void report(SecurityException securityException, File file) {
        this.report(MessageService.getTextMessage("M009", file.toString(), securityException.toString()));
    }

    private void reportThread(SecurityException securityException) {
        this.report(MessageService.getTextMessage("M010", securityException.toString()));
    }

    @Override
    final boolean initialize(final boolean bl) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileMonitor.this.PBinitialize(bl);
            }
        });
    }

    @Override
    final Properties getDefaultModuleProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return FileMonitor.super.getDefaultModuleProperties();
            }
        });
    }

    @Override
    public final String getJVMProperty(final String string) {
        if (!string.startsWith("derby.")) {
            return this.PBgetJVMProperty(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FileMonitor.this.PBgetJVMProperty(string);
            }
        });
    }

    @Override
    public final synchronized Thread getDaemonThread(final Runnable runnable, final String string, final boolean bl) {
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                try {
                    return FileMonitor.super.getDaemonThread(runnable, string, bl);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (FileMonitor.this.daemonGroup != null && FileMonitor.this.daemonGroup.isDestroyed()) {
                        FileMonitor.this.daemonGroup = FileMonitor.this.createDaemonGroup();
                        return FileMonitor.super.getDaemonThread(runnable, string, bl);
                    }
                    throw illegalThreadStateException;
                }
            }
        });
    }

    @Override
    public final void setThreadPriority(final int n) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FileMonitor.super.setThreadPriority(n);
                return null;
            }
        });
    }

    @Override
    final InputStream applicationPropertiesStream() throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return FileMonitor.this.PBapplicationPropertiesStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    @Override
    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }

    static {
        securityProperties.put("derby.authentication.builtin.algorithm", null);
        securityProperties.put("derby.authentication.provider", null);
        securityProperties.put("derby.database.fullAccessUsers", null);
        securityProperties.put("derby.database.readOnlyAccessUsers", null);
        securityProperties.put("derby.database.sqlAuthorization", null);
        securityProperties.put("derby.connection.requireAuthentication", null);
        securityProperties.put("derby.database.defaultConnectionMode", null);
        securityProperties.put("derby.storage.useDefaultFilePermissions", null);
        securityProperties.put("derby.system.home", null);
    }
}

