/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.File;
import java.io.FileInputStream;
import oracle.jvm.hotspot.jfr.JFR;
import oracle.jvm.hotspot.jfr.JFRBuffers;
import oracle.jvm.hotspot.jfr.JFRProducers;
import oracle.jvm.hotspot.jfr.JFRRepository;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.JFRTypeIDs;
import oracle.jvm.hotspot.jfr.ThreadStates;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.gc_interface.G1YCType;
import sun.jvm.hotspot.gc_interface.GCCause;
import sun.jvm.hotspot.gc_interface.GCName;
import sun.jvm.hotspot.gc_interface.GCWhen;
import sun.jvm.hotspot.gc_interface.ReferenceType;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.opto.CompilerPhaseType;
import sun.jvm.hotspot.runtime.Flags;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMOps;
import sun.jvm.hotspot.tools.Tool;

public class DumpJFR
extends Tool {
    private String path;

    public DumpJFR(String pathName) {
        this.path = pathName;
    }

    public DumpJFR() {
        this("recording.jfr");
    }

    public DumpJFR(JVMDebugger d) {
        super(d);
        this.path = "recording.jfr";
    }

    @Override
    protected boolean needsJavaPrefix() {
        return false;
    }

    @Override
    public String getName() {
        return "DumpJFR";
    }

    protected String getCommandFlags() {
        return "";
    }

    @Override
    protected void printFlagsUsage() {
        super.printFlagsUsage();
    }

    @Override
    public void run() {
        File chunk_path_part_file;
        String chunk_path_part;
        File chunk_path_file;
        JFRStreamWriter writer = JFR.getJFREventWriter().getStreamWriter();
        writer.setFilePath(this.path);
        JFRRepository repo = JFR.getJFRRepository();
        byte[] bytes = null;
        int len = 0;
        String chunk_path = repo.getChunkPath();
        if (chunk_path != null && (chunk_path_file = new File(chunk_path)).exists()) {
            try {
                FileInputStream in = new FileInputStream(chunk_path_file);
                len = in.available();
                bytes = new byte[len];
                in.read(bytes);
                writer.write(bytes);
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((chunk_path_part = repo.getChunkPathPart()) != null && (chunk_path_part_file = new File(chunk_path_part)).exists()) {
            try {
                FileInputStream in = new FileInputStream(chunk_path_part_file);
                len = in.available();
                bytes = new byte[len];
                in.read(bytes);
                writer.write(bytes);
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        byte[] array = writer.getBuffer();
        writer.flush_buffer();
        this.write_chunk_finalization_checkpoint(writer);
        this.write_classes_and_typeids_checkpoint(writer);
        JFRProducers producers = JFR.getJFRProducers();
        byte[] locale = JFR.getLocale();
        int locale_len = (int)JFR.getLocaleLen();
        long start = JFR.getStartMillis();
        long end_millis = JFR.getStartMillis() + 3600000L;
        int tz_offset = JFR.getTZOffset();
        writer.writeDescriptorCheckpoint(producers, locale, locale_len, start, end_millis, tz_offset);
        writer.close();
    }

    void write_chunk_finalization_checkpoint(JFRStreamWriter writer) {
        JFR.getJFRConstantPools().write_all_string_pools(writer);
        JFRBuffers buffers = JFR.getJFRBuffers();
        buffers.write_all_buffers(writer);
        writer.beginCheckpointWrite();
        this.writeThreadInformation(writer);
        this.writeGCEnumTypes(writer);
        this.writeFlagValueOriginName(writer);
        this.writeVMOperationTypeEnum(writer);
        this.writeCompilerEnumTypes(writer);
        this.writeThreadStates(writer);
        writer.endCheckpointWrite();
    }

    void write_classes_and_typeids_checkpoint(JFRStreamWriter writer) {
        writer.beginCheckpointWrite();
        JFRTypeIDs.jfrFlushClasses(writer);
        writer.endCheckpointWrite();
    }

    void writeThreadInformation(JFRStreamWriter writer) {
        JavaThread cur;
        Threads threads = VM.getVM().getThreads();
        int total_threads = 0;
        int num_java_threads = 0;
        for (cur = threads.first(); cur != null; cur = cur.next()) {
            ++total_threads;
            if (!cur.isJavaThread()) continue;
            ++num_java_threads;
        }
        writer.write(7);
        writer.write(total_threads);
        for (cur = threads.first(); cur != null; cur = cur.next()) {
            writer.write(cur.getOSThread().threadId());
            writer.writeString(cur.getThreadName());
        }
        writer.write(30);
        writer.write(total_threads);
        for (cur = threads.first(); cur != null; cur = cur.next()) {
            long thread_addr = cur.getAddress().hashCode();
            writer.write(thread_addr);
            writer.write(cur.getOSThread().threadId());
        }
        writer.write(8);
        writer.write(num_java_threads);
        for (cur = threads.first(); cur != null; cur = cur.next()) {
            if (!cur.isJavaThread()) continue;
            Oop threadObj = cur.getThreadObj();
            writer.write(OopUtilities.threadOopGetTID(threadObj));
            writer.write(cur.getOSThread().threadId());
            writer.write(cur.allocatedBytes());
            if (VM.getVM().getUseTLAB()) {
                long used_bytes = 0L;
                if (cur.tlab().top() != null) {
                    used_bytes = cur.tlab().top().minus(cur.tlab().start());
                }
                writer.write(used_bytes);
            } else {
                writer.write(0L);
            }
            writer.write(0);
        }
        JFRTypeIDs.jfrWriteThreadGroups(writer);
        JFR.getJFRStackTraces().write(writer);
    }

    void writeGCEnumTypes(JFRStreamWriter w) {
        this.writeGCCauseEnum(w);
        this.writeGCNameEnum(w);
        this.writeGCWhenEnum(w);
        this.writeG1YCTypeEnum(w);
        this.writeReferenceTypeEnum(w);
        this.writeNarrowOopModeEnum(w);
    }

    void writeGCCauseEnum(JFRStreamWriter w) {
        w.write(36);
        GCCause last_gc_cause = GCCause._last_gc_cause;
        w.write(last_gc_cause.ordinal());
        short i = 0;
        for (GCCause c : GCCause.values()) {
            if (c == last_gc_cause) break;
            w.write(i);
            i = (short)(i + 1);
            w.writeString(c.value());
        }
    }

    void writeGCNameEnum(JFRStreamWriter w) {
        w.write(35);
        GCName gcNameSentinal = GCName.GCNameEndSentinel;
        w.write(gcNameSentinal.ordinal());
        int i = 0;
        for (GCName name : GCName.values()) {
            if (name == gcNameSentinal) break;
            w.write((byte)i);
            i = (short)(i + 1);
            w.writeString(name.value());
        }
    }

    void writeGCWhenEnum(JFRStreamWriter w) {
        w.write(37);
        GCWhen gcWhenSentinal = GCWhen.GCWhenEndSentinel;
        w.write(gcWhenSentinal.ordinal());
        int i = 0;
        for (GCWhen when : GCWhen.values()) {
            if (when == gcWhenSentinal) break;
            w.write((byte)i);
            i = (short)(i + 1);
            w.writeString(when.value());
        }
    }

    void writeG1YCTypeEnum(JFRStreamWriter w) {
        w.write(38);
        G1YCType g1YCTypeSentinal = G1YCType.G1YCTypeEndSentinel;
        w.write(g1YCTypeSentinal.ordinal());
        int i = 0;
        for (G1YCType type : G1YCType.values()) {
            if (type == g1YCTypeSentinal) break;
            w.write((byte)i);
            i = (short)(i + 1);
            w.writeString(type.value());
        }
    }

    void writeReferenceTypeEnum(JFRStreamWriter w) {
        w.write(40);
        ReferenceType last_ref_value = ReferenceType.REF_PHANTOM;
        w.write(last_ref_value.ordinal() + 1);
        int i = 0;
        for (ReferenceType type : ReferenceType.values()) {
            w.write((byte)i);
            i = (short)(i + 1);
            w.writeString(type.value());
        }
    }

    void writeNarrowOopModeEnum(JFRStreamWriter w) {
        w.write(43);
        Universe.NARROW_OOP_MODE last_enum_value = Universe.NARROW_OOP_MODE.HeapBasedNarrowOop;
        w.write(last_enum_value.ordinal() + 1);
        int i = 0;
        for (Universe.NARROW_OOP_MODE mode : Universe.NARROW_OOP_MODE.values()) {
            w.write((byte)i);
            i = (short)(i + 1);
            w.writeString(Universe.narrowOopModeToString(mode));
        }
    }

    void writeFlagValueOriginName(JFRStreamWriter w) {
        w.write(46);
        Flags last_enum_value = Flags.INTERNAL;
        w.write(last_enum_value.ordinal() + 1);
        int i = 0;
        for (Flags f : Flags.values()) {
            w.write((byte)i);
            i = (short)(i + 1);
            w.writeString(f.value());
        }
    }

    void writeVMOperationTypeEnum(JFRStreamWriter w) {
        w.write(44);
        VMOps last_enum_value = VMOps.Terminating;
        w.write(last_enum_value.ordinal());
        short i = 0;
        for (VMOps op : VMOps.values()) {
            if (op == last_enum_value) break;
            w.write(i);
            i = (short)(i + 1);
            w.writeString(op.toString());
        }
    }

    void writeCompilerEnumTypes(JFRStreamWriter w) {
        if (VM.getVM().isServerCompiler()) {
            w.write(45);
            CompilerPhaseType last_enum_value = CompilerPhaseType.PHASE_NUM_TYPES;
            w.write(last_enum_value.ordinal());
            int i = 0;
            for (CompilerPhaseType cpt : CompilerPhaseType.values()) {
                if (cpt == last_enum_value) break;
                w.write((byte)i);
                i = (short)(i + 1);
                w.writeString(cpt.value());
            }
        }
    }

    void writeThreadStates(JFRStreamWriter w) {
        w.write(34);
        ThreadStates.States last_enum_value = ThreadStates.States.STATE_TERMINATED;
        w.write(last_enum_value.ordinal() + 1);
        for (ThreadStates.States st : ThreadStates.States.values()) {
            w.write((short)st.value());
            w.writeString(st.toString());
        }
    }

    public static void main(String[] args) {
        DumpJFR dumpJFR = new DumpJFR();
        dumpJFR.execute(args);
    }
}

