/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.nio.ByteOrder;
import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFR;
import oracle.jvm.hotspot.jfr.JFRProducers;
import oracle.jvm.hotspot.jfr.StreamWriter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JFRStreamWriter
extends StreamWriter {
    private static final int MAGIC_LEN = 4;
    private static final int CHUNK_FINALIZER_HEADER_SIZE = 58;
    private static final int CHECKPOINT_HEADER_SIZE = 24;
    private static final int DESCRIPTOR_OFFSET = 8;
    private static final int EVENT_PRODUCERS = 0;
    private static final int EVENT_CHECKPOINT = 1;
    private static final int EVENT_BUFFERLOST = 2;
    private static Field currentCheckpointField;
    private static Field previousCheckpointField;
    private static Field lastPositionField;
    private long currentCheckpoint;
    private long previousCheckpoint;
    private long lastPosition;

    public JFRStreamWriter(Address addr) {
        super(addr);
        this.currentCheckpoint = currentCheckpointField.getJLong(addr);
        this.previousCheckpoint = previousCheckpointField.getJLong(addr);
        this.lastPosition = lastPositionField.getJLong(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrStreamWriter");
        currentCheckpointField = type.getField("_current_checkpoint");
        previousCheckpointField = type.getField("_previous_checkpoint");
        lastPositionField = type.getField("_last_position");
    }

    private byte[] shortToBytes(short x) {
        byte[] bytes = new byte[2];
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            bytes[0] = (byte)x;
            bytes[1] = (byte)(x >> 8);
        } else {
            bytes[0] = (byte)(x >> 8);
            bytes[1] = (byte)x;
        }
        return bytes;
    }

    public void writeJavaConstantPoolCheckpoint(long event_size, byte[] buf, int buf_len, int index, int count) {
        long start = this.getCurrentPos();
        this.writeHeader(event_size, 1);
        this.writeCurrentTime();
        this.writePrevCheckpoint();
        this.write(index);
        this.write(count);
        this.write(buf);
        this.previousCheckpoint = start;
        long size_written = this.getCurrentPos() - start;
    }

    public void beginCheckpointWrite() {
        this.setCurrentCheckpoint(this.getCurrentPos());
        this.writeHeader(0L, 1);
        this.writeCurrentTime();
        this.writePrevCheckpoint();
    }

    public long endCheckpointWrite() {
        long end = this.getCurrentPos();
        long size_written = end - this.getCurrentCheckpoint();
        this.seek(this.getCurrentCheckpoint());
        if (size_written == 24L) {
            this.setCurrentCheckpoint(0L);
            return 0L;
        }
        this.write((int)size_written);
        this.seek(end);
        this.setPrevCheckpoint(this.getCurrentCheckpoint());
        this.setCurrentCheckpoint(0L);
        return size_written;
    }

    public void writeHeader(long event_size, int event) {
        this.write((int)event_size);
        this.write(event);
    }

    private void writeCurrentTime() {
        long time = 0L;
        time = JFR.getStartMillis();
        this.write(time);
    }

    private void writePrevCheckpoint() {
        this.write(this.previousCheckpoint);
    }

    public long getCurrentCheckpoint() {
        return this.currentCheckpoint;
    }

    public void setCurrentCheckpoint(long pos) {
        this.currentCheckpoint = pos;
    }

    public void setPrevCheckpoint(long pos) {
        this.previousCheckpoint = pos;
    }

    public void writeDescriptorCheckpoint(JFRProducers producers, byte[] locale, int locale_len, long start_millis, long end_millis, int tz_off) {
        int size = producers.getDescriptorSize();
        size += 58;
        long pos = this.getCurrentPos();
        this.writeHeader(size += locale_len, 0);
        producers.write_producers(this);
        this.write(start_millis);
        this.write(end_millis);
        this.write(JFR.getStartTicks());
        this.write(1000000000L);
        this.writePrevCheckpoint();
        this.write((short)locale_len);
        this.write(locale);
        this.write(tz_off);
        this.seek(8L);
        this.write(pos);
        this.setPrevCheckpoint(0L);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRStreamWriter.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

