/* 
 *  HP-UX $B%5%&%s%I=hM}(B
 */

/*
 *  Copyright (c) 1994 Tomoyuki Shiraishi
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $BDj?t(B */
#define HAS_SOUND_CODE		/* $B%5%&%s%I4X78$N%3!<%I$OM-8z!*(B */

/* RCS ID */
rcsId(audioId, "$Id: audio.c,v 1.2 1999/09/02 14:34:36 koba Exp $")

/* $B%0%m!<%P%kJQ?t(B */
static Audio *audio = NULL;	/* audio connection */


/*
 *  $B%5%&%s%I4D6-$N=i4|2=(B
 */
static void
S_SoundEnvInit()
{
  /* $B%5!<%P$N%*!<%W%s(B */
  if(!audio && (audio = AOpenAudio(NULL, NULL))){
    /* $B1iAU=*N;$^$G%/%m!<%:$7$J$$(B */
    ASetCloseDownMode(audio, AKeepTransactions, NULL);
  }
}  


/*
 *  $B%5%&%s%I%G%P%$%9$NB8:_H=Dj(B
 */
static Boolean
S_IsSoundAvailable()
{
  return(audio ? True : False);
}


/*
 *  $B%5%&%s%I:F@8(B
 */
static int
S_PlaySound(filename)
     char *filename;
{
  int ret;
  SoundCacheBuffer cache;

  if(ret = S_CacheSound(filename, &cache))
    return(ret);
  if(ret = S_PlayCacheSound(&cache))
    return(ret);
  S_FreeCacheSound(&cache);

  return(SOUND_NO_ERROR);
}


/*
 *  $B%5%&%s%I$N%-%c%C%7%e2=2DG=!?IT2DG=H=Dj(B
 */
static Boolean
S_IsSoundCacheAvailable()
{
  return(True);
}


/*
 *  $B%5%&%s%I$N%-%c%C%7%e2=(B
 */
static int
S_CacheSound(filename, cacheBufferPtr)
     char *filename;
     SoundCacheBuffer *cacheBufferPtr;
{
  AFileFormat file_fmt;
  long status;

  /* $B%U%!%$%k$N%U%)!<%^%C%H$N8!::(B */
  file_fmt = AQueryAFile(audio, filename, &status);
  switch(status){
  case AENoError:
    break;
  case AEFileNotFound:
    return(SOUND_OPEN_ERROR);
  default:
    return(SOUND_FILE_INVALID);
  }

  /* sound bucket $B$X$NFI$_9~$_(B */
  cacheBufferPtr->soundBucket = 
    ALoadAFile(audio, filename, file_fmt, 0, NULL, &status);
  switch(status){
  case AENoError:
    break;
  case AEFileNotFound:
    return(SOUND_OPEN_ERROR);
  default:
    return(SOUND_FILE_INVALID);
  }

  /* $B%Q%i%a!<%?$N@_Dj(B */
  cacheBufferPtr->playParams.gain_matrix = *ASimplePlayer(audio);
  cacheBufferPtr->playParams.play_volume = AUnityGain;
  cacheBufferPtr->playParams.pause_first = False;
  cacheBufferPtr->playParams.start_offset.type = ATTSamples;
  cacheBufferPtr->playParams.start_offset.u.samples = 0;
  cacheBufferPtr->playParams.duration.type = ATTFullLength;
  cacheBufferPtr->playParams.loop_count = 0;
  cacheBufferPtr->playParams.previous_transaction = 0;
  cacheBufferPtr->playParams.event_mask = 0;

  return(SOUND_NO_ERROR);
}


/*
 *  $B%-%c%C%7%e2=$5$l$?%5%&%s%I$N:F@8(B
 */
static int
S_PlayCacheSound(cacheBufferPtr)
     SoundCacheBuffer *cacheBufferPtr;
{
  long status;

  APlaySBucket(audio, cacheBufferPtr->soundBucket,
	       cacheBufferPtr->playParams, &status);
  if(status) return(SOUND_DEVICE_ERROR);

  return(SOUND_NO_ERROR);
}


/*
 *  $B%-%c%C%7%e2=$5$l$?%5%&%s%I$N2rJ|(B
 */
static void
S_FreeCacheSound(cacheBufferPtr)
     SoundCacheBuffer *cacheBufferPtr;
{
  ADestroySBucket(audio, cacheBufferPtr->soundBucket, NULL);
}


/*
 *  $B%5%&%s%I4D6-$N8e;OKv(B
 */
static void
S_SoundEnvDispose()
{
  /* $B%5!<%P$N%/%m!<%:(B */
  ACloseAudio(audio, NULL);
}
