%if %{!?__nkf:1}
%define __nkf nkf --unix --euc
%endif

Summary:	X based image viewer for darned near all images
Summary(ja):	ほとんどの画像を扱える X 用の画像ビューア
Summary(de):	X-basierender Bild-Viewer für praktische sämtliche Grafiken
Summary(fr):	Visualisateur sous X pour quasiment tous les types d'images
Summary(tr):	X tabanlý resim görüntüleyici
Name:		xv
Version:	3.10a
Release:	30
Url:		http://www.trilon.com/xv/xv.html
License:	Shareware
Group:		Applications/Multimedia
Requires:	libjpeg libpng >= 1.2 zlib bzip2-libs
BuildRequires:	libjpeg-devel libpng-devel >= 1.2 zlib-devel bzip2-devel
BuildRequires:	nkf

Source0: ftp://ftp.cis.upenn.edu/pub/xv/xv-3.10a.tar.gz
Source22: ftp://ftp.trilon.com/pub/xv/xv-3.10a-png-1.2d.tar.gz
Source2: ftp://ftp.airlab.cs.ritsumei.ac.jp/pub/usr/ikeyan/xv-jp-extension/working/xv310a-jp-extension-rev5.3.3.tar.gz
Source3: xv-3.10a-towns-tiff-patch.tar.gz
Source4: http://www.lb.u-tokai.ac.jp/~matu/flmask/patch/XV+FLmask.v2.1.tar.gz
Source24: ftp://ftp.trilon.com/pub/xv/patches/windowid.patch.readme
Source5: xv.desktop
Source9: rejectcount.sh

#HG http://www.oersted.co.jp/~yav/sohonzan/shz.cgi?f=junkdata&n=141
#   http://www.oersted.co.jp/~yav/sohonzan/shz.cgi/hg_xv.tgz?f=junkdata&dl=141

Patch0: ftp://ftp.trilon.com/pub/xv/patches/grabpatch
Patch2: ftp://ftp.trilon.com/pub/xv/patches/mp-tiff-patch
Patch3: ftp://ftp.trilon.com/pub/xv/patches/longname.patch
### png patch included xpm patch
#Patch4: ftp://ftp.trilon.com/pub/xv/patches/xpm.patch
Patch5: ftp://ftp.trilon.com/pub/xv/patches/deepcolor.patch
Patch6: ftp://ftp.trilon.com/pub/xv/patches/gifpatch
#renamed Patch7: http://fy.chalmers.se/~appro/SITE/xv-3.10a.local.patch
Patch7: xv-3.10a-gifil.patch
### resolution patch work to replace tiff1200.patch
#Patch10: ftp://ftp.trilon.com/pub/xv/patches/tiff1200.patch
Patch11: ftp://ftp.trilon.com/pub/xv/patches/gssafer.patch
#Patch14: ftp://t.ring.gr.jp/pub/FreeBSD/ports/local-distfiles/mph/xv/jp-ext-bzip2.patch
#Patch14: xv-3.10a-bzip2.patch
Patch13: xv-3.10a-zlib.patch
Patch14: xv-3.10a-bzlib.patch
Patch15: xv-3.10a-unrar.patch
Patch16: xv-3.10a-rpm2cpio.patch
Patch17: xv-3.10a-xvvd_passwd.patch
Patch20: xv-3.10a-jp_macbin.patch
Patch21: xv-3.10a-jp_xvpcd.patch
Patch30: ftp://ftp.cis.upenn.edu/pub/xv/xv-3.10a.JPEG-patch
Patch31: ftp://ftp.cis.upenn.edu/pub/xv/xv-3.10a.TIFF-patch
Patch32: ftp://ftp.trilon.com/pub/xv/patches/xvpng-1.2d-fix3.patch
Patch33: ftp://ftp.trilon.com/pub/xv/patches/pdf.patch
Patch34: ftp://ftp.trilon.com/pub/xv/patches/windowid.patch
Patch35: ftp://ftp.trilon.com/pub/xv/patches/bmp32.patch
Patch36: xv-3.10a-bmp16.patch
#Patch40: http://hepax6.rl.ac.uk/DELPHI/Adye/xv-psnewstyle.patch
#Source40: http://hepax6.rl.ac.uk/DELPHI/Adye/xv-psnewstyle.html
#Patch41: http://andrew.triumf.ca/pub/xv-3.10a-pcd.patch
#Patch43: http://www.deryabin.ru/soft/gfx/viewers/xv/patches/exceed_grab.patch
# This patch was fixed (long long)
Patch44: http://www.cybercom.net/~dcoffin/dcraw/xv_smooth.patch
#Patch45: http://www.cybercom.net/~dcoffin/dcraw/xv_ps_save.patch
#Patch46: http://www.cybercom.net/~dcoffin/dcraw/xv_jpeg.patch
Patch46: xv-3.10a-jpegparams.patch
#Patch47: http://www.cybercom.net/~dcoffin/dcraw/xv_png_crw.patch
Patch48: http://spatula-city.org/~im14u2c/browse-remember.patch
#Patch44: http://spatula-city.org/~im14u2c/faster-smooth.patch
Patch49: xv-3.10a-xvsmooth_fix.patch
# Specifying size in just one direction <http://shh.thathost.com/patches/>
Patch50: http://shh.thathost.com/patches/files/xv-3.10a-patch-for-resizing.txt

Patch60: xv-3.10a-linux.patch
Patch61: xv-3.10a-glibc.patch
Patch62: xv-3.10a-ansi.patch
#Patch63: xv-3.10a-mkstemp.patch
Patch70: xv-3.10a-jp_rej.patch
Patch71: xv-3.10a-jpextconfig.patch
Patch72: xv-3.10a-timtoppm.patch
Patch73: xv-3.10a-xvpic-optbug.patch
Patch74: xv-3.10a-towns-tiff.patch
Patch75: xv-3.10a-Makefile.patch
Patch76: xv-3.10a-fl_make.patch
Patch77: xv-3.10a-fl_refine.patch
Patch78: xv-3.10a-sysconfdir.patch
Patch79: xv-3.10a-xvexecpath.patch
Patch80: xv-3.10a-noblink.patch
Patch81: xv-3.10a-timer.patch
Patch82: xv-3.10a-addwait.patch
Patch83: xv-3.10a-zeroquit.patch
Patch84: xv-3.10a-jp_qs.patch
Patch85: xv-3.10a-locale-linux.patch
Patch86: xv-3.10a-jp_mb.patch
Patch87: xv-3.10a-jp_star.patch
Patch88: xv-3.10a-jp_utf8.patch
Patch89: xv-3.10a-text_key.patch
Patch90: xv-3.10a-text_butt.patch
#Patch91: xv-3.10a-sh_quote-bzip2.patch
Patch91: xv-3.10a-sh_quote-zlib.patch
Patch92: xv-3.10a-directory.patch
Patch93: xv-3.10a-menubutton.patch
Patch94: xv-3.10a-keepinside.patch
Patch95: xv-3.10a-formatstr.patch
Patch96: xv-3.10a-dirwkey.patch
Patch97: xv-3.10a-printkey.patch

Patch99: xv-3.10a-forcequit.patch

Patch100: xv-3.10a-xvpopup_accel.patch
Patch101: xv-3.10a-zerolength.patch
Patch102: xv-3.10a-keyzoom.patch
Patch103: xv-3.10a-wheelmouse.patch
Patch104: xv-3.10a-xvzoom.patch
Patch105: xv-3.10a-resolution.patch
Patch106: xv-3.10a-staytoppdir.patch
Patch107: xv-3.10a-showlongname.patch
Patch108: xv-3.10a-xvbrowse_pdir.patch

Patch110: xv-3.10a-selall.patch
Patch111: xv-3.10a-rotatesel.patch
Patch112: xv-3.10a-wresize.patch
Patch113: xv-3.10a-wedge.patch
Patch114: xv-3.10a-minfill.patch
Patch115: xv-3.10a-shiftspace.patch
Patch116: xv-3.10a-forcermode.patch
Patch117: xv-3.10a-xvscrl_button2.patch
Patch118: xv-3.10a-raisetext.patch
Patch119: xv-3.10a-xvtext_vfn.patch

Patch120: xv-3.10a-dither16.patch

Icon: xv2.xpm

Prefix:		/usr/X11R6
BuildRoot:	%{_tmppath}/%{name}-buildroot

%define bindir %{prefix}/bin
%define mandir %{prefix}/man

%description
This is the famous 'xv' by John Bradley.  It is shareware, but
we ship it with the permission of the authors.  It is a graphics
viewer for many file types, including gif, jpg, tiff, xwd, etc.
It also have manipulation features such as cropping, expanding, etc.

%description -l ja
これは John Bradly によるお馴染み 'xv' です。これはシェアウェアですが、
私たちは取りまとめる権限によってこれを推進します。
gif, jpg, tiff, xwd 等を含む多くの画像タイプのための画像ビューアです。
また切り取りや拡大などといった操作機能も持っています。

%description -l de
Dies ist das berühmte 'xv' von John Bradley, ein Shareware-
Programm, das wir mit Erlaubnis des Autors liefern. Es ist
ein Grafik-Viewer für diverse Dateitypen, einschließlich gif, 
funktionen wie Trimmen, Strecken u.ä.  Mit flmask.

%description -l fr
Le célébre xv de John Bradley. C'est shareware, mais nous le distribuons
avec la permission de l'auteur. C'est un visualiseur graphique pour
de nombreux formats de fichier dont gif, jpg, tiff, xwd, etc.
Il offre aussi des fonctionnalités comme la capture, l'extension,
la retouche de palette, etc.  Flmask.

%description -l tr
xv baþta PNG, GIF, JPG, BMP, XBM, XPM olmak üzere birçok resim dosyasýný
görüntüleyebilir, deðiþik formatlarda kaydedebilir ve üzerinde boyutlandýrma,
renk deðiþtirme gibi bazý temel iþlemleri yapabilir. Çok detaylý iþlemler
yapamamasýna raðmen temel resim iþlemlerinde öncellikle kullanýlabilecek,
kullanýþlý arayüzüne sahip bir programdýr.  Flmask.


%prep
%setup -q -n xv-3.10a -a 22 -a 2 -a 3 -a 4
%__chmod -R u+w tiff

%patch0
%patch2 -p2
%patch3 -p1
%patch5
%patch6
%patch7
%patch11
%patch30
%patch31
%__patch -p1 -s < xvpng.diff
%patch32
%patch33
%patch34
%patch35
%patch36 -p1

# linux.patch and glibc.patch are needed to compile
%patch60 -p1
%patch61 -p1
%patch62 -p1

%patch44 -p1
%patch49 -p1
%patch46 -p1
%patch48 -p1
%patch50

if ! %__nkf xv-jp-extension/Patch.xv310a-ext-5.3.3 | %__patch -p1 -s ; then
# rejectcount.sh
[ ${#DEBUG} -gt 0 ] && ${SOURCE9} %PATCH70
%patch70 -p1
%__rm $( find -name \*.rej )
fi
%patch71 -p1

%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch20 -p1
%patch21 -p1
%patch72
%patch73
%patch74
%__patch -s -dtiff < xv-3.10a-towns-tiff-patch/libtiff-v3.3-towns-tiff-patch

if ! %__patch -s -p1 < XV+FLmask.v2.1/XV+FLmask.v2.1.patch; then
[ $(cat xv.h.rej | wc -l) -eq 20 ] || exit 1
rm xv.h.rej
[ $(find -name \*.rej | wc -l) -eq 0 ] || exit 1
fi
%patch75 -p1
%patch76 -p1
%patch77 -p1
%patch78 -p1
%patch79 -p1
# change document path in license message.
%__sed	-i.orig -e "/xvdocs.ps/ s;/usr/local/lib;%{_docdir}/%{name}-%{version};" xvtext.c
%patch80 -p1
%patch81 -p1
%patch82 -p1
%patch83 -p1
%patch84 -p1
%patch85 -p1
%patch86 -p1
%patch87 -p1
%patch88 -p1
%patch89 -p1
%patch90 -p1
%patch91 -p1
%patch92 -p1
%patch93 -p1
%patch94
%patch95
%patch96
%patch97

%patch99

%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
[ -f /proc/sysvipc/shm ] && \
  %__sed -i.bak -e 's/^#\(XSHM *=\|XSHMLIB *=\)/\1/' Makefile

%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1

%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1
%patch116
%patch117 -p1
%patch118 -p1
%patch119 -p1

%patch120 -p1

# fix version name
%__sed -i.orig -e '/^#define REVDATE/ s;^.*$;#define REVDATE	"Version 3.10a  Rev: 12/29/94";' -e '/^#define VERSTR/ s/^.*$/#define VERSTR	"3.10a-%{release}"/' xv.h


%build

%__make CCOPTS="${DEBUG:+-g} %{optflags} -mno-align-double" xvjpeg.o
%__make	\
	PREFIX=%{prefix} \
	BINDIR=%{bindir} \
	LIBDIR=%{_libexecdir}/xv \
	MGCSFXDIR=%{_libexecdir}/xv \
	SYSCONFDIR=%{_sysconfdir}/X11/xv \
	CC="%{__cc}" \
	CCOPTS="${DEBUG:+-g -pedantic} %{optflags}" \
	PERL="%{__perl}"

%install
%__rm -rf %{buildroot}

%__make \
	PREFIX=%{prefix} \
	BINDIR=%{bindir} \
	MANDIR=%{mandir}/man1 \
	MANSUF=1x \
	LIBDIR=%{_libexecdir}/xv \
	MGCSFXDIR=%{_libexecdir}/xv \
	SYSCONFDIR=%{_sysconfdir}/X11/xv \
	DOCDIR=%{_docdir}/%{name}-%{version} \
	PERL="%{__perl}" \
	INSTALL="%{__install} -s -m 755" \
	INSTALLDIR="%{__install} -d" \
	DESTDIR=%{buildroot} \
	install install_man

[ -f docs/xvdocs.ps.gz ] || %__gzip -9 docs/xvdocs.ps
%__cp %{SOURCE24} README.windowid

# application menu
%__mkdir_p %{buildroot}%{_datadir}/applications/
%__install -m644 %{SOURCE5} %{buildroot}%{_datadir}/applications/

%{?__upx:%__upx -9 %{buildroot}%{bindir}/xv}


%clean
%__rm -rf %{buildroot}


%files
%defattr(-,root,root)
%doc README docs/xvdocs.ps.gz BUGS CHANGELOG IDEAS README.PNG
%doc xv-jp-extension/README.xv310a-ext-5.3.3 xv-jp-extension/CHANGELOG.jp-ext
%doc xv-jp-extension/README.PhotoCD xv-jp-extension/magic.add xv_mgcsfx.sample
%doc xv-3.10a-towns-tiff-patch/README.Towns-TIFF-Patch.jp
%doc XV+FLmask.v2.1/00_README XV+FLmask.v2.1/CPMASK README.windowid
%{bindir}/*
%{_libexecdir}/xv
%{mandir}/man1/*
%{_datadir}/applications/xv.desktop


%changelog
* Sat Jun 11 2005 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-30
- added patch dither16: 24-bit to 16-bit dithering.
- fixed patch bmp16: bit padding.
- fixed patch towns-tiff: bit padding.
- fixed patch xvzoom: condition for slide.
- fixed patch wedge: fixed to work with more WM (also no WM).

* Wed Jun  1 2005 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-29
- fixed patch xv_smooth: use long long for multiplication.
- fixed patch rotatesel: fixed coordinates.
- added patch fl_refine: fix and refine code.
- added patch ansi: replace to standard functions.
- added patch minfill: resize to fill whole screen.
- fixed patch resolution: png
- added patch forcequit: 'Q' exit value 2 (for script).

* Mon May 23 2005 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-28
- set tags "Requires" and "BuildRequires", reported by ooik.
- added patch raisetext.patch: it doesn't use RaiseTextWindows().
- added patch jp_macbin: fix MacBinary check.
- added patch rotatesel: rotate with selection.
- added patch wresize: keep origin inside.
- added patch wedge: move window to screen edge.
- fixed patch xvzoom
- changed patch keyzoom: more scrool with shift.
- fixed patch showlongname
- added patch xvbrowse_pdir: turn off activate buttons for remove,
	rename and gen-icon , when parent dir is selected.
- added patch xvpopup_accel: be able to add accelarater more two ways for
	one button. and adds '^C' key for "Cancel" button.
- added patch zerolength: know zero file and ask to remove (regular file).
- changed patch glibc: use strerror().
- fixed patch jp_utf8: character count.
- added patch xvvd_passwd: support encrypted zip archive.
- added patch xvtext_vfn: send basename (for title) to TextView().
- added patch timer: removed shortsleep, use nanosleep() instead of usleep()
	replace sleep() to Timer(), set waiting time to short.
- added patch addwait: removed xvbutt_wait and xvscrl_wait.
	set wait in all loop for mouse dragging.

* Fri Aug 13 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-27
- bmp16.patch: changed colormask and bitshift to variable
	added 32bit bitfield support (not tested)

* Sun Aug  8 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-26
- added patch bmp16.patch: load 16bpp BMP file

* Fri Jul  9 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-25
- added patch forcermode.patch: remove to disable root mode menu
- added patch xvscrl_wait.patch: insert wait in scroll loop
- added patch xvscrl_button2.patch: support button2 on scrool bar

* Sun Jul  4 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-24
- fixed -dpi <DPI>
- fixed jp_mb.patch: more XmbTextEscapement (rename popup)
	and changedGSBuf rollback bug
- added xvsmooth_fix.patch: scan on fixed pixel

* Sun Apr 11 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-23
- added zlib.patch
- added unrar.patch
- added bzlib.patch
- added rpm2cpio.patch
- fixed jp_mb.patch: StringWidth (filename in Visual Schnauzer)
- added staytoppdir.patch: stop to sort '..'
- added showlongname.patch: show directory name in browse
- added selall.patch: bind ^a ^A and F in main and browse
- renamed qzoom to keyzoom

* Sun Apr  4 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-22
- added patches xv_smooth and xv_jpeg by Dave Coffin
  rewrote xv_jpeg to xv-3.10a-jpegparams, changed for libjpeg.so
- added patch browse-remember
- added patch gifir (inter lace, renamed from xv-3.10a.local.patch)
- added patch jp-ext-bzip2.patch from FreeBSD
  rewrote and named to xv-3.10a-bzip2
- added patch xv-3.10a-patch-for-resizing.txt
- updated patches jp_rej, sh_quote, and fl_make(flmask_rej)

* Thu Mar 25 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-21
- xvzoom: cleen up all functions.
	  added shm extension (disabled).

* Mon Mar 15 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-20
- xvzoom:	wheel mouse quickly smooth zooming
- xvbutt_wait:	insert wait in button loop
- shiftspace:   added shift + space to work Prev, removed tab
- added sift + side buttons work
- fixed resolution.patch: read x resource

* Sat Mar 13 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-19
- qzoom:	do zoom or pan without mouse track
- changed wheelmouse.patch: added side button, use qzoom with ctrl

* Fri Mar 12 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-18
- text_butt:	button show text encoding
- sh_quote:	quoting filenames for shell
- noblink:	disabled blink when zoom or pan in image

* Fri Mar 12 2004 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-17
- fixed jp_mb.patch
- locale-linux:	used system locale environment
- jp_utf8:	UTF-8 encoding (japanese localised) support
- text_key:	changed button labels and key binds on text window

* Sun Dec 21 2003 Kyoichiro Suda <sudakyo@fat.coara.or.jp> 3.10a-16
- rebuilt for Fedora Core 1
- timtoppm.c: removed varargs
- removed xv-3.10a-docdir.patch, to use sed
- refine file path
- removed xv.wmconfig, added xv.desktop

* Wed Apr  9 2003 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- added to support multiple byte string on all dialogue

* Sun Apr  6 2003 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- a few changes in resolution patch
- added xv-3.10a-jp_qs.patch

* Sat Jun 22 2002 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- added formatstr %%s to STR_INFO, it work with filename using %%.

* Fri Jun 21 2002 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- fixed printing width bug in resolution patch.
- changed patch path depth (grabpatch and longname.patch)

* Sat Apr 20 2002 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- fixed resize resolution, fixed y in aspect ratio
- quit if read file is zero at first time

* Fri Apr 19 2002 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- faked optimizer in pic_cache_init
- fixed missed patch for Towns 32k colors TIFF

* Thu Apr 18 2002 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- turned off alignment double, libjpeg say size of struct not match

* Tue Apr  9 2002 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- added resolution infomation, and removed tiff1200.patch
- popup menu keep insede and popup with insert key
- added some key bind in dir window and pinging color
- added env XVPATH for external binaries
- split xv-3.10a_jp.config.patch to Makefile.patch, sysconfdir.patch,
  xvexecpath.patch, docdir.patch, shortsleep.patch and jpextconfig.patch
- added japanese locale name for linux

* Tue Sep 11 2001 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- made wheel mouse patch

* Sun Jun 24 2001 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- updated xvpng fix2 to fix3
- added tiff save 1200dpi patch, changed to 120dpi
- added ghost script -dSAFER patch
- added libtiff patch, window-id patch, 32bpp BMP patch

* Mon Aug 30 1999 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
- added patches in official site recommended and optional
- fixed reject patch fo png , added flmask patch
- cleanuped spec file

* Fri May 14 1999 Kyoichiro Suda <sudakyo@fat.coara.or.jp>
-- added some patches

* Tue Aug  4 1998 Jeff Johnson <jbj@redhat.com>
- build root

* Wed Jun 10 1998 Prospector System <bugs@redhat.com>
- translations modified for de

* Fri May 08 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Wed Oct 22 1997 Donnie Barnes <djb@redhat.com>
- added wmconfig entry 

* Thu Oct 16 1997 Donnie Barnes <djb@redhat.com>
- various spec file cleanups
- added patch to manipulate PNG files

* Mon Aug 25 1997 Erik Troan <ewt@redhat.com>
- built against glibc
- incorporated new jpegv6 patch from the author's web site
