#!/bin/sh

# ----------------------------------------
remove() {
    if [ ${1:0:2} = "./" ]; then
	echo ${1:2}
    else
	echo $1
    fi
}

# ----------------------------------------
count() {
    local N I D
    N=$(remove $1)
    I=$(grep '^+' $N|wc -l)
    D=$(grep '^-' $N|wc -l)
    printf "%s:+%d-%d\n" $N $I $D
}

# ----------------------------------------
match() {
    local M
    M=$(grep "^\(\./\)\?$1:" $2)
    if [ $(echo "$M" | wc -l) -ne 1 ]; then
	echo "$1: not match"
	exit 1
    fi
    remove $M
}

# ----------------------------------------
if [ $# -eq 0 ]; then
    for I in $(find -name '*.rej'); do
	count $I
    done

# ----------------------------------------
else

    [ -f $1 ] || exit 1
    F=$1

    for I in $(find -name '*.rej'); do
	I=$(remove $I)
	R=$(count $I)
	P=$(match $I $F)
	if [ "$R" = "$P" ]; then
	    echo "$I: ok"
	else
	    echo "$I: ng"
	    exit 1
	fi
    done

fi
