#!/usr/local/bin/perl
#
#  unchc  -  UN Cern Httpd Cache.
#            Skip header of CERN httpd cache file, and write data to stdout.
#
#  Author:  Tetsuya INOUE  <tin329@chino.it.okayama-u.ac.jp>
#
#
#  Algorithm: $@%U%!%$%k$N@hF,$+$i#19T$E$D!"6u9T$^$GFI$_9~$`!#(J
#             $@$=$l$h$j8e$r%G!<%?$H$_$J$7$F!"(J1 byte $@$4$H$KFI$_9~$s$G$+$i(J
#             stdout $@$K=q$-9~$`!#(J
#             $@6u9T$O!"(JUNIX(LF, 0x0A) $@$H(J MSDOS(CR+LF, 0x0D0A) $@$r<1JL$9$k!#(J
#             $@$b$7!"(JMAC(CR, 0x0D)$@$N7A<0$,B8:_$9$k$J$i8fO"Mm2<$5$$!#(J
#
#
#  $@$3$N%W%m%0%i%`$OHs>o$K$$$$$+$2$s$J$b$N$G$9!#$*$+$7$$!"5$$KF~$i$J$$!"(J
#  $@;H$($J$$$J$I$,$"$j$^$7$?$i!"0U$r5b$s$G=$@5$7$F2<$5$$!#(J
#


sub pr_help {
    print "unchc : UN Cern Httpd Cache.\n";
    print "        Skip header of CERN httpd cache file, ",
                  "and write data to stdout.\n";
    print "usage : unchc <cern_httpd_cache_file>\n";
}

$skiped = 0;

if ($#ARGV == -1 && ! -t){
    # $@%3%^%s%I%i%$%s0z?t$,L5$/!"(Jstdin $@$,(J tty $@$G$J$1$l$P!"(Jstdin $@$+$iFI$_9~$`(J
    #  cat foo | unchc  : read stdin(foo)
    #  unchc < foo      : read stdin(foo)

    $_ = <STDIN>;
    if (! /^HTTP/) {
	print STDERR "Probably, this is not CERN httpd cache file.\n";
	exit 1;
    }
    while ($skiped == 0) {
	$_ = <STDIN>;
	if (($_ eq "\n") || ($_ eq "\r\n")) {
	    $skiped = 1;
	}
    }
    while(read(STDIN, $buf, 1)){
	print STDOUT $buf;
    }
    exit 0;

}elsif($#ARGV == 0){
    # $@%3%^%s%I%i%$%s0z?t$,#1$D$N>l9g(J
    #  unchc -h     : print help message and exit
    #  unchc -help  : print help message and exit
    #  unchc foo    : read foo
    #  unchc -      : read stdin

    if((@ARGV[0] eq "-h") || (@ARGV[0]  eq "-help")){
	&pr_help();
	exit 1;
    }elsif ((@ARGV[0] eq "-") && ! -t){
	$_ = <STDIN>;
	if (! /^HTTP/) {
	    print STDERR "Probably, this is not CERN httpd cache file.\n";
	    exit 1;
	}
	while ($skiped == 0) {
	    $_ = <STDIN>;
	    if (($_ eq "\n") || ($_ eq "\r\n")) {
		$skiped = 1;
	    }
	}
	while(read(STDIN, $buf, 1)){
	    print STDOUT $buf;
	}
    }elsif (-e @ARGV[0]){
	$fname = shift(@ARGV);
	open(FILE, $fname) || die "Can't open $fname: $!\n";

	$_ = <FILE>;
	if (! /^HTTP/) {
	    print STDERR "Probably, this is not CERN httpd cache file.\n";
	    exit 1;
	}
	while ($skiped == 0) {
	    $_ = <FILE>;
	    if (($_ eq "\n") || ($_ eq "\r\n")) {
		$skiped = 1;
	    }
	}
	while(read(FILE, $buf, 1)){
	    print STDOUT $buf;
	}
    }else{
	&pr_help();
	exit 1;
    }
    exit 0;
}else{
    # $@%3%^%s%I%i%$%s0z?t$,#20J>e$N>l9g(J $@%(%i!<(J

    &pr_help();
    exit 1;
}

# not reached
&pr_help();
exit 1;

#
# end of script.
#
