%define desktop_file 1
%define desktop_file_utils_version 0.2.90
%define t1lib_version 5.0.2
%define monolithic 1

Summary: A PDF file viewer for the X Window System.
Name: xpdf
Version: 3.00
Release: 10
License: GPL
Epoch: 1
Url: http://www.foolabs.com/xpdf/
Group: Applications/Publishing

Source0: ftp://ftp.foolabs.com/pub/xpdf/%{name}-%{version}.tar.gz
Source1: ftp://ftp.foolabs.com/pub/xpdf/t1lib-%{t1lib_version}.tar.gz
Source3: ftp://ftp.foolabs.com/pub/xpdf/xpdf-chinese-simplified.tar.gz
Source4: ftp://ftp.foolabs.com/pub/xpdf/xpdf-chinese-traditional.tar.gz
Source5: ftp://ftp.foolabs.com/pub/xpdf/xpdf-japanese.tar.gz
Source6: ftp://ftp.foolabs.com/pub/xpdf/xpdf-korean.tar.gz
Source7: ftp://ftp.foolabs.com/pub/xpdf/xpdf-cyrillic.tar.gz
Source8: ftp://ftp.foolabs.com/pub/xpdf/xpdf-thai.tar.gz
Source10: xpdf.desktop
Source11: acroread.png

Patch0: xpdf-3.00-redhat.patch
Patch1: xpdf-2.01-locale.patch
Patch2: xpdf-2.02-pdftops.patch
Patch3: xpdf-2.02-ext.patch
Patch4: xpdf-3.00-freetype.patch
Patch5: xpdf-3.0-cjk-font.patch
Patch6: xpdf-3.00-core.patch
Patch7: xpdf-3.00-xfont.patch
Patch8: xpdf-3.00-PathScanner.patch

# security
Patch100: xpdf-3.00-overflow.patch

Requires: urw-fonts
Requires: htmlview

BuildPrereq: openmotif-devel
BuildPrereq: XFree86-devel
BuildPrereq: freetype-devel >= 2.1.7
BuildPrereq: fileutils

%if %{desktop_file}
BuildPrereq: desktop-file-utils >= %{desktop_file_utils_version}
Obsoletes: %{name}-chinese-simplified
Obsoletes: %{name}-chinese-traditional
Obsoletes: %{name}-korean
Obsoletes: %{name}-japanese
%endif

BuildRoot: %{_tmppath}/%{name}-root

%package chinese-simplified
Summary: Chinese Simplified support
Requires: %{name} >= 1.00
Group: Applications/Publishing

%package chinese-traditional
Summary: Chinese Traditional support
Requires: %{name} >= 1.00
Group: Applications/Publishing

%package korean
Summary: Korean support
Requires: %{name} >= 1.00
Group: Applications/Publishing

%package japanese 
Summary: Japanese support
Requires: %{name} >= 1.00
Group: Applications/Publishing

%description
Xpdf is an X Window System based viewer for Portable Document Format
(PDF) files. Xpdf is a small and efficient program which uses
standard X fonts.

%description chinese-simplified
This package provides support files needed to use the Xpdf tools with
Chinese (Simplified) PDF files.

Contents include: Adobe-GB1 character collection support, ISO-2022-CN
encoding, and EUC-CN encoding

%description chinese-traditional
This package provides support files needed to use the Xpdf tools with
Chinese (Traditional) PDF files.

Contents include: Adobe-CNS1 character collection support and Big5
encoding

%description japanese
This package provides support files needed to use the Xpdf tools with
Japanese PDF files.

Contents include: Adobe-Japan1 character collection support,
ISO-2022-JP encoding, and EUC-JP encoding Shift-JIS encoding

%description korean
This package provides support files needed to use the Xpdf tools with
Korean PDF files.

Contents include: Adobe-Korea1 character collection support and
KSX1001 encoding

%prep
%setup -q -a 1 -a 3 -a 4 -a 5 -a 6
%patch -p1
%patch3 -p1 -b .ext
%patch4 -p1 -b .freetype217
%patch5 -p1 -b .cjk
%patch6 -p1 -b .core
%patch7 -p1 -b .fonts
%patch8 -p1 -b .xpath

# security fixes
%patch100 -p1 -b .sec

%build
find -name "*orig" | xargs rm -f
pushd t1lib-%{t1lib_version}
%configure --disable-shared --enable-static
make %{?_smp_mflags} without_doc
popd

autoconf
%configure \
   --enable-multithreaded \
   --enable-wordlist \
   --with-x \
   --with-gzip \
   --enable-opi \
   --with-appdef-dir=/usr/X11R6/lib/X11/app-defaults/ \
   --with-t1-library=`pwd`/t1lib-%{t1lib_version}/lib/.libs \
   --with-t1-includes=`pwd`/t1lib-%{t1lib_version}/lib \
   --with-freetype2-library=%{_libdir} \
   --with-freetype2-includes=%{_includedir}/freetype2

make %{?_smp_mflags}
make xpdf %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/etc/X11/applnk/Graphics \
         $RPM_BUILD_ROOT%{_datadir}/xpdf/chinese-simplified \
         $RPM_BUILD_ROOT%{_datadir}/xpdf/chinese-traditional \
         $RPM_BUILD_ROOT%{_datadir}/xpdf/japanese \
         $RPM_BUILD_ROOT%{_datadir}/xpdf/korean \
         $RPM_BUILD_ROOT%{_datadir}/icons

make install DESTDIR=$RPM_BUILD_ROOT

%if %{desktop_file}
  mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications/
  install -m 0644 %{SOURCE10} $RPM_BUILD_ROOT%{_datadir}/applications/net-xpdf.desktop
%else
  install -m 0644 %{SOURCE10} $RPM_BUILD_ROOT/etc/X11/applnk/Graphics/
%endif

install -m 0644 %{SOURCE11} $RPM_BUILD_ROOT%{_datadir}/icons/xpdf.png

cp -rf xpdf-chinese-simplified/* $RPM_BUILD_ROOT%{_datadir}/xpdf/chinese-simplified/
cp -rf xpdf-chinese-traditional/* $RPM_BUILD_ROOT%{_datadir}/xpdf/chinese-traditional/
cp -rf xpdf-japanese/* $RPM_BUILD_ROOT%{_datadir}/xpdf/japanese/
cp -rf xpdf-korean/* $RPM_BUILD_ROOT%{_datadir}/xpdf/korean/

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc CHANGES README
%{_bindir}/*
%{_mandir}/man?/*
%config(noreplace) %verify(not md5 size mtime) /etc/xpdfrc
%{_datadir}/icons/xpdf.png
%dir %{_datadir}/xpdf
%if %{desktop_file}
%{_datadir}/applications/*
%else
%attr(0644,root,root) /etc/X11/applnk/Graphics/xpdf.desktop
%endif

%if !%{monolithic}
%files chinese-simplified
%defattr(-,root,root)
%endif
%lang(zh_CN) %{_datadir}/xpdf/chinese-simplified

%if !%{monolithic}
%files chinese-traditional
%defattr(-,root,root)
%endif
%lang(zh_TW) %{_datadir}/xpdf/chinese-traditional

%if !%{monolithic}
%files japanese
%defattr(-,root,root)
%endif
%lang(ja) %{_datadir}/xpdf/japanese

%if !%{monolithic}
%files korean
%defattr(-,root,root)
%endif
%lang(ko) %{_datadir}/xpdf/korean

%changelog
* Thu Oct 21 2004 Than Ngo <than@redhat.com> 1:3.00-10
- apply patch to fix CAN-2004-0888

* Thu Oct 21 2004 Than Ngo <than@redhat.com> 1:3.00-9
- fix xpdf crash #136633

* Tue Oct 12 2004 Than Ngo <than@redhat.com> 1:3.00-8
- fix default fonts setting

* Mon Oct 11 2004 Than Ngo <than@redhat.com> 3.00-7
- fix locale issue #133911

* Thu Oct 07 2004 Than Ngo <than@redhat.com> 1:3.00-6
- Fix xpdf crash when selecting outline without page reference,
  thanks Ulrich Drepper, bz #134993

* Thu Jun 24 2004 Than Ngo <than@redhat.com> 1:3.00-5
- update t1lib upstream
- add cjk font patch, thanks to Yukihiro Nakai, bug #123540
- fix a bug in font rasterizer, bug #125559
- improve menue entry, bug #125850

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 20 2004 Than Ngo <than@redhat.com> 3.00-3
- better fix for building with freetype 2.1.7

* Tue Feb 17 2004 Than Ngo <than@redhat.com> 3.00-2 
- t1lib-5.0.1

* Tue Jan 27 2004 Than Ngo <than@redhat.com> 3.00-1
- 3.00 release
- add patch file to built with new freetype-2.1.7

* Mon Oct 13 2003 Than Ngo <than@redhat.com> 1:2.03-1
- 2.03
- remove xpdf-2.02pl1.patch, which is included in 2.03
- fix warning issue (bug #106313)
- fix huge memory leak, (bug #89552)

* Tue Jul 29 2003 Than Ngo <than@redhat.com> 1:2.02-9
- rebuild

* Tue Jul 29 2003 Than Ngo <than@redhat.com> 1:2.02-8
- add missing icon (bug #100780) 
- fix a bug xpdf resource

* Tue Jun 17 2003 Than Ngo <than@redhat.com> 2.02-7
- fixes a security hole

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon May  5 2003 Than Ngo <than@redhat.com> 2.02-4.1
- merge sub packages to main package (bug #87750)

* Fri May  2 2003 Than Ngo <than@redhat.com> 2.02-3.1
- don't install backup files

* Mon Mar 31 2003 Than Ngo <than@redhat.com> 2.02-2
- build with freetype in RHL, #79680
- unsafe temporary files, #79682
- add Xfree86-devel in buildprereq
- build with -O0 on ppc, gcc bug

* Tue Mar 25 2003 Than Ngo <than@redhat.com> 2.02-1
- 2.02
- adjust some patch files for 2.02

* Tue Feb 18 2003 Than Ngo <than@redhat.com> 2.01-8
- own /usr/share/xpdf,  #73983
- remove debug unused infos, #84197

* Tue Feb  4 2003 Than Ngo <than@redhat.com> 2.01-7
- fix #82634

* Mon Feb  3 2003 Than Ngo <than@redhat.com> 2.01-6
- fix #82633

* Mon Jan 27 2003 Than Ngo <than@redhat.com> 2.01-5
- added locale patch from ynakai@redhat.com, bug #82638

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Mon Jan 20 2003 Than Ngo <than@redhat.com> 2.01-3
- Security fixes.

* Sun Dec  8 2002 Than Ngo <than@redhat.com> 2.01-2
- urlCommand launches htmlview (bug #76694)

* Fri Dec  6 2002 Than Ngo <than@redhat.com> 2.01-1
- update to 2.01

* Wed Nov  6 2002 Than Ngo <than@redhat.com> 2.00-1
- update to 2.00
- adapt a patch file for 2.00
- build against openmotif

* Fri Sep 20 2002 Than Ngo <than@redhat.com> 1.01-9
- Build against new freetype

* Mon Aug 26 2002 Than Ngo <than@redhat.com> 1.01-8
- add descriptive name (bug #71673)

* Sat Aug 10 2002 Elliot Lee <sopwith@redhat.com>
- rebuilt with gcc-3.2 (we hope)

* Wed Jul 24 2002 Than Ngo <than@redhat.com> 1.01-6
- desktop file issue (bug #69554)

* Tue Jul 23 2002 Tim Powers <timp@redhat.com> 1.01-5
- build using gcc-3.2-0.1

* Fri Jun 21 2002 Tim Powers <timp@redhat.com> 1.01-4
- automated rebuild

* Sun Jun 2 2002 Than Ngo <than@redhat.com> 1.01-3
- fix a bug in open file dialog (bug #39844)
- 1.01 handles Type 3 fonts (bug #48843)

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Harald Hoyer <harald@redhat.de> 1.01-1
- xpdf-1.01, freetype-2.0.9

* Sun Mar 17 2002 Than Ngo <than@redhat.com> 1.00-3
- rebuild

* Wed Feb 21 2002 Than Ngo <than@redhat.com> 1.00-2
- fix Bad 'urlCommand' (bug #59730)

* Tue Feb 05 2002 Than Ngo <than@redhat.com> 1.00-1
- update to 1.00 (bug #59239, #48904)
- remove some patch files, which are included in 1.00
- sub packages for chinese-simplified, chinese-traditional, japanese and korean

* Fri Jan 25 2002 Than Ngo <than@redhat.com> 0.93-4
- rebuild in rawhide

* Mon Nov 12 2001 Than Ngo <than@redhat.com> 0.93-2
- enable Chinese GB font support
- enable Chinese CNS font support
- enable use of FreeType 2

* Mon Oct 29 2001 Than Ngo <than@redhat.com> 0.93-1
- update to 0.93

* Wed Sep 12 2001 Tim Powers <timp@redhat.com>
- rebuild with new gcc and binutils

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Fri Apr 27 2001 Bill Nottingham <notting@redhat.com>
- rebuild for C++ exception handling on ia64

* Wed Mar 28 2001 Than Ngo <than@redhat.com>
- add german translation into desktop file
- move desktop file to /etc/X11/applnk/Graphics (Bug #32720)

* Tue Jan 02 2001 Than Ngo <than@redhat.com>
- added a default URL handler script with a corresponding definition
  in Xpdf, thanks to Michal Jaegermann <michal@harddata.com> (Bug #23112)

* Mon Dec 04 2000 Than Ngo <than@redhat.com>
- updated to 0.92 (Bug #16646)
- remove some patches, which included in xpdf-0.92

* Mon Oct 16 2000 Than Ngo <than@redhat.com>
- rebuild for 7.1

* Wed Oct 11 2000 Than Ngo <than@redhat.com>
- fix update problem (Bug #17924)

* Thu Aug 17 2000 Than Ngo <than@redhat.com>
- update to 0.91 (Bug #9961 and many major bugs) 

* Sun Aug 06 2000 Than Ngo <than@redhat.de>
- added swedish translation (Bug 15312)

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jul  2 2000 Jakub Jelinek <jakub@redhat.com>
- Rebuild with new C++

* Fri Jun 16 2000 Than Ngo <than@redhat.de>
- enable Japanese font support

* Fri Jun 16 2000 Preston Brown <pbrown@redhat.com>
- FHS paths
- better .desktop entry file

* Tue Jun 06 2000 Than Ngo <than@redhat.de>
- fix xpdf crashes on some data streams (Bug# 10154) (thanks Derek)
- add %%defattr
- use rpm macros

* Tue May 23 2000 Ngo Than <than@redhat.de>
- fix problem with loading fonts

* Sun May 21 2000 Ngo Than <than@redhat.de>
- put man pages in /usr/share/man/*
- update t1lib-1.0.1

* Mon May 08 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fixed URL

* Fri Feb 11 2000 Preston Brown <pbrown@redhat.com>
- build for inclusion in 6.2.

* Wed Feb 09 2000 Jakub Jelinek <jakub@redhat.com>
- include decryption patches

* Mon Feb 07 2000 Presto Brown <pbrown@redhat.com>
- rebuild to gzip man pages

* Mon Aug 30 1999 Preston Brown <pbrown@redhat.com>
- upgrade to xpdf 0.90, include t1lib Type1 rasterizer
- fix zapfdingbats font mapping issue

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Wed Mar 17 1999 Preston Brown <pbrown@redhat.com>
- converted wmconfig to desktop entry

* Wed Feb 24 1999 Preston Brown <pbrown@redhat.com>
- Injected new description and group.

* Mon Nov 30 1998 Preston Brown <pbrown@redhat.com>
- updated to 0.80

* Fri Nov 06 1998 Preston Brown <pbrown@redhat.com>
- patched to compile with new, stricter egcs

* Tue May 05 1998 Cristian Gafton <gafton@redhat.com>
- updated to 0.7a

* Thu Nov 20 1997 Otto Hammersmith <otto@redhat.com>
- added changelog
- added wmconfig
