#!/bin/sh

SWNAME=libpng-1.2.5
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc

P=`pwd`/pkg

rm -rf $SWNAME
tar zxf $SWNAME.tar.gz
patch -p0 <<EOF
--- libpng-1.2.5/scripts/makefile.linux.orig	2002-10-03 20:32:12.000000000 +0900
+++ libpng-1.2.5/scripts/makefile.linux	2003-11-12 02:19:51.000000000 +0900
@@ -31,7 +31,7 @@
 
 # for pgcc version 2.95.1, -O3 is buggy; don't use it.
 
-CFLAGS=-I\$(ZLIBINC) -Wall -O3 -funroll-loops \\
+CFLAGS=-I\$(ZLIBINC) -Wall -O2 -funroll-loops \\
 	\$(ALIGN) # \$(WARNMORE) -g -DPNG_DEBUG=5
 
 LDFLAGS=-L. -Wl,-rpath,. -L\$(ZLIBLIB) -Wl,-rpath,\$(ZLIBLIB) -lpng12 -lz -lm
EOF
cd $SWNAME
# http://sourceforge.net/project/showfiles.php?group_id=5624&package_id=5683&release_id=257244
patch -p1 < ../libpng-1.2.5-all-patches.txt
ln -s scripts/makefile.linux Makefile
make prefix=/usr ZLIBLIB=/usr/lib ZLIBINC=/usr/include MANPATH=$MANDIR

rm -rf ${P}
mkdir -p ${P}/usr/include
mkdir -p ${P}/usr/lib
mkdir -p ${P}${MANDIR}
#make install prefix=${P}/usr MANPATH=$MANDIR
make install prefix=/usr DESTDIR=${P} MANPATH=$MANDIR
mkdir -p ${P}${DOCDIR}/$SWNAME
cp -p ../PlamoBuild.sh ANNOUNCE CHANGES KNOWNBUG LICENSE README TODO Y2KINFO ${P}${DOCDIR}/$SWNAME/.
gzip ${P}${DOCDIR}/$SWNAME/*
gzip ${P}${MANDIR}/man?/*
chown -R root:root ${P}${DOCDIR}
