/* $XFree86: xc/programs/Xserver/hw/xfree86/drivers/sis/310vtbl.h,v 1.23 2004/01/23 22:29:01 twini Exp $ */
/*
 * Register settings for SiS 315/330 series
 *
 * Copyright (C) 2001-2004 by Thomas Winischhofer, Vienna, Austria
 *
 * If distributed as part of the Linux kernel, the following license terms
 * apply:
 *
 * * This program is free software; you can redistribute it and/or modify
 * * it under the terms of the GNU General Public License as published by
 * * the Free Software Foundation; either version 2 of the named License,
 * * or any later version.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * * GNU General Public License for more details.
 * *
 * * You should have received a copy of the GNU General Public License
 * * along with this program; if not, write to the Free Software
 * * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
 *
 * Otherwise, the following license terms apply:
 *
 * * Redistribution and use in source and binary forms, with or without
 * * modification, are permitted provided that the following conditions
 * * are met:
 * * 1) Redistributions of source code must retain the above copyright
 * *    notice, this list of conditions and the following disclaimer.
 * * 2) Redistributions in binary form must reproduce the above copyright
 * *    notice, this list of conditions and the following disclaimer in the
 * *    documentation and/or other materials provided with the distribution.
 * * 3) All advertising materials mentioning features or use of this software
 * *    must display the following acknowledgement: "This product includes
 * *    software developed by Thomas Winischhofer, Vienna, Austria."
 * * 4) The name of the author may not be used to endorse or promote products
 * *    derived from this software without specific prior written permission.
 * *
 * * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESSED OR
 * * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: 	Thomas Winischhofer <thomas@winischhofer.net>
 *
 */

typedef struct _SiS310_StStruct
{
	UCHAR St_ModeID;
	USHORT St_ModeFlag;
	UCHAR St_StTableIndex;
	UCHAR St_CRT2CRTC;
	UCHAR St_ResInfo;
	UCHAR VB_StTVFlickerIndex;
	UCHAR VB_StTVEdgeIndex;
	UCHAR VB_StTVYFilterIndex;
	UCHAR St_PDC;
} SiS310_StStruct;

static const SiS310_StStruct SiS310_SModeIDTable[]=
{
	{0x01,0x9208,0x01,0x00,0x00,0x00,0x01,0x00, 0x40},
	{0x01,0x1210,0x14,0x01,0x01,0x00,0x01,0x00, 0x40},
	{0x01,0x1010,0x17,0x02,0x02,0x00,0x01,0x01, 0x40},
	{0x03,0x8208,0x03,0x00,0x00,0x00,0x01,0x02, 0x40},
	{0x03,0x0210,0x16,0x01,0x01,0x00,0x01,0x02, 0x40},
	{0x03,0x0010,0x18,0x02,0x02,0x00,0x01,0x03, 0x40},
	{0x05,0x9209,0x05,0x00,0x00,0x00,0x00,0x04, 0x40},
	{0x06,0x8209,0x06,0x00,0x00,0x00,0x00,0x05, 0x40},
	{0x07,0x0000,0x07,0x03,0x03,0x00,0x01,0x03, 0x40},
	{0x07,0x0000,0x19,0x02,0x02,0x00,0x01,0x03, 0x40},
	{0x0d,0x920a,0x0d,0x00,0x00,0x00,0x00,0x04, 0x40},
	{0x0e,0x820a,0x0e,0x00,0x00,0x00,0x00,0x05, 0x40},
	{0x0f,0x0202,0x11,0x01,0x01,0x00,0x00,0x05, 0x40},
	{0x10,0x0212,0x12,0x01,0x01,0x00,0x00,0x05, 0x40},
	{0x11,0x0212,0x1a,0x04,0x04,0x00,0x00,0x05, 0x40},
	{0x12,0x0212,0x1b,0x04,0x04,0x00,0x00,0x05, 0x40},
	{0x13,0x021b,0x1c,0x00,0x00,0x00,0x00,0x04, 0x40},
	{0x12,0x0010,0x18,0x02,0x02,0x00,0x00,0x05, 0x40},
	{0x12,0x0210,0x18,0x01,0x01,0x00,0x00,0x05, 0x40},
	{0xff,0x0000,0x00,0x00,0x00,0x00,0x00,0x00, 0x40}
};

typedef struct _SiS310_ExtStruct
{
	UCHAR  Ext_ModeID;
	USHORT Ext_ModeFlag;
	UCHAR  Ext_ModeOffset;
	USHORT Ext_VESAID;
	UCHAR  Ext_RESINFO;
	UCHAR  VB_ExtTVFlickerIndex;
	UCHAR  VB_ExtTVEdgeIndex;
	UCHAR  VB_ExtTVYFilterIndex;
	UCHAR  VB_ExtTVYFilterIndexROM661;
	UCHAR  REFindex;
} SiS310_ExtStruct;

static const SiS310_ExtStruct  SiS310_EModeIDTable[]=
{
	{0x6a,0x2212,0x04,0x0102,SIS_RI_800x600,  0x00,0x00,0x07,0x06,0x00}, /* 800x600x? */
	{0x2e,0x0a1b,0x03,0x0101,SIS_RI_640x480,  0x00,0x00,0x05,0x05,0x08}, /* 640x480x8 */
        {0x2f,0x0a1b,0x03,0x0100,SIS_RI_640x400,  0x00,0x00,0x05,0x05,0x10}, /* 640x400x8 */
	{0x30,0x2a1b,0x04,0x0103,SIS_RI_800x600,  0x00,0x00,0x07,0x06,0x00}, /* 800x600x8 */
        {0x31,0x0a1b,0x0a,0x0000,SIS_RI_720x480,  0x00,0x00,0x06,0x06,0x11}, /* 720x480x8 */
	{0x32,0x0a1b,0x0a,0x0000,SIS_RI_720x576,  0x00,0x00,0x06,0x06,0x12}, /* 720x576x8 */
	{0x33,0x0a1d,0x0a,0x0000,SIS_RI_720x480,  0x00,0x00,0x06,0x06,0x11}, /* 720x480x16 */
	{0x34,0x2a1d,0x0a,0x0000,SIS_RI_720x576,  0x00,0x00,0x06,0x06,0x12}, /* 720x576x16 */
	{0x35,0x0a1f,0x0a,0x0000,SIS_RI_720x480,  0x00,0x00,0x06,0x06,0x11}, /* 720x480x32 */
	{0x36,0x2a1f,0x0a,0x0000,SIS_RI_720x576,  0x00,0x00,0x06,0x06,0x12}, /* 720x576x32 */
	{0x37,0x0212,0x05,0x0104,SIS_RI_1024x768, 0x00,0x00,0x08,0x07,0x13}, /* 1024x768x? */
	{0x38,0x0a1b,0x05,0x0105,SIS_RI_1024x768, 0x00,0x00,0x08,0x07,0x13}, /* 1024x768x8 */
	{0x3a,0x0e3b,0x06,0x0107,SIS_RI_1280x1024,0x00,0x00,0x00,0x00,0x1a}, /* 1280x1024x8 */
	{0x3c,0x0e3b,0x07,0x0130,SIS_RI_1600x1200,0x00,0x00,0x00,0x00,0x1e}, /* 1600x1200x8 */
	{0x3d,0x0e7d,0x07,0x0131,SIS_RI_1600x1200,0x00,0x00,0x00,0x00,0x1e}, /* 1600x1200x16 */
	{0x40,0x9a1c,0x00,0x010d,SIS_RI_320x200,  0x00,0x00,0x04,0x04,0x25}, /* 320x200x15 */
	{0x41,0x9a1d,0x00,0x010e,SIS_RI_320x200,  0x00,0x00,0x04,0x04,0x25}, /* 320x200x16 */
	{0x43,0x0a1c,0x03,0x0110,SIS_RI_640x480,  0x00,0x00,0x05,0x05,0x08},
	{0x44,0x0a1d,0x03,0x0111,SIS_RI_640x480,  0x00,0x00,0x05,0x05,0x08}, /* 640x480x16 */
	{0x46,0x2a1c,0x04,0x0113,SIS_RI_800x600,  0x00,0x00,0x07,0x06,0x00},
	{0x47,0x2a1d,0x04,0x0114,SIS_RI_800x600,  0x00,0x00,0x07,0x06,0x00}, /* 800x600x16 */
	{0x49,0x0a3c,0x05,0x0116,SIS_RI_1024x768, 0x00,0x00,0x00,0x07,0x13},
	{0x4a,0x0a3d,0x05,0x0117,SIS_RI_1024x768, 0x00,0x00,0x08,0x07,0x13}, /* 1024x768x16 */
	{0x4c,0x0e7c,0x06,0x0119,SIS_RI_1280x1024,0x00,0x00,0x00,0x00,0x1a},
	{0x4d,0x0e7d,0x06,0x011a,SIS_RI_1280x1024,0x00,0x00,0x00,0x00,0x1a}, /* 1280x1024x16 */
	{0x50,0x9a1b,0x00,0x0132,SIS_RI_320x240,  0x00,0x00,0x04,0x04,0x26}, /* 320x240x8  */
	{0x51,0xba1b,0x01,0x0133,SIS_RI_400x300,  0x00,0x00,0x07,0x07,0x27}, /* 400x300x8  */
  	{0x52,0xba1b,0x02,0x0134,SIS_RI_512x384,  0x00,0x00,0x00,0x00,0x28}, /* 512x384x8  */
	{0x56,0x9a1d,0x00,0x0135,SIS_RI_320x240,  0x00,0x00,0x04,0x04,0x26}, /* 320x240x16 */
	{0x57,0xba1d,0x01,0x0136,SIS_RI_400x300,  0x00,0x00,0x07,0x07,0x27}, /* 400x300x16 */
 	{0x58,0xba1d,0x02,0x0137,SIS_RI_512x384,  0x00,0x00,0x00,0x00,0x28}, /* 512x384x16 */
	{0x59,0x9a1b,0x00,0x0138,SIS_RI_320x200,  0x00,0x00,0x04,0x04,0x25}, /* 320x200x8  */
	{0x5a,0x021b,0x00,0x0138,SIS_RI_320x240,  0x00,0x00,0x00,0x00,0x3f}, /* 320x240x8  fstn */
	{0x5b,0x0a1d,0x00,0x0135,SIS_RI_320x240,  0x00,0x00,0x00,0x00,0x3f}, /* 320x240x16 fstn */
	{0x5c,0xba1f,0x02,0x0000,SIS_RI_512x384,  0x00,0x00,0x00,0x00,0x28}, /* 512x384x32 */
	{0x5d,0x0a1d,0x03,0x0139,SIS_RI_640x400,  0x00,0x00,0x05,0x07,0x10},
	{0x5e,0x0a1f,0x03,0x0000,SIS_RI_640x400,  0x00,0x00,0x05,0x07,0x10}, /* 640x400x32 */
	{0x62,0x0a3f,0x03,0x013a,SIS_RI_640x480,  0x00,0x00,0x05,0x05,0x08}, /* 640x480x32 */
	{0x63,0x2a3f,0x04,0x013b,SIS_RI_800x600,  0x00,0x00,0x07,0x06,0x00}, /* 800x600x32 */
	{0x64,0x0a7f,0x05,0x013c,SIS_RI_1024x768, 0x00,0x00,0x08,0x07,0x13}, /* 1024x768x32 */
	{0x65,0x0eff,0x06,0x013d,SIS_RI_1280x1024,0x00,0x00,0x00,0x00,0x1a}, /* 1280x1024x32 */
	{0x66,0x0eff,0x07,0x013e,SIS_RI_1600x1200,0x00,0x00,0x00,0x00,0x1e}, /* 1600x1200x32 */
	{0x68,0x067b,0x08,0x013f,SIS_RI_1920x1440,0x00,0x00,0x00,0x00,0x29}, /* 1920x1440x8 */
	{0x69,0x06fd,0x08,0x0140,SIS_RI_1920x1440,0x00,0x00,0x00,0x00,0x29}, /* 1920x1440x16 */
	{0x6b,0x07ff,0x08,0x0141,SIS_RI_1920x1440,0x00,0x00,0x00,0x00,0x29}, /* 1920x1440x32 */
	{0x6c,0x067b,0x09,0x0000,SIS_RI_2048x1536,0x00,0x00,0x00,0x00,0x2f}, /* 2048x1536x8 */
	{0x6d,0x06fd,0x09,0x0000,SIS_RI_2048x1536,0x00,0x00,0x00,0x00,0x2f}, /* 2048x1536x16 */
	{0x6e,0x07ff,0x09,0x0000,SIS_RI_2048x1536,0x00,0x00,0x00,0x00,0x2f}, /* 2048x1536x32 */
	{0x70,0x2a1b,0x04,0x0000,SIS_RI_800x480,  0x00,0x00,0x07,0x07,0x34}, /* 800x480x8 */
	{0x71,0x0a1b,0x05,0x0000,SIS_RI_1024x576, 0x00,0x00,0x00,0x00,0x37}, /* 1024x576x8 */
	{0x74,0x0a1d,0x05,0x0000,SIS_RI_1024x576, 0x00,0x00,0x00,0x00,0x37}, /* 1024x576x16 */
	{0x75,0x0a3d,0x06,0x0000,SIS_RI_1280x720, 0x00,0x00,0x00,0x00,0x3a}, /* 1280x720x16 */
	{0x76,0x2a1f,0x04,0x0000,SIS_RI_800x480,  0x00,0x00,0x07,0x07,0x34}, /* 800x480x32 */
	{0x77,0x0a1f,0x05,0x0000,SIS_RI_1024x576, 0x00,0x00,0x00,0x00,0x37}, /* 1024x576x32 */
	{0x78,0x0a3f,0x06,0x0000,SIS_RI_1280x720, 0x00,0x00,0x00,0x00,0x3a}, /* 1280x720x32 */
	{0x79,0x0a3b,0x06,0x0000,SIS_RI_1280x720, 0x00,0x00,0x00,0x00,0x3a}, /* 1280x720x8 */
	{0x7a,0x2a1d,0x04,0x0000,SIS_RI_800x480,  0x00,0x00,0x07,0x07,0x34}, /* 800x480x16 */
	{0x7c,0x0e3b,0x06,0x0000,SIS_RI_1280x960, 0x00,0x00,0x00,0x00,0x3d}, /* 1280x960x8 */
	{0x7d,0x0e7d,0x06,0x0000,SIS_RI_1280x960, 0x00,0x00,0x00,0x00,0x3d}, /* 1280x960x16 */
	{0x7e,0x0eff,0x06,0x0000,SIS_RI_1280x960, 0x00,0x00,0x00,0x00,0x3d}, /* 1280x960x32 */
	{0x23,0x0e3b,0x06,0x0000,SIS_RI_1280x768, 0x00,0x00,0x00,0x00,0x40}, /* 1280x768x8 */
	{0x24,0x0e7d,0x06,0x0000,SIS_RI_1280x768, 0x00,0x00,0x00,0x00,0x40}, /* 1280x768x16 */
	{0x25,0x0eff,0x06,0x0000,SIS_RI_1280x768, 0x00,0x00,0x00,0x00,0x40}, /* 1280x768x32 */
	{0x26,0x0e3b,0x0c,0x0000,SIS_RI_1400x1050,0x00,0x00,0x00,0x00,0x41}, /* 1400x1050x8 */
	{0x27,0x0e7d,0x0c,0x0000,SIS_RI_1400x1050,0x00,0x00,0x00,0x00,0x41}, /* 1400x1050x16 */
	{0x28,0x0eff,0x0c,0x0000,SIS_RI_1400x1050,0x00,0x00,0x00,0x00,0x41}, /* 1400x1050x32*/
	{0x29,0x0e1b,0x0d,0x0000,SIS_RI_1152x864, 0x00,0x00,0x00,0x00,0x43}, /* 1152x864 */
	{0x2a,0x0e3d,0x0d,0x0000,SIS_RI_1152x864, 0x00,0x00,0x00,0x00,0x43},
	{0x2b,0x0e7f,0x0d,0x0000,SIS_RI_1152x864, 0x00,0x00,0x00,0x00,0x43},
	{0x39,0x2a1b,0x0b,0x0000,SIS_RI_848x480,  0x00,0x00,0x00,0x00,0x45}, /* 848x480 */
	{0x3b,0x2a3d,0x0b,0x0000,SIS_RI_848x480,  0x00,0x00,0x00,0x00,0x45},
	{0x3e,0x2a7f,0x0b,0x0000,SIS_RI_848x480,  0x00,0x00,0x00,0x00,0x45},
	{0x3f,0x2a1b,0x0b,0x0000,SIS_RI_856x480,  0x00,0x00,0x00,0x00,0x47}, /* 856x480 */
	{0x42,0x2a3d,0x0b,0x0000,SIS_RI_856x480,  0x00,0x00,0x00,0x00,0x47},
	{0x45,0x2a7f,0x0b,0x0000,SIS_RI_856x480,  0x00,0x00,0x00,0x00,0x47},
	{0x48,0x2a1b,0x0e,0x0000,SIS_RI_1360x768, 0x00,0x00,0x00,0x00,0x49}, /* 1360x768 */
	{0x4b,0x2a3d,0x0e,0x0000,SIS_RI_1360x768, 0x00,0x00,0x00,0x00,0x49},
	{0x4e,0x2a7f,0x0e,0x0000,SIS_RI_1360x768, 0x00,0x00,0x00,0x00,0x49},
	{0x4f,0x9a1f,0x00,0x0000,SIS_RI_320x200,  0x00,0x00,0x04,0x04,0x25}, /* 320x200x32 */
	{0x53,0x9a1f,0x00,0x0000,SIS_RI_320x240,  0x00,0x00,0x04,0x04,0x26}, /* 320x240x32 */
	{0x54,0xba1f,0x01,0x0000,SIS_RI_400x300,  0x00,0x00,0x07,0x07,0x27}, /* 400x300x32 */
	{0x5f,0x2a1b,0x0f,0x0000,SIS_RI_768x576,  0x00,0x00,0x06,0x06,0x4a}, /* 768x576x8 */
	{0x60,0x2a1d,0x0f,0x0000,SIS_RI_768x576,  0x00,0x00,0x06,0x06,0x4a}, /* 768x576x16 */
	{0x61,0x2a1f,0x0f,0x0000,SIS_RI_768x576,  0x00,0x00,0x06,0x06,0x4a}, /* 768x576x32 */
	{0xff,0x0000,0x00,0x0000,0,               0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS310_Ext2Struct
{
	USHORT Ext_InfoFlag;
	UCHAR  Ext_CRT1CRTC;
	UCHAR  Ext_CRTVCLK;
	UCHAR  Ext_CRT2CRTC;
	UCHAR  ModeID;
	USHORT XRes;
	USHORT YRes;
	UCHAR  Ext_PDC;
} SiS310_Ext2Struct;

static const SiS310_Ext2Struct SiS310_RefIndex[]=
{
	{0x085f,0x0d,0x03,0x05,0x6a, 800, 600, 0x40}, /* 0x0 */
	{0x0067,0x0e,0x04,0x05,0x6a, 800, 600, 0x40}, /* 0x1 */
	{0x0067,0x0f,0x08,0x48,0x6a, 800, 600, 0x40}, /* 0x2 */
	{0x0067,0x10,0x07,0x8b,0x6a, 800, 600, 0x40}, /* 0x3 */
	{0x0047,0x11,0x0a,0x00,0x6a, 800, 600, 0x40}, /* 0x4 */
	{0x0047,0x12,0x0d,0x00,0x6a, 800, 600, 0x40}, /* 0x5 */
	{0x0047,0x13,0x13,0x00,0x6a, 800, 600, 0x20}, /* 0x6 */
	{0x0107,0x14,0x1c,0x00,0x6a, 800, 600, 0x20}, /* 0x7 */
	{0xc85f,0x05,0x00,0x04,0x2e, 640, 480, 0x40}, /* 0x8 */
	{0xc067,0x06,0x02,0x04,0x2e, 640, 480, 0x40}, /* 0x9 */
	{0xc067,0x07,0x02,0x47,0x2e, 640, 480, 0x40}, /* 0xa */
	{0xc067,0x08,0x03,0x8a,0x2e, 640, 480, 0x40}, /* 0xb */
	{0xc047,0x09,0x05,0x00,0x2e, 640, 480, 0x40}, /* 0xc */
	{0xc047,0x0a,0x09,0x00,0x2e, 640, 480, 0x40}, /* 0xd */
	{0xc047,0x0b,0x0e,0x00,0x2e, 640, 480, 0x40}, /* 0xe */
	{0xc047,0x0c,0x15,0x00,0x2e, 640, 480, 0x40}, /* 0xf */
	{0x487f,0x04,0x00,0x00,0x2f, 640, 400, 0x30}, /* 0x10 */
	{0xc04f,0x3c,0x01,0x06,0x31, 720, 480, 0x30}, /* 0x11 */
	{0x004f,0x3d,0x03,0x06,0x32, 720, 576, 0x30}, /* 0x12 */
	{0x0087,0x15,0x06,0x00,0x37,1024, 768, 0x30}, /* 0x13 */
	{0xc877,0x16,0x0b,0x06,0x37,1024, 768, 0x20}, /* 0x14 */
	{0xc067,0x17,0x0f,0x49,0x37,1024, 768, 0x20}, /* 0x15 */
	{0x0067,0x18,0x11,0x00,0x37,1024, 768, 0x20}, /* 0x16 */
	{0x0047,0x19,0x16,0x8c,0x37,1024, 768, 0x20}, /* 0x17 */
	{0x0107,0x1a,0x1b,0x00,0x37,1024, 768, 0x10}, /* 0x18 */
	{0x0107,0x1b,0x1f,0x00,0x37,1024, 768, 0x10}, /* 0x19 */
	{0x0087,0x1c,0x11,0x00,0x3a,1280,1024, 0x30}, /* 0x1a */
	{0x0137,0x1d,0x19,0x07,0x3a,1280,1024, 0x00}, /* 0x1b */
	{0x0107,0x1e,0x1e,0x00,0x3a,1280,1024, 0x00}, /* 0x1c */
	{0x0207,0x1f,0x20,0x00,0x3a,1280,1024, 0x00}, /* 0x1d */
	{0x0227,0x20,0x21,0x09,0x3c,1600,1200, 0x00}, /* 0x1e */
	{0x0407,0x21,0x22,0x00,0x3c,1600,1200, 0x00}, /* 0x1f */
	{0x0407,0x22,0x23,0x00,0x3c,1600,1200, 0x00}, /* 0x20 */
	{0x0407,0x23,0x25,0x00,0x3c,1600,1200, 0x00}, /* 0x21 */
	{0x0007,0x24,0x26,0x00,0x3c,1600,1200, 0x00}, /* 0x22 */
	{0x0007,0x25,0x2c,0x00,0x3c,1600,1200, 0x00}, /* 0x23 */
	{0x0007,0x26,0x34,0x00,0x3c,1600,1200, 0x00}, /* 0x24 */
	{0x407f,0x00,0x00,0x00,0x40, 320, 200, 0x30}, /* 0x25 */
	{0xc07f,0x01,0x00,0x04,0x50, 320, 240, 0x30}, /* 0x26 */
	{0x007f,0x02,0x04,0x05,0x51, 400, 300, 0x30}, /* 0x27 */
	{0xc077,0x03,0x0b,0x06,0x52, 512, 384, 0x30}, /* 0x28 */
	{0x8007,0x27,0x27,0x00,0x68,1920,1440, 0x00}, /* 0x29 */
	{0x4007,0x28,0x29,0x00,0x68,1920,1440, 0x00}, /* 0x2a */
	{0x4007,0x29,0x2e,0x00,0x68,1920,1440, 0x00}, /* 0x2b */
	{0x4007,0x2a,0x30,0x00,0x68,1920,1440, 0x00}, /* 0x2c */
	{0x4007,0x2b,0x35,0x00,0x68,1920,1440, 0x00}, /* 0x2d */
	{0x4005,0x2c,0x39,0x00,0x68,1920,1440, 0x00}, /* 0x2e */
	{0x4007,0x2d,0x2b,0x00,0x6c,2048,1536, 0x00}, /* 0x2f */
	{0x4007,0x2e,0x31,0x00,0x6c,2048,1536, 0x00}, /* 0x30 */
	{0x4007,0x2f,0x33,0x00,0x6c,2048,1536, 0x00}, /* 0x31 */
	{0x4007,0x30,0x37,0x00,0x6c,2048,1536, 0x00}, /* 0x32 */
	{0x4005,0x31,0x38,0x00,0x6c,2048,1536, 0x00}, /* 0x33 */
	{0x0057,0x32,0x40,0x08,0x70, 800, 480, 0x30}, /* 0x34 */
	{0x0047,0x33,0x07,0x08,0x70, 800, 480, 0x30}, /* 0x35 */
	{0x0047,0x34,0x0a,0x08,0x70, 800, 480, 0x30}, /* 0x36 */
	{0x0057,0x35,0x0b,0x09,0x71,1024, 576, 0x30}, /* 0x37 */
	{0x0047,0x36,0x11,0x09,0x71,1024, 576, 0x30}, /* 0x38 */
	{0x0047,0x37,0x16,0x09,0x71,1024, 576, 0x30}, /* 0x39 */
	{0x0117,0x38,0x19,0x0a,0x75,1280, 720, 0x30}, /* 0x3a */
	{0x0107,0x39,0x1e,0x0a,0x75,1280, 720, 0x30}, /* 0x3b */
	{0x0207,0x3a,0x20,0x0a,0x75,1280, 720, 0x30}, /* 0x3c */
	{0x0127,0x3b,0x19,0x08,0x7c,1280, 960, 0x30}, /* 0x3d */
	{0x0227,0x4c,0x59,0x08,0x7c,1280, 960, 0x20}, /* 0x3e */
	{0xc07f,0x4e,0x00,0x06,0x5a, 320, 240, 0x30}, /* 0x3f */    /* FSTN 320x240 */
        {0x0077,0x42,0x5b,0x08,0x23,1280, 768, 0x30}, /* 0x40 */    /* TW: 0x5b was 0x12 */
	{0x0127,0x43,0x4d,0x08,0x26,1400,1050, 0x30}, /* 0x41 */
	{0x0207,0x4b,0x5a,0x08,0x26,1400,1050, 0x30}, /* 0x42 Non-BIOS, new */
	{0x0107,0x44,0x19,0x00,0x29,1152, 864, 0x30}, /* 0x43 Non-BIOS, new */
	{0x0107,0x4a,0x1e,0x00,0x29,1152, 864, 0x30}, /* 0x44 Non-BIOS, new */
	{0x0087,0x45,0x57,0x00,0x39, 848, 480, 0x30}, /* 0x45 848x480-38Hzi - Non-BIOS, new */
	{0xc067,0x46,0x55,0x0b,0x39, 848, 480, 0x30}, /* 0x46 848x480-60Hz  - Non-BIOS, new */
	{0x0087,0x47,0x57,0x00,0x3f, 856, 480, 0x30}, /* 0x47 856x480-38Hzi - Non-BIOS, new */
	{0xc047,0x48,0x57,0x00,0x3f, 856, 480, 0x30}, /* 0x48 856x480-60Hz  - Non-BIOS, new */
	{0x0067,0x49,0x58,0x0c,0x48,1360, 768, 0x30}, /* 0x49 1360x768-60Hz - Non-BIOS, new */
	{0x004f,0x4d,0x03,0x06,0x5f, 768, 576, 0x30}, /* 0x4a 768x576 */
	{0xffff,0x00,0x00,0x00,0x00,   0,   0, 0}
};

typedef struct _SiS310_CRT1TableStruct
{
 	UCHAR CR[17];
} SiS310_CRT1TableStruct;

static const SiS310_CRT1TableStruct SiS310_CRT1Table[]=
{
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x00,
   0x00}}, /* 0x0 */
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
   0x00}}, /* 0x1 */
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,
   0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
   0x01}}, /* 0x2 */
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
   0x01}}, /* 0x3 */
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x05,
   0x00}}, /* 0x4 */
#if 0
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
   0x00}}, /* 0x5 */
#endif   
 {{0x5f,0x4f,0x4f,0x83,0x55,0x81,0x0b,0x3e,    /* 0x05 - corrected 640x480-60 */
   0xe9,0x8b,0xdf,0xe8,0x0c,0x00,0x00,0x05,
   0x00}},
#if 0   
 {{0x63,0x4f,0x50,0x86,0x56,0x9b,0x06,0x3e,
   0xe8,0x8b,0xdf,0xe7,0xff,0x10,0x00,0x01,
   0x00}}, /* 0x6 */
#endif
 {{0x63,0x4f,0x4f,0x87,0x56,0x9b,0x06,0x3e,    /* 0x06 - corrected 640x480-72 */
   0xe8,0x8a,0xdf,0xe7,0x07,0x00,0x00,0x01,
   0x00}},
 {{0x64,0x4f,0x4f,0x88,0x55,0x9d,0xf2,0x1f,
   0xe0,0x83,0xdf,0xdf,0xf3,0x10,0x00,0x01,
   0x00}}, /* 0x7 */
 {{0x63,0x4f,0x4f,0x87,0x5a,0x81,0xfb,0x1f,
   0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,
   0x00}}, /* 0x8 */
 {{0x65,0x4f,0x4f,0x89,0x58,0x80,0xfb,0x1f,
   0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,  /* TW: Corrected VBE */
   0x61}}, /* 0x9 */
 {{0x65,0x4f,0x4f,0x89,0x58,0x80,0x01,0x3e,
   0xe0,0x83,0xdf,0xdf,0x02,0x00,0x00,0x05,
   0x61}}, /* 0xa */
 {{0x67,0x4f,0x4f,0x8b,0x58,0x81,0x0d,0x3e,
   0xe0,0x83,0xdf,0xdf,0x0e,0x00,0x00,0x05,  /* TW: Corrected VBE */
   0x61}}, /* 0xb */
 {{0x65,0x4f,0x4f,0x89,0x57,0x9f,0xfb,0x1f,
   0xe6,0x8a,0xdf,0xdf,0xfc,0x10,0x00,0x01,  /* TW: Corrected VDE, VBE */
   0x00}}, /* 0xc */
 {{0x7b,0x63,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
   0x58,0x8a,0x57,0x57,0x70,0x20,0x00,0x05,
   0x01}}, /* 0xd */
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x06,
   0x01}}, /* 0xe */
 {{0x7d,0x63,0x63,0x81,0x6e,0x1d,0x98,0xf0,
   0x7c,0x82,0x57,0x57,0x99,0x00,0x00,0x06,
   0x01}}, /* 0xf */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xf0,
   0x58,0x8b,0x57,0x57,0x70,0x20,0x00,0x06,
   0x01}}, /* 0x10 */
 {{0x7e,0x63,0x63,0x82,0x6b,0x13,0x75,0xf0,
   0x58,0x8b,0x57,0x57,0x76,0x20,0x00,0x06,
   0x01}}, /* 0x11 */
 {{0x81,0x63,0x63,0x85,0x6d,0x18,0x7a,0xf0,
   0x58,0x8b,0x57,0x57,0x7b,0x20,0x00,0x06,
   0x61}}, /* 0x12 */
 {{0x83,0x63,0x63,0x87,0x6e,0x19,0x81,0xf0,
   0x58,0x8b,0x57,0x57,0x82,0x20,0x00,0x06,
   0x61}}, /* 0x13 */
 {{0x85,0x63,0x63,0x89,0x6f,0x1a,0x91,0xf0,
   0x58,0x8b,0x57,0x57,0x92,0x20,0x00,0x06,
   0x61}}, /* 0x14 */
 {{0x99,0x7f,0x7f,0x9d,0x84,0x1a,0x96,0x1f,
   0x7f,0x83,0x7f,0x7f,0x97,0x10,0x00,0x02,
   0x00}}, /* 0x15 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}, /* 0x16 */
 {{0xa1,0x7f,0x7f,0x85,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}, /* 0x17 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf5,
   0x00,0x83,0xff,0xff,0x1f,0x10,0x00,0x02,
   0x01}}, /* 0x18 */
 {{0xa7,0x7f,0x7f,0x8b,0x89,0x95,0x26,0xf5,
   0x00,0x83,0xff,0xff,0x27,0x10,0x00,0x02,
   0x01}}, /* 0x19 */
 {{0xa9,0x7f,0x7f,0x8d,0x8c,0x9a,0x2c,0xf5,
   0x00,0x83,0xff,0xff,0x2d,0x14,0x00,0x02,
   0x62}}, /* 0x1a */
 {{0xab,0x7f,0x7f,0x8f,0x8d,0x9b,0x35,0xf5,
   0x00,0x83,0xff,0xff,0x36,0x14,0x00,0x02,
   0x62}}, /* 0x1b */
 {{0xcf,0x9f,0x9f,0x93,0xb2,0x01,0x14,0xba,
   0x00,0x83,0xff,0xff,0x15,0x00,0x00,0x03,
   0x00}}, /* 0x1c */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0x5a,
   0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
   0x01}}, /* 0x1d */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0x5a,
   0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
   0x01}}, /* 0x1e */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0x5a,
   0x00,0x83,0xff,0xff,0x2f,0x09,0x00,0x07,
   0x01}}, /* 0x1f */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x20 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x21 @ 4084 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x22 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x23 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x24 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x25 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
   0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
   0x00}}, /* 0x26 */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x27 */
 {{0x43,0xef,0xef,0x87,0x06,0x00,0xd4,0x1f,
   0xa0,0x83,0x9f,0x9f,0xd5,0x1f,0x41,0x05,
   0x63}}, /* 0x28 */
 {{0x45,0xef,0xef,0x89,0x07,0x01,0xd9,0x1f,
   0xa0,0x83,0x9f,0x9f,0xda,0x1f,0x41,0x05,
   0x63}}, /* 0x29 */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x2a */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x2b */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
   0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
   0x00}}, /* 0x2c */
 {{0x59,0xff,0xff,0x9d,0x17,0x13,0x33,0xba,
   0x00,0x83,0xff,0xff,0x34,0x0f,0x41,0x05,
   0x44}}, /* 0x2d */
 {{0x5b,0xff,0xff,0x9f,0x18,0x14,0x38,0xba,
   0x00,0x83,0xff,0xff,0x39,0x0f,0x41,0x05,
   0x44}}, /* 0x2e */
 {{0x5b,0xff,0xff,0x9f,0x18,0x14,0x3d,0xba,
   0x00,0x83,0xff,0xff,0x3e,0x0f,0x41,0x05,
   0x44}}, /* 0x2f */
 {{0x5d,0xff,0xff,0x81,0x19,0x95,0x41,0xba,
   0x00,0x84,0xff,0xff,0x42,0x0f,0x41,0x05,
   0x44}}, /* 0x30 */
 {{0x55,0xff,0xff,0x99,0x0d,0x0c,0x3e,0xba,
   0x00,0x84,0xff,0xff,0x3f,0x0f,0x41,0x05,
   0x00}}, /* 0x31 */
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,
   0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
   0x01}}, /* 0x32 */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
   0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
   0x01}}, /* 0x33 */
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
   0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
   0x01}}, /* 0x34 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
   0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
   0x01}}, /* 0x35 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
   0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
   0x01}}, /* 0x36 */
 {{0xa7,0x7f,0x7f,0x88,0x89,0x95,0x26,0xf1,   /* TW: 95 was 15 - illegal HBE! */
   0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
   0x01}}, /* 0x37 */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
   0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
   0x01}}, /* 0x38 */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
   0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
   0x01}}, /* 0x39 */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
   0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
   0x01}}, /* 0x3a */
#if 0   
 {{0xdc,0x9f,0x9f,0x00,0xab,0x19,0xe6,0xef,	/* 1280x960 - invalid */
   0xc0,0xc3,0xbf,0xbf,0xe7,0x10,0x00,0x07,
   0x01}}, /* 0x3b */
#endif  
 {{0xdc,0x9f,0x9f,0x80,0xaf,0x9d,0xe6,0xff,	/* 1280x960-60 - corrected */
   0xc0,0x83,0xbf,0xbf,0xe7,0x10,0x00,0x07,
   0x01}}, /* 0x3b */ 
 {{0x6b,0x59,0x59,0x8f,0x5e,0x8c,0x0b,0x3e,
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
   0x00}}, /* 0x3c */
 {{0x7b,0x59,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
   0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
   0x01}}, /* 0x3d */
 {{0x86,0x6a,0x6a,0x8a,0x74,0x06,0x8c,0x15,
   0x4f,0x83,0xef,0xef,0x8d,0x30,0x00,0x02,
   0x00}}, /* 0x3e */
 {{0x81,0x6a,0x6a,0x85,0x70,0x00,0x0f,0x3e,
   0xeb,0x8e,0xdf,0xdf,0x10,0x00,0x00,0x02,
   0x00}}, /* 0x3f */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x1e,0xf1,   /* TW: The following from 650/LVDS BIOS */
   0xae,0x85,0x57,0x57,0x1f,0x30,0x00,0x02,
   0x01}},  /* 0x40 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}},  /* 0x41 */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x20,0xf5,
   0x03,0x88,0xff,0xff,0x21,0x10,0x00,0x07,
   0x01}},  /* 0x42 */
 {{0xe6,0xae,0xae,0x8a,0xbd,0x90,0x3d,0x10,
   0x1a,0x8d,0x19,0x19,0x3e,0x2f,0x00,0x03,
   0x00}},  /* 0x43 */
 {{0xc3,0x8f,0x8f,0x87,0x9b,0x0b,0x82,0xef, /* New, 1152x864-75, not in BIOS */
   0x60,0x83,0x5f,0x5f,0x83,0x10,0x00,0x07,
   0x01}},  /* 0x44 */
 {{0x86,0x69,0x69,0x8A,0x74,0x06,0x8C,0x15, /* New, 848x480-38i, not in BIOS */
   0x4F,0x83,0xEF,0xEF,0x8D,0x30,0x00,0x02,
   0x00}},  /* 0x45 */
 {{0x83,0x69,0x69,0x87,0x6f,0x1d,0x03,0x3E, /* New, 848x480-60, not in BIOS */
   0xE5,0x8d,0xDF,0xe4,0x04,0x00,0x00,0x06,
   0x00}},  /* 0x46 */
 {{0x86,0x6A,0x6A,0x8A,0x74,0x06,0x8C,0x15, /* New, 856x480-38i, not in BIOS */
   0x4F,0x83,0xEF,0xEF,0x8D,0x30,0x00,0x02,
   0x00}},  /* 0x47 */
 {{0x81,0x6A,0x6A,0x85,0x70,0x00,0x0F,0x3E, /* New, 856x480-60, not in BIOS */
   0xEB,0x8E,0xDF,0xDF,0x10,0x00,0x00,0x02,
   0x00}},  /* 0x48 */
 {{0xdd,0xa9,0xa9,0x81,0xb4,0x97,0x26,0xfd, /* New, 1360x768-60, not in BIOS */
   0x01,0x8d,0xff,0x00,0x27,0x10,0x00,0x03,
   0x01}},  /* 0x49 */
 {{0xd9,0x8f,0x8f,0x9d,0xba,0x0a,0x8a,0xff, /* New, 1152x864-84, not in any BIOS   */
   0x60,0x8b,0x5f,0x5f,0x8b,0x10,0x00,0x03,
   0x01}},  /* 0x4a */
 {{0xea,0xae,0xae,0x8e,0xba,0x82,0x40,0x10, /* New, 1400x1050-75, not in any BIOS  */
   0x1b,0x87,0x19,0x1a,0x41,0x0f,0x00,0x03,
   0x00}},  /* 0x4b */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0xf1,0xff, /* New, 1280x960-85, not in any BIOS */
   0xc0,0x83,0xbf,0xbf,0xf2,0x10,0x00,0x07,
   0x01}},  /* 0x4c */
 {{0x7b,0x5f,0x63,0x9f,0x6a,0x93,0x6f,0xf0, /* 768x576 */
   0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
   0x01}},  /* 0x4d */
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e, /* FSTN 320x480, TEMP - possibly invalid */
   0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
   0x00}}   /* 0x4e */
};

typedef struct _SiS310_MCLKDataStruct
{
	UCHAR SR28,SR29,SR2A;
	USHORT CLOCK;
} SiS310_MCLKDataStruct;

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_315[] =
{
	{ 0x3b,0x22,0x01,143},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_650[] =
{
	{ 0x5a,0x64,0x82, 66},
	{ 0xb3,0x45,0x82, 83},
	{ 0x37,0x61,0x82,100},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x61,0x82,100},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_330[] =
{
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x7c,0x08,0x01,200},
	{ 0x79,0x06,0x01,250},
	{ 0x7c,0x08,0x01,200},
	{ 0x7c,0x08,0x01,200},
	{ 0x7c,0x08,0x01,200},
	{ 0x79,0x06,0x01,250}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_0_660[] =  /* TODO */
{
	{ 0x5c,0x23,0x82,166},
	{ 0x5c,0x23,0x82,166},
	{ 0x37,0x21,0x82,200},
	{ 0x37,0x22,0x82,133},
	{ 0x29,0x21,0x82,150},
	{ 0x5c,0x23,0x82,166},
	{ 0x65,0x23,0x82,183},
	{ 0x37,0x21,0x82,200}
};

static const SiS310_MCLKDataStruct SiS310_MCLKData_1[] =
{
        { 0x29,0x21,0x82,150},
	{ 0x5c,0x23,0x82,166},
	{ 0x65,0x23,0x82,183},
	{ 0x37,0x21,0x82,200},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133},
	{ 0x37,0x22,0x82,133}
};

typedef struct _SiS310_VCLKDataStruct
{
	UCHAR SR2B,SR2C;
	USHORT CLOCK;
} SiS310_VCLKDataStruct;

static const SiS310_VCLKDataStruct SiS310_VCLKData[]=
{
	{ 0x1b,0xe1, 25}, /* 0x00 */
	{ 0x4e,0xe4, 28}, /* 0x01 */
	{ 0x57,0xe4, 31}, /* 0x02 */
	{ 0xc3,0xc8, 36}, /* 0x03 */
	{ 0x42,0xe2, 40}, /* 0x04 */
	{ 0xfe,0xcd, 43}, /* 0x05 */
	{ 0x5d,0xc4, 44}, /* 0x06 */
	{ 0x52,0xe2, 49}, /* 0x07 */
	{ 0x53,0xe2, 50}, /* 0x08 */
	{ 0x74,0x67, 52}, /* 0x09 */
	{ 0x6d,0x66, 56}, /* 0x0a */
	{ 0x5a,0x64, 65}, /* 0x0b */  /* TW: was 6c c3 - WRONG */
	{ 0x46,0x44, 67}, /* 0x0c */
	{ 0xb1,0x46, 68}, /* 0x0d */
	{ 0xd3,0x4a, 72}, /* 0x0e */
	{ 0x29,0x61, 75}, /* 0x0f */
	{ 0x6e,0x46, 76}, /* 0x10 */
	{ 0x2b,0x61, 78}, /* 0x11 */
	{ 0x31,0x42, 79}, /* 0x12 */
	{ 0xab,0x44, 83}, /* 0x13 */
	{ 0x46,0x25, 84}, /* 0x14 */
	{ 0x78,0x29, 86}, /* 0x15 */
	{ 0x62,0x44, 94}, /* 0x16 */
	{ 0x2b,0x41,104}, /* 0x17 */
	{ 0x3a,0x23,105}, /* 0x18 */
	{ 0x70,0x44,108}, /* 0x19 */ 
	{ 0x3c,0x23,109}, /* 0x1a */
	{ 0x5e,0x43,113}, /* 0x1b */
	{ 0xbc,0x44,116}, /* 0x1c */
	{ 0xe0,0x46,132}, /* 0x1d */
	{ 0x54,0x42,135}, /* 0x1e */
	{ 0xea,0x2a,139}, /* 0x1f */
	{ 0x41,0x22,157}, /* 0x20 */
	{ 0x70,0x24,162}, /* 0x21 */
	{ 0x30,0x21,175}, /* 0x22 */
	{ 0x4e,0x22,189}, /* 0x23 */
	{ 0xde,0x26,194}, /* 0x24 */
	{ 0x62,0x06,202}, /* 0x25 */
	{ 0x3f,0x03,229}, /* 0x26 */
	{ 0xb8,0x06,234}, /* 0x27 */
	{ 0x34,0x02,253}, /* 0x28 */
	{ 0x58,0x04,255}, /* 0x29 */
	{ 0x24,0x01,265}, /* 0x2a */
	{ 0x9b,0x02,267}, /* 0x2b */
	{ 0x70,0x05,270}, /* 0x2c */
	{ 0x25,0x01,272}, /* 0x2d */
	{ 0x9c,0x02,277}, /* 0x2e */
	{ 0x27,0x01,286}, /* 0x2f */
	{ 0x3c,0x02,291}, /* 0x30 */
	{ 0xef,0x0a,292}, /* 0x31 */
	{ 0xf6,0x0a,310}, /* 0x32 */
	{ 0x95,0x01,315}, /* 0x33 */
	{ 0xf0,0x09,324}, /* 0x34 */
	{ 0xfe,0x0a,331}, /* 0x35 */
	{ 0xf3,0x09,332}, /* 0x36 */
	{ 0xea,0x08,340}, /* 0x37 */
	{ 0xe8,0x07,376}, /* 0x38 */
	{ 0xde,0x06,389}, /* 0x39 */
	{ 0x52,0x2a, 54}, /* 0x3a */  /* 301 TV */
	{ 0x52,0x6a, 27}, /* 0x3b */  /* 301 TV */
	{ 0x62,0x24, 70}, /* 0x3c */  /* 301 TV */
	{ 0x62,0x64, 70}, /* 0x3d */  /* 301 TV */
	{ 0xa8,0x4c, 30}, /* 0x3e */  /* 301 TV */
	{ 0x20,0x26, 33}, /* 0x3f */  /* 301 TV */
	{ 0x31,0xc2, 39}, /* 0x40 */
	{ 0x60,0x36, 30}, /* 0x41 */  /* Chrontel */
	{ 0x40,0x4a, 28}, /* 0x42 */  /* Chrontel */
	{ 0x9f,0x46, 44}, /* 0x43 */  /* Chrontel */
	{ 0x97,0x2c, 26}, /* 0x44 */
	{ 0x44,0xe4, 25}, /* 0x45 */  /* Chrontel */
	{ 0x7e,0x32, 47}, /* 0x46 */  /* Chrontel */
	{ 0x8a,0x24, 31}, /* 0x47 */  /* Chrontel */
	{ 0x97,0x2c, 26}, /* 0x48 */  /* Chrontel */
	{ 0xce,0x3c, 39}, /* 0x49 */
	{ 0x52,0x4a, 36}, /* 0x4a */  /* Chrontel */
	{ 0x34,0x61, 95}, /* 0x4b */
	{ 0x78,0x27,108}, /* 0x4c - was 102 */
	{ 0x66,0x43,123}, /* 0x4d */  /* Modes 0x26-0x28 (1400x1050) */
	{ 0x41,0x4e, 21}, /* 0x4e */
	{ 0xa1,0x4a, 29}, /* 0x4f */  /* Chrontel */
	{ 0x19,0x42, 42}, /* 0x50 */
	{ 0x54,0x46, 58}, /* 0x51 */  /* Chrontel */
	{ 0x25,0x42, 61}, /* 0x52 */
	{ 0x44,0x44, 66}, /* 0x53 */  /* Chrontel */
	{ 0x3a,0x62, 70}, /* 0x54 */  /* Chrontel */
	{ 0x62,0xc6, 34}, /* 0x55 - added for 848x480-60 (not in any BIOS) */
	{ 0x6a,0xc6, 37}, /* 0x56 - added for 848x480-75 (not in any BIOS)    - TEMP */
	{ 0xbf,0xc8, 35}, /* 0x57 - added for 856x480-38i,60 (not in any BIOS) */
	{ 0x30,0x23, 88}, /* 0x58 - added for 1360x768-62 (is 60Hz!) (not in any BIOS) */
	{ 0x52,0x07,149}, /* 0x59 - added for 1280x960-85 (Not in any BIOS) */
	{ 0x56,0x07,156}, /* 0x5a - added for 1400x1050-75 */
   	{ 0x70,0x29, 81}  /* 0x5b - added for 1280x768 LCD */
};

typedef struct _SiS310_VBVCLKDataStruct
{
	UCHAR Part4_A,Part4_B;
	USHORT CLOCK;
} SiS310_VBVCLKDataStruct;

static const SiS310_VBVCLKDataStruct SiS310_VBVCLKData[]=
{
	{ 0x1b,0xe1, 25}, /* 0x00 */
	{ 0x4e,0xe4, 28}, /* 0x01 */
	{ 0x57,0xe4, 31}, /* 0x02 */
	{ 0xc3,0xc8, 36}, /* 0x03 */
	{ 0x42,0x47, 40}, /* 0x04 */
	{ 0xfe,0xcd, 43}, /* 0x05 */
	{ 0x5d,0xc4, 44}, /* 0x06 */
	{ 0x52,0x47, 49}, /* 0x07 */
	{ 0x53,0x47, 50}, /* 0x08 */
	{ 0x74,0x67, 52}, /* 0x09 */
	{ 0x6d,0x66, 56}, /* 0x0a */
	{ 0x35,0x62, 65}, /* 0x0b */  /* Was 0x5a,0x64 - 650/LVDS+301 bios: 35,62  */
	{ 0x46,0x44, 67}, /* 0x0c */
	{ 0xb1,0x46, 68}, /* 0x0d */
	{ 0xd3,0x4a, 72}, /* 0x0e */
	{ 0x29,0x61, 75}, /* 0x0f */
	{ 0x6d,0x46, 75}, /* 0x10 */
	{ 0x41,0x43, 78}, /* 0x11 */
	{ 0x31,0x42, 79}, /* 0x12 */
	{ 0xab,0x44, 83}, /* 0x13 */
	{ 0x46,0x25, 84}, /* 0x14 */
	{ 0x78,0x29, 86}, /* 0x15 */
	{ 0x62,0x44, 94}, /* 0x16 */
	{ 0x2b,0x22,104}, /* 0x17 */
	{ 0x49,0x24,105}, /* 0x18 */
	{ 0xf8,0x2f,108}, /* 0x19 */  /* 1400x1050 LCD */
	{ 0x3c,0x23,109}, /* 0x1a */
	{ 0x5e,0x43,113}, /* 0x1b */
	{ 0xbc,0x44,116}, /* 0x1c */
	{ 0xe0,0x46,132}, /* 0x1d */
#if 0
	{ 0xd4,0x28,135}, /* 0x1e */
	{ 0xea,0x2a,139}, /* 0x1f */
	{ 0x41,0x22,157}, /* 0x20 */
	{ 0x70,0x24,162}, /* 0x21 */
#endif
	{ 0xe2,0x46,135}, /* 0x1e */  /* 1280x1024-75, better clock for VGA2 */
	{ 0xe5,0x46,139}, /* 0x1f */  /* 1024x768-120, better clock for VGA2 */
	{ 0x15,0x01,157}, /* 0x20 */  /* 1280x1024-85, better clock for VGA2 */
	{ 0x70,0x09,162}, /* 0x21 */  /* 1600x1200-60, better clock for VGA2 */
	{ 0x30,0x21,175}, /* 0x22 */
	{ 0x4e,0x22,189}, /* 0x23 */
	{ 0xde,0x26,194}, /* 0x24 */
	{ 0x70,0x07,202}, /* 0x25 */
	{ 0x3f,0x03,229}, /* 0x26 */
	{ 0xb8,0x06,234}, /* 0x27 */
	{ 0x34,0x02,253}, /* 0x28 */
	{ 0x58,0x04,255}, /* 0x29 */
	{ 0x24,0x01,265}, /* 0x2a */
	{ 0x9b,0x02,267}, /* 0x2b */
	{ 0x70,0x05,270}, /* 0x2c */
	{ 0x25,0x01,272}, /* 0x2d */
	{ 0x9c,0x02,277}, /* 0x2e */
	{ 0x27,0x01,286}, /* 0x2f */
	{ 0x3c,0x02,291}, /* 0x30 */
	{ 0xef,0x0a,292}, /* 0x31 */
	{ 0xf6,0x0a,310}, /* 0x32 */
	{ 0x95,0x01,315}, /* 0x33 */
	{ 0xf0,0x09,324}, /* 0x34 */
	{ 0xfe,0x0a,331}, /* 0x35 */
	{ 0xf3,0x09,332}, /* 0x36 */
	{ 0xea,0x08,340}, /* 0x37 */
	{ 0xe8,0x07,376}, /* 0x38 */
	{ 0xde,0x06,389}, /* 0x39 */
	{ 0x52,0x2a, 54}, /* 0x3a */  /* 301 TV */
	{ 0x52,0x6a, 27}, /* 0x3b */  /* 301 TV */
	{ 0x62,0x24, 70}, /* 0x3c */  /* 301 TV */
	{ 0x62,0x64, 70}, /* 0x3d */  /* 301 TV */
	{ 0xa8,0x4c, 30}, /* 0x3e */  /* 301 TV */
	{ 0x20,0x26, 33}, /* 0x3f */  /* 301 TV */
	{ 0x31,0xc2, 39}, /* 0x40 */
	{ 0x2e,0x48, 25}, /* 0x41 */  /* Replacement for LCD on 315 for index 0 */
	{ 0x24,0x46, 25}, /* 0x42 */  /* Replacement for LCD on 315 for modes 0x01, 0x03, 0x0f, 0x10, 0x12 */
	{ 0x26,0x64, 28}, /* 0x43 */  /* Replacement for LCD on 315 for index 1 */
	{ 0x37,0x64, 40}, /* 0x44 */  /* Replacement for LCD on 315 for index 4 */
	{ 0xa1,0x42,108}, /* 0x45 */  /* 1280x960 LCD */
	{ 0x37,0x61,100}, /* 0x46 */  /* 1280x960 LCD */
	{ 0x78,0x27,108}, /* 0x47 */
	{ 0x97,0x2c, 26}, /* 0x48 */  /* UNUSED - Entries from here new, not in any BIOS */
	{ 0xce,0x3c, 39}, /* 0x49 */  /* UNUSED */
	{ 0x52,0x4a, 36}, /* 0x4a */  /* UNUSED */
	{ 0x34,0x61, 95}, /* 0x4b */  /* UNUSED */
	{ 0x78,0x27,108}, /* 0x4c */  /* UNUSED */
	{ 0x66,0x43,123}, /* 0x4d */  /* 1400x1050-60 */
	{ 0x41,0x4e, 21}, /* 0x4e */  /* UNUSED */
	{ 0xa1,0x4a, 29}, /* 0x4f */  /* UNUSED */
	{ 0x19,0x42, 42}, /* 0x50 */  /* UNUSED */
	{ 0x54,0x46, 58}, /* 0x51 */  /* UNUSED */
	{ 0x25,0x42, 61}, /* 0x52 */  /* UNUSED */
	{ 0x44,0x44, 66}, /* 0x53 */  /* UNUSED */
	{ 0x3a,0x62, 70}, /* 0x54 */  /* UNUSED */
	{ 0x62,0xc6, 34}, /* 0x55 */  /* 848x480-60 */
	{ 0x6a,0xc6, 37}, /* 0x56 */  /* 848x480-75 - TEMP, UNUSED */
	{ 0xbf,0xc8, 35}, /* 0x57 */  /* 856x480-38i,60  */
	{ 0x30,0x23, 88}, /* 0x58 */  /* 1360x768-62 (is 60Hz!) TEMP, UNUSED */
	{ 0x52,0x07,149}, /* 0x59 */  /* 1280x960-85  */
	{ 0x56,0x07,156}, /* 0x5a */  /* 1400x1050-75 */
   	{ 0x70,0x29, 81}  /* 0x5b */  /* 1280x768 LCD */
};

static const UCHAR SiS310_ScreenOffset[] =
{
        0x14,0x19,0x20,0x28,0x32,0x40,0x50,0x64,
	0x78,0x80,0x2d,0x35,0x57,0x48,0x55,0x30,
	0xff
};

static const DRAM4Type SiS310_SR15[8] = {
	{0x00,0x04,0x60,0x60},
	{0x0f,0x0f,0x0f,0x0f},
	{0xba,0xba,0xba,0xba},
	{0xa9,0xa9,0xac,0xac},
	{0xa0,0xa0,0xa0,0xa8},
	{0x00,0x00,0x02,0x02},
 	{0x30,0x30,0x40,0x40},
	{0x00,0xa5,0xfb,0xf6}
};

#ifndef LINUX_XF86

static UCHAR SiS310_SR07 = 0x18;

static const DRAM4Type SiS310_CR40[5] = {
	{0x77,0x77,0x33,0x33},
	{0x77,0x77,0x33,0x33},
	{0x00,0x00,0x00,0x00},
	{0x5b,0x5b,0x03,0x03},
	{0x00,0x00,0xf0,0xf8}
};

static UCHAR SiS310_CR49[] = {0xaa,0x88};
static UCHAR SiS310_SR1F = 0x00;
static UCHAR SiS310_SR21 = 0xa5;
static UCHAR SiS310_SR22 = 0xfb;
static UCHAR SiS310_SR23 = 0xf6;
static UCHAR SiS310_SR24 = 0x0d;
static UCHAR SiS310_SR25[] = {0x33,0x3};
static UCHAR SiS310_SR31 = 0x00;
static UCHAR SiS310_SR32 = 0x11;
static UCHAR SiS310_SR33 = 0x00;
static UCHAR SiS310_CRT2Data_1_2  = 0x00;
static UCHAR SiS310_CRT2Data_4_D  = 0x00;
static UCHAR SiS310_CRT2Data_4_E  = 0x00;
static UCHAR SiS310_CRT2Data_4_10 = 0x80;
static const USHORT SiS310_RGBSenseData    = 0xd1;
static const USHORT SiS310_VideoSenseData  = 0xb9;
static const USHORT SiS310_YCSenseData     = 0xb3;
static const USHORT SiS310_RGBSenseData2   = 0x0190; 
static const USHORT SiS310_VideoSenseData2 = 0x0174;
static const USHORT SiS310_YCSenseData2    = 0x016b;
#endif

typedef struct _SiS310_PanelDelayTblStruct
{
 	UCHAR timer[2];
} SiS310_PanelDelayTblStruct;

static const SiS310_PanelDelayTblStruct SiS310_PanelDelayTbl[]=
{
        {{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}},
	{{0x10,0x40}}
};

static const SiS310_PanelDelayTblStruct SiS310_PanelDelayTblLVDS[]=
{
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}},
	{{0x28,0xc8}}
};

/**************************************************************/
/* SIS VIDEO BRIDGE ----------------------------------------- */
/**************************************************************/

typedef struct _SiS310_LCDDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS310_LCDDataStruct;

static const SiS310_LCDDataStruct  SiS310_StLCD1024x768Data[]=
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS310_LCDDataStruct  SiS310_ExtLCD1024x768Data[] =   
{
	{   42,  25,1536, 419,1344, 806},
	{   48,  25,1536, 369,1344, 806},
	{   42,  25,1536, 419,1344, 806},
	{   48,  25,1536, 369,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
	 
};

static const SiS310_LCDDataStruct  SiS310_St2LCD1024x768Data[] =  
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
        {   62,  25, 800, 546,1344, 806},    
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS310_LCDDataStruct  SiS310_StLCD1280x1024Data[] =
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS310_LCDDataStruct  SiS310_ExtLCD1280x1024Data[] =
{
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 500,1688,1066},
	{  211,  75,1024, 625,1688,1066},
	{  211, 120,1280, 798,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1800,1000,1688,1066}  /* 1280x960 - does not work, use panel scaler instead */
};

static const SiS310_LCDDataStruct  SiS310_St2LCD1280x1024Data[] =
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1024x768[] =  
{
        {    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},  /* 640x400 - does not work */
	{    1,   1,1344, 806,1344, 806},  /* 640x480 - does not work */
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS310_LCDDataStruct  SiS310_NoScaleData1280x1024[] =
{
        {    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066},
	{    1,   1,1688,1066,1688,1066}
};

typedef struct _SiS310_Part2PortTblStruct
{
 	UCHAR CR[12];
} SiS310_Part2PortTblStruct;

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1024x768_1[] =
{
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x2c,0x12,0x9a,0xae,0x88,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x38,0x13,0x16,0x0c,0xe6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x38,0x18,0x16,0x00,0x00,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x25,0x12,0xc9,0xdc,0xb6,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1024x768_2[] =
{
 {{0x25,0x12,0x51,0x6e,0x48,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x2c,0x12,0x38,0x55,0x2f,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x25,0x12,0x51,0x6e,0x48,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x2c,0x12,0x38,0x55,0x2f,0xc1,0x35,0xb1,0x47,0xe9,0x71,0x33}},
 {{0x2d,0x12,0x79,0x96,0x70,0x99,0x35,0x89,0x47,0xc1,0x49,0x33}},
 {{0x29,0x12,0xb5,0xd2,0xac,0xe9,0x35,0xd9,0x47,0x11,0x99,0x33}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},  /* others  */
/* 0x36,0x13,0x02,0x25,0xff,0x03,0x45,0x09,0x07,0xf9,0x00,0x24        my      */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1024x768_3[] =
{
#if 1   /* Data from 650/301LVx 1.10.6s and others */
 {{0x25,0x13,0xc9,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x2c,0x13,0x9a,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x25,0x13,0xc9,0x24,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x38,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x38,0x18,0x16,0x00,0x00,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x36,0x13,0x13,0x25,0xff,0x59,0x45,0x09,0x07,0xf9,0x09,0x24}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x25,0x13,0xc9,0x25,0xff,0xf9,0x45,0x09,0x07,0xf9,0x09,0x24}}
#endif
#if 0    /* Data from my 301LV */
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},   /* TEST */
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}},
 {{0x36,0x13,0x02,0x25,0xff,0x21,0x45,0x09,0x07,0x88,0x09,0x24}}
#endif
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1280x1024_1[] =
{ /* Acer; BIOS data invalid, last row taken from _3 */
 {{0x25,0x12,0x51,0x6E,0x48,0x99,0x35,0x89,0x47,0xC1,0x49,0x33}},
 {{0x2C,0x12,0x38,0x55,0x2F,0x99,0x35,0x89,0x47,0xC1,0x49,0x33}},
 {{0x25,0x12,0x51,0x6E,0x48,0x99,0x35,0x89,0x47,0xC1,0x49,0x33}},
 {{0x2C,0x12,0x38,0x55,0x2F,0xC1,0x35,0xB1,0x47,0xE9,0x71,0x33}},
 {{0x2D,0x12,0x79,0x96,0x70,0x99,0x35,0x89,0x47,0xC1,0x49,0x33}},
 {{0x29,0x12,0xB5,0xD2,0xAC,0xE9,0x35,0xD9,0x47,0x11,0x99,0x33}},
 {{0x36,0x13,0x02,0x25,0xFF,0x03,0x45,0x09,0x07,0xF9,0x00,0x24}},
 {{0x47,0x1C,0x14,0x29,0xFF,0xBD,0x23,0x0A,0x07,0x23,0x8A,0x12}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1280x1024_2[] =
{ /* Acer */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

/*   1     2    4    5    6   1c   1d   1f   20   21   23   25   */
static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1280x1024_3[] =
{ /* Acer */
 {{0x31,0x1B,0xC4,0xDA,0xB0,0xBD,0x23,0x0A,0x07,0x23,0x8A,0x12}},
 {{0x34,0x1B,0x9F,0xC0,0x80,0xB8,0x23,0x0A,0x07,0x14,0x8A,0x12}},
 {{0x3E,0x1B,0xCF,0xF0,0xB0,0xB8,0x23,0x0A,0x07,0x14,0x8A,0x12}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x48,0x1C,0x15,0x29,0xFF,0xBD,0x23,0x0A,0x07,0x23,0x8A,0x12}},
 {{0x48,0x1C,0x15,0x29,0xFF,0xBD,0x23,0x0A,0x07,0x23,0x8A,0x12}},
 {{0x48,0x1C,0x15,0x29,0xFF,0xBD,0x23,0x0A,0x07,0x23,0x8A,0x12}},
 {{0x47,0x1C,0x14,0x29,0xFF,0xBD,0x23,0x0A,0x07,0x23,0x8A,0x12}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1400x1050_1[] =
{
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1400x1050_2[] =
{
 {{0x2b,0x12,0xd9,0xe5,0xd5,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x22,0x12,0xc0,0xcc,0xbc,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x2b,0x12,0xd9,0xe5,0xd5,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x22,0x12,0xc0,0xcc,0xbc,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x33,0x13,0x01,0x0d,0xfd,0x2c,0x23,0x98,0x27,0x3e,0x08,0x42}},
 {{0x3f,0x1b,0x3d,0x49,0x39,0x54,0x23,0xc0,0x27,0x66,0x30,0x42}},
 {{0x33,0x1b,0x91,0x9d,0x8d,0x8c,0x23,0xf8,0x27,0x9e,0x68,0x42}},
 {{0x43,0x24,0x11,0x1d,0x0d,0xcc,0x23,0x38,0x37,0xde,0xa8,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1400x1050_3[] =
{
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x42}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}},
 {{0x43,0x24,0x21,0x29,0x19,0xea,0x23,0x0a,0x07,0x32,0xc6,0x32}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1600x1200_1[] =
{
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1600x1200_2[] =
{
 {{0x32,0x1B,0x2C,0x52,0x20,0x80,0x20,0x52,0x30,0xA3,0x3A,0x02}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x32,0x1B,0x2C,0x52,0x20,0x80,0x20,0x52,0x30,0xA3,0x3A,0x02}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x3A,0x1B,0x54,0x7A,0x48,0x80,0x24,0x52,0x30,0xA3,0x3A,0x02}},
 {{0x36,0x1B,0x90,0xB6,0x84,0xA8,0x24,0x7A,0x30,0xCB,0x62,0x02}},
 {{0x3A,0x1C,0xE4,0x0A,0xD8,0xE0,0x24,0xB2,0x30,0x03,0x9A,0x02}},
 {{0x4A,0x24,0x64,0x8A,0x58,0x20,0x34,0xF2,0x30,0x43,0xDA,0x52}},
 {{0x47,0x24,0x71,0x97,0x65,0x3E,0x34,0x10,0x40,0x61,0xF8,0x02}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}}
};

static const SiS310_Part2PortTblStruct SiS310_CRT2Part2_1600x1200_3[] =
{
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}},
 {{0x4C,0x24,0xC8,0xE1,0xAF,0x70,0x34,0x0A,0x07,0xFC,0x2A,0x53}}
};

/* CRT1 CRTC for LCDA */

typedef struct _SiS310_LCDACRT1DataStruct
{
 	UCHAR CR[17];
}SiS310_LCDACRT1DataStruct;

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_1[]=
{
 {{0x73,0x4f,0x4f,0x97,0x59,0x84,0xb4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x59,0x84,0x82,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x59,0x84,0xb4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x59,0x84,0x82,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x59,0x84,0x04,0x3e,
   0xE2,0x89,0xdf,0xdf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x63,0x8B,0x6D,0x18,0x7c,0xf0,
   0x5A,0x81,0x57,0x57,0x7D,0x00,0x00,0x06,
   0x01}},
 {{0xA3,0x7f,0x7f,0x87,0x89,0x94,0x24,0xf5,
   0x02,0x89,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_1_H[]=
{
 {{0x4b,0x27,0x27,0x8f,0x31,0x1c,0xb4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x31,0x1c,0x82,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x31,0x1c,0xb4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x31,0x1c,0x82,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x27,0x8f,0x31,0x1c,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x55,0x31,0x31,0x99,0x3b,0x06,0x7c,0xf0,
   0x5A,0x81,0x57,0x57,0x7D,0x00,0x00,0x01,
   0x01}},
 {{0x63,0x3F,0x3F,0x87,0x49,0x94,0x24,0xF5,
   0x02,0x89,0xFF,0xFF,0x25,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_2[]=
{
 {{0xa3,0x4f,0x4f,0x0f,0x6e,0x1f,0x24,0xbb,
   0x4a,0x81,0x8f,0xdb,0xda,0x20,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x0f,0x6e,0x1f,0x24,0xbb,
   0x31,0x88,0x5d,0xc2,0xc1,0x20,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x0f,0x6e,0x1f,0x24,0xbb,
   0x4a,0x81,0x8f,0xdb,0xda,0x20,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x0f,0x6e,0x1f,0x24,0xbb,
   0x31,0x88,0x5d,0xc2,0xc1,0x20,0x00,0x06,
   0x01}},
 {{0xa3,0x4f,0x4f,0x0f,0x6e,0x1f,0x24,0xb3,
   0x72,0x89,0xdf,0x03,0x02,0x30,0x00,0x06,
   0x01}},
 {{0xa3,0x63,0x63,0x98,0x78,0x19,0x24,0xf1,
   0xbb,0x82,0x57,0x57,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x89,0x94,0x24,0xf5,
   0x02,0x89,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_2_H[]=
{
 {{0x7b,0x27,0x27,0x0f,0x46,0x97,0x24,0xbb,
   0x4a,0x81,0x8f,0xdb,0xda,0x20,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x0f,0x46,0x97,0x24,0xbb,
   0x31,0x88,0x5d,0xc2,0xc1,0x20,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x0f,0x46,0x97,0x24,0xbb,
   0x4a,0x81,0x8f,0xdb,0xda,0x20,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x0f,0x46,0x97,0x24,0xbb,
   0x31,0x88,0x5d,0xc2,0xc1,0x20,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x27,0x0f,0x46,0x97,0x24,0xb3,
   0x72,0x89,0xdf,0x03,0x02,0x30,0x00,0x01,
   0x01 }},
 {{0x71,0x31,0x31,0x98,0x46,0x17,0x24,0xf1,
   0xbb,0x82,0x57,0x57,0x25,0x10,0x00,0x02,
   0x01 }},
 {{0x63,0x3f,0x3f,0x87,0x4c,0x97,0x24,0xf5,
   0x0f,0x86,0xff,0xff,0x25,0x30,0x00,0x01,
   0x01 }}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_1[]=
{ /* Acer */
 {{0x7e,0x4f,0x4f,0x82,0x58,0x04,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x04,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x04,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x04,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x4f,0x82,0x58,0x04,0x08,0x3e,
   0xe0,0x84,0xdf,0xdf,0x09,0x00,0x00,0x06,
   0x00}},
 {{0x92,0x63,0x63,0x96,0x6c,0x18,0x80,0xf0,
   0x58,0x8c,0x57,0x57,0x81,0x20,0x00,0x06,
   0x01}},
 {{0xae,0x7f,0x7f,0x92,0x88,0x94,0x28,0xf5,
   0x00,0x84,0xff,0xff,0x29,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0xff,0x29,0x01,0x00,0x07,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_1_H[]=
{  /* Acer */
 {{0x56,0x27,0x27,0x9a,0x31,0x1c,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x27,0x9a,0x31,0x1c,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x27,0x9a,0x31,0x1c,0xb8,0x1f,
   0x90,0x84,0x8f,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x27,0x9a,0x31,0x1c,0x86,0x1f,
   0x5e,0x82,0x5d,0x5d,0x87,0x10,0x00,0x05,
   0x01}},
 {{0x56,0x27,0x27,0x9a,0x31,0x1c,0x08,0x3e,
   0xe0,0x84,0xdf,0xdf,0x09,0x00,0x00,0x05,
   0x00}},
 {{0x60,0x31,0x31,0x84,0x3a,0x86,0x80,0xf0,
   0x58,0x8c,0x57,0x57,0x81,0x20,0x00,0x01,
   0x01}},
 {{0x6e,0x3f,0x3f,0x92,0x48,0x94,0x28,0xf5,
   0x00,0x84,0xff,0xff,0x29,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_2[]=
{  /* Illegal data in BIOS (Acer, Compaq) */
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_2_H[]=
{  /* Illegal data in BIOS (Acer, Compaq) */
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x72,0x88,0xdf,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x31,0x93,0x3e,0x86,0x24,0xf1,
   0xae,0x84,0x57,0x57,0x25,0x30,0x00,0x01,
   0x01 }},
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_1[]=
{
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0xee,0x1f,
   0xe2,0x86,0xdf,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x83,0x63,0x63,0x87,0x68,0x16,0x66,0xf0,
   0x5a,0x8e,0x57,0x57,0x67,0x20,0x00,0x06,
   0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x84,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0xff,0x0f,0x10,0x00,0x02,
   0x01}},
 {{0xbf,0x9f,0x9f,0x83,0xa4,0x12,0x0e,0x5a,
   0x02,0x86,0xff,0xff,0x0f,0x09,0x00,0x07,
   0x01}},
 {{0xce,0xae,0xae,0x92,0xb3,0x01,0x28,0x10,
   0x1a,0x80,0x19,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_1_H[]=
{
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
    0x93,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
    0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
    0x92,0x86,0x8f,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
    0x60,0x84,0x5d,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x47,0x27,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
    0xe2,0x86,0xdf,0xdf,0xef,0x10,0x00,0x05,
    0x00}},
  {{0x51,0x31,0x31,0x95,0x36,0x04,0x66,0xf0,
    0x5a,0x8e,0x57,0x57,0x67,0x20,0x00,0x01,
    0x01}},
  {{0x5f,0x3f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
    0x02,0x86,0xff,0xff,0x0f,0x10,0x00,0x01,
    0x01}},
  {{0x6f,0x4f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
    0x02,0x86,0xff,0xff,0x0f,0x09,0x00,0x05,
    0x01}},
  {{0x76,0x56,0x56,0x9a,0x5b,0x89,0x28,0x10,
    0x1c,0x80,0x19,0x19,0x29,0x0b,0x00,0x05,
    0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_2[]=
{
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x4f,0x92,0x8c,0x1a,0x28,0x9e,
   0x03,0x87,0xdf,0xdf,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x63,0x63,0x92,0x96,0x04,0x28,0xd4,
   0x3f,0x83,0x57,0x57,0x29,0x01,0x00,0x07,
   0x01}},
 {{0xce,0x7f,0x7f,0x92,0xa4,0x12,0x28,0xd4,
   0x93,0x87,0xff,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x9f,0x92,0xb4,0x02,0x28,0x5a,
   0x13,0x87,0xff,0xff,0x29,0x29,0x00,0x03,
   0x01}},
 {{0xce,0xae,0xae,0x92,0xbc,0x0a,0x28,0x10,
   0x20,0x84,0x19,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11400x1050_2_H[]=
{
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x27,0x8a,0x64,0x92,0x28,0x9e,
   0x03,0x87,0xdf,0xdf,0x29,0x01,0x00,0x06,
   0x00}},
 {{0x9c,0x31,0x31,0x80,0x64,0x92,0x28,0xd4,
   0x3f,0x83,0x57,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x3f,0x92,0x64,0x12,0x28,0xd4,
   0x93,0x87,0xff,0xff,0x29,0x21,0x00,0x06,
   0x01}},
 {{0x7e,0x4f,0x4f,0x82,0x64,0x12,0x28,0x5a,
   0x13,0x87,0xff,0xff,0x29,0x29,0x00,0x06,
   0x01}},
 {{0x76,0x56,0x56,0x9a,0x64,0x92,0x28,0x10,
   0x20,0x84,0x19,0x19,0x29,0x0f,0x00,0x05,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_1[]=
{
 {{0x83,0x4F,0x4F,0x87,0x51,0x09,0xC0,0x1F,
   0x90,0x84,0x8F,0x8F,0xC1,0x30,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x4F,0x87,0x51,0x09,0x8E,0x1F,
   0x5E,0x82,0x5D,0x5D,0x8F,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x4F,0x87,0x51,0x09,0xC0,0x1F,
   0x90,0x84,0x8F,0x8F,0xC1,0x30,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x4F,0x87,0x51,0x09,0x8E,0x1F,
   0x5E,0x82,0x5D,0x5D,0x8F,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x4F,0x87,0x51,0x09,0x10,0x3E,
   0xE0,0x84,0xDF,0xDF,0x11,0x00,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x63,0x9B,0x65,0x1D,0x88,0xF0,
   0x58,0x8C,0x57,0x57,0x89,0x20,0x00,0x06,
   0x01}},
 {{0xB3,0x7F,0x7F,0x97,0x81,0x99,0x30,0xF5,
   0x00,0x84,0xFF,0xFF,0x31,0x10,0x00,0x02,
   0x01}},
 {{0xD3,0x9F,0x9F,0x97,0xA1,0x19,0x30,0x5A,
   0x00,0x84,0xFF,0xFF,0x31,0x09,0x00,0x07,
   0x01}},
 {{0xE2,0xAE,0xAE,0x86,0xB0,0x88,0x4A,0x10,
   0x1A,0x8E,0x19,0x19,0x4B,0x2F,0x00,0x03,
   0x00}},
 {{0xFB,0xC7,0xC7,0x9F,0xC9,0x81,0xE0,0x10,
   0xB0,0x84,0xAF,0xAF,0xE1,0x2F,0x00,0x07,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_1_H[]=
{
 {{0x69,0x27,0x27,0x8D,0x30,0x88,0xC0,0x1F,
   0x90,0x84,0x8F,0x8F,0xC1,0x30,0x00,0x01,
   0x00}},
 {{0x69,0x27,0x27,0x8D,0x30,0x88,0x8E,0x1F,
   0x5E,0x82,0x5D,0x5D,0x87,0x10,0x00,0x01,
   0x00}},
 {{0x69,0x27,0x27,0x8D,0x30,0x88,0xC0,0x1F,
   0x90,0x84,0x8F,0x8F,0xC1,0x30,0x00,0x01,
   0x00}},
 {{0x69,0x27,0x27,0x8D,0x30,0x88,0x8E,0x1F,
   0x5E,0x82,0x5D,0x5D,0x87,0x10,0x00,0x01,
   0x00}},
 {{0x69,0x27,0x27,0x8D,0x30,0x88,0x10,0x3E,
   0xE0,0x84,0xDF,0xDF,0x11,0x00,0x00,0x01,
   0x00}},
 {{0x73,0x31,0x31,0x97,0x3A,0x92,0x88,0xF0,
   0x58,0x8C,0x57,0x57,0x89,0x20,0x00,0x01,
   0x01}},
 {{0x81,0x3F,0x3F,0x85,0x48,0x00,0x30,0xF5,
   0x00,0x84,0xFF,0xFF,0x31,0x10,0x00,0x06,
   0x01}},
 {{0x91,0x4F,0x4F,0x95,0x58,0x10,0x30,0x5A,
   0x00,0x84,0xFF,0xFF,0x31,0x09,0x00,0x06,
   0x01}},
 {{0xD4,0x9F,0x9F,0x98,0xA8,0x00,0x30,0x5A,
   0x00,0x84,0xFF,0xFF,0x31,0x09,0x00,0x03,
   0x01}},
 {{0xA5,0x63,0x63,0x89,0x6C,0x84,0xE0,0x10,
   0xB0,0x84,0xAF,0xAF,0xE1,0x2F,0x00,0x02,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_2[]=
{
 {{0x09,0x4F,0x4F,0x8D,0xA3,0x1B,0xE0,0x9E,
   0x37,0x8B,0x8F,0x8F,0xE1,0x21,0x01,0x04,
   0x00}},
 {{0x09,0x4F,0x4F,0x8D,0xA3,0x1B,0xE0,0x9E,
   0x1E,0x82,0x5D,0x5D,0xE1,0x01,0x01,0x04,
   0x00}},
 {{0x09,0x4F,0x4F,0x8D,0xA3,0x1B,0xE0,0x9E,
   0x37,0x8B,0x8F,0x8F,0xE1,0x21,0x01,0x04,
   0x00}},
 {{0x09,0x4F,0x4F,0x8D,0xA3,0x1B,0xE0,0x9E,
   0x1E,0x82,0x5D,0x5D,0xE1,0x01,0x01,0x04,
   0x00}},
 {{0x09,0x4F,0x4F,0x8D,0xA3,0x1B,0xE0,0x9E,
   0x5F,0x83,0xDF,0xDF,0xE1,0x01,0x01,0x04,
   0x00}},
 {{0x09,0x63,0x63,0x8D,0xAD,0x05,0xE0,0xD4,
   0x9B,0x8F,0x57,0x57,0xE1,0x21,0x01,0x00,
   0x01}},
 {{0x09,0x7F,0x7F,0x8D,0xBB,0x13,0xE0,0xD4,
   0xEF,0x83,0xFF,0xFF,0xE1,0x21,0x01,0x00,
   0x01}},
 {{0x09,0x9F,0x9F,0x8D,0xCB,0x03,0xE0,0x5A,
   0x6F,0x83,0xFF,0xFF,0xE1,0x29,0x01,0x04,
   0x01}},
 {{0xD4,0x9F,0x9F,0x98,0xA8,0x00,0x30,0x5A,
   0x00,0x84,0xFF,0xFF,0x31,0x09,0x00,0x03,
   0x01}},
 {{0x09,0xC7,0xC7,0x8D,0xDF,0x17,0xE0,0x10,
   0xC7,0x8B,0xAF,0xAF,0xE1,0x0F,0x01,0x04,
   0x00}}
};

static const SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11600x1200_2_H[]=
{
 {{0xE1,0x27,0x27,0x85,0x7B,0x93,0xE0,0x9E,
   0x37,0x8B,0x8F,0x8F,0xE1,0x21,0x00,0x03,
   0x00}},
 {{0xE1,0x27,0x27,0x85,0x7B,0x93,0xE0,0x9E,
   0x1E,0x82,0x5D,0x5D,0xE1,0x01,0x00,0x03,
   0x00}},
 {{0xE1,0x27,0x27,0x85,0x7B,0x93,0xE0,0x9E,
   0x37,0x8B,0x8F,0x8F,0xE1,0x21,0x00,0x03,
   0x00}},
 {{0xE1,0x27,0x27,0x85,0x7B,0x93,0xE0,0x9E,
   0x1E,0x82,0x5D,0x5D,0xE1,0x01,0x00,0x03,
   0x00}},
 {{0xE1,0x27,0x27,0x85,0x7B,0x93,0xE0,0x9E,
   0x5F,0x83,0xDF,0xDF,0xE1,0x01,0x00,0x03,
   0x00}},
 {{0xD7,0x31,0x31,0x9B,0x7B,0x13,0xE0,0xD4,
   0x9B,0x8F,0x57,0x57,0xE1,0x21,0x00,0x03,
   0x01}},
 {{0xC9,0x3F,0x3F,0x8D,0x7B,0x13,0xE0,0xD4,
   0xEF,0x83,0xFF,0xFF,0xE1,0x21,0x00,0x03,
   0x01}},
 {{0xB9,0x4F,0x4F,0x9D,0x7B,0x93,0xE0,0x5A,
   0x6F,0x83,0xFF,0xFF,0xE1,0x29,0x00,0x02,
   0x01}},
 {{0xD4,0x9F,0x9F,0x98,0xA8,0x00,0x30,0x5A,
   0x00,0x84,0xFF,0xFF,0x31,0x09,0x00,0x03,
   0x01}},
 {{0xA5,0x63,0x63,0x89,0x7B,0x93,0xE0,0x10,
   0xC7,0x8B,0xAF,0xAF,0xE1,0x0F,0x00,0x02,
   0x00}}
};


/**************************************************************/
/* LVDS, CHRONTEL ------------------------------------------- */
/**************************************************************/

typedef struct _SiS310_LVDSDataStruct
{
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS310_LVDSDataStruct;

static const SiS310_LVDSDataStruct  SiS310_CHTVUPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 960, 750, 960, 750},
	{1400,1000,1400,1000}
};

static const SiS310_LVDSDataStruct  SiS310_CHTVOPALData[]= 
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 944, 625, 944, 625},
        {1400, 875,1400, 875}
};

static const SiS310_LVDSDataStruct  SiS310_CHTVUPALMData[]=  
{
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 784, 600, 784, 600},
	{1064, 750,1064, 750},
        {1160, 945,1160, 945}
};

static const SiS310_LVDSDataStruct  SiS310_CHTVOPALMData[]=
{
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 784, 525, 784, 525},
	{1040, 700,1040, 700},
        {1160, 840,1160, 840}
};

static const SiS310_LVDSDataStruct  SiS310_CHTVUPALNData[]=  
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 960, 750, 960, 750},
	{1400,1000,1400,1000}
};

static const SiS310_LVDSDataStruct  SiS310_CHTVOPALNData[]= 
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 944, 625, 944, 625},
        {1400, 875,1400, 875}
};

static const SiS310_LVDSDataStruct  SiS310_CHTVSOPALData[]=   /* TW: (super overscan - no effect on 7019) */
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 944, 625, 944, 625},
        {1400, 875,1400, 875}       	
};

typedef struct _SiS310_LVDSDesStruct
{
	USHORT LCDHDES;
	USHORT LCDVDES;
} SiS310_LVDSDesStruct;

static const SiS310_LVDSDesStruct  SiS310_PanelType00_1[]=  /* 800x600 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType01_1[]=  /* 1024x768 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 805},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType02_1[]=  /* 1280x1024 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 1065},
	{ 0, 0},
	{ 0, 0}
};


static const SiS310_LVDSDesStruct  SiS310_PanelType03_1[]= 
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType04_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType05_1[]= 
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType06_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType07_1[]= 
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType08_1[]=   /* 1400x1050 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType09_1[]=   /* 1280x768 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0a_1[]=  /* 1600x1200 */
{
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0},
	{ 0, 0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0b_1[]=  /* 640x480_2 */
{
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 8, 524},
	{ 0, 524}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0c_1[]=  /* 640x480_3 */
{
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 0, 524},
	{ 8, 524},
	{ 0, 524}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0d_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0e_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0f_1[]=  
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType00_2[]=  
{
	{980, 528},
	{980, 503},
	{980, 528},
	{980, 503},
	{980, 568},
	{ 0, 628},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType01_2[]= 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 806},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType02_2[]= 
{
	{1368, 754},
	{1368, 729},
	{1368, 754},
	{1368, 729},
	{1368, 794},
	{1448, 854},
	{1560, 938},
	{   0,1066},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType03_2[]=  
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType04_2[]=  
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType05_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType06_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType07_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType08_2[]=  /* 1400x1050 */
{
	{1308, 741},
	{1308, 716},
	{1308, 741},
	{1308, 716},
	{1308, 781},
	{1388, 841},
	{1500, 925},
	{1628,1053},
	{   0,1065},
	{   0,   0},
	{   0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType09_2[]= /* 1280x768 */
{
	{1083, 622},
	{1083, 597},
	{1083, 622},
	{1083, 597},
	{1083, 662},
	{1163, 722},
	{1286, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0a_2[]=  /* 1600x1200 */
{
	{1568, 920},
	{1568, 895},
	{1568, 920},
	{1568, 895},
	{1568, 960},
	{1648,1020},
	{1760,1104},
	{1888,1232},
	{1948,1245},
	{   0,   0}
#if 0
	{1568, 850},
	{1568, 825},
	{1568, 850},
	{1568, 825},
	{1568, 890},
	{1648, 950},
	{1760,1034},
	{1888,1162},
	{1948,1175},
	{   0,   0}
#endif
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0b_2[]=  /* 640x480_2 */
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0c_2[]=  /* 640x480_3 */
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0d_2[]=  
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0e_2[]= 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS310_LVDSDesStruct  SiS310_PanelType0f_2[] = 
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

/* CRT1 CRTC for SlaveModes and LCDA */

typedef struct _SiS310_LVDSCRT1DataStruct
{
 	UCHAR CR[15];
} SiS310_LVDSCRT1DataStruct;

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_1[] =
{
 {{0x6b,0x4f,0x8f,0x55,0x85,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x6b,0x4f,0x8f,0x55,0x85,0xfa,0x1f,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x69,0x19,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_1_H[] =
{
 {{0x43,0x27,0x87,0x2d,0x1d,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0xfa,0x1f,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0x78,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x43,0x27,0x87,0x2d,0x1d,0xfa,0x1f,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x4d,0x31,0x91,0x37,0x07,0x72,0xf0,
   0x58,0x8d,0x57,0x73,0x20,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_2[]=
{
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xe6,0x8b,0x5d,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xe6,0x8b,0x5d,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
   0x27,0x8c,0xdf,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x63,0x83,0x69,0x19,0x72,0xf0,
   0x58,0x8d,0x57,0x73,0x20,0x00,0x06,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_2_H[] =
{
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xd6,0x8b,0x5d,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xff,0x84,0x8f,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0x3e,
   0xd6,0x8b,0x5d,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x57,0x27,0x9b,0x3a,0x0a,0x72,0xba,
   0x27,0x8c,0xdf,0x73,0x00,0x00,0x01,
   0x00 }},
 {{0x4d,0x31,0x91,0x3a,0x0a,0x72,0xf0,
   0x63,0x88,0x57,0x73,0x00,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_1[] =
{
 {{0x73,0x4f,0x97,0x53,0x84,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x53,0x84,0x04,0x3e,
   0xE2,0x89,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x8B,0x67,0x18,0x7c,0xf0,
   0x5A,0x81,0x57,0x7D,0x00,0x00,0x06,
   0x01}},
 {{0xA3,0x7f,0x87,0x83,0x94,0x24,0xf5,
   0x02,0x89,0xFf,0x25,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_1_H[] =
{
 {{0x4b,0x27,0x8f,0x2b,0x1c,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00 }},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0x82,0x1f,
   0x60,0x87,0x5D,0x83,0x01,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0x82,0x1f,
   0x60,0x87,0x5D,0x83,0x01,0x00,0x05,
   0x00}},
 {{0x4b,0x27,0x8f,0x2b,0x1c,0x04,0x3e,
   0xE2,0x89,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x55,0x31,0x99,0x35,0x06,0x7c,0xf0,
   0x5A,0x81,0x57,0x7D,0x00,0x00,0x01,
   0x01}},
 {{0x63,0x3F,0x87,0x43,0x94,0x24,0xf5,
   0x02,0x89,0xFf,0x25,0x10,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_2[] =
{
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x06,
   0x01 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x7f,0x86,0xdf,0x25,0x10,0x00,0x06,
   0x00 }},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xbb,0x82,0x57,0x25,0x10,0x00,0x02,
   0x01 }},
 {{0xa3,0x7f,0x87,0x83,0x94,0x24,0xf5,
   0x02,0x89,0xff,0x25,0x10,0x00,0x02,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_2_H[] =
{
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x57,0x8e,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x3e,0x85,0x5d,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x7b,0x27,0x9f,0x46,0x97,0x24,0xbb,
   0x7f,0x86,0xdf,0x25,0x10,0x00,0x01,
   0x00 }},
 {{0x71,0x31,0x95,0x46,0x97,0x24,0xf1,
   0xbb,0x82,0x57,0x25,0x10,0x00,0x01,
   0x01 }},
 {{0x63,0x3f,0x87,0x46,0x97,0x24,0xf5,
   0x0f,0x86,0xff,0x25,0x30,0x00,0x01,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_1[] =
{
 {{0x7e,0x4f,0x82,0x58,0x04,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x06,
   0x00}},
 {{0x7e,0x4f,0x82,0x58,0x04,0x08,0x3e,
   0xe0,0x84,0xdf,0x09,0x00,0x00,0x06,
   0x00}},
 {{0x92,0x63,0x96,0x6c,0x18,0x80,0xf0,
   0x58,0x8c,0x57,0x81,0x20,0x00,0x06,
   0x01}},
 {{0xae,0x7f,0x92,0x88,0x94,0x28,0xf5,
   0x00,0x84,0xff,0x29,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_1_H[] =  
{
 {{0x56,0x27,0x9a,0x31,0x1c,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x9a,0x31,0x1c,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x9a,0x31,0x1c,0xb8,0x1f,
   0x90,0x84,0x8f,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x56,0x27,0x9a,0x31,0x1c,0x86,0x1f,
   0x5e,0x82,0x5d,0x87,0x10,0x00,0x05,
   0x01}},
 {{0x56,0x27,0x9a,0x31,0x1c,0x08,0x3e,
   0xe0,0x84,0xdf,0x09,0x00,0x00,0x05,
   0x00}},
 {{0x60,0x31,0x84,0x3a,0x86,0x80,0xf0,
   0x58,0x8c,0x57,0x81,0x20,0x00,0x01,
   0x01}},
 {{0x6e,0x3f,0x92,0x48,0x94,0x28,0xf5,
   0x00,0x84,0xff,0x29,0x10,0x00,0x01,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_2[] =  
{
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xaf,0x83,0x44,0x43,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xaf,0x83,0x44,0x43,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x81,0x8f,0x28,0x92,
   0xf0,0x84,0x85,0x84,0x11,0x00,0x02,
   0x01}},
 {{0xce,0x63,0x92,0x8b,0x19,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x7f,0x92,0x99,0x07,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_2_H[] = 
{
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xaf,0x83,0x44,0x43,0x21,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xc8,0x8c,0x5d,0x5c,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xfa,0x83,0x44,0x43,0x31,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x59,0x07,0x28,0x92,
   0xf0,0x84,0x85,0x84,0x11,0x00,0x06,
   0x01}},
 {{0x9c,0x31,0x80,0x59,0x87,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x92,0x59,0x07,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x06,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_1[] =
{
  {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
    0x8f,0x81,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
    0x5e,0x81,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
    0x90,0x83,0x8f,0x9f,0x30,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
    0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
    0x00}},
  {{0x6f,0x4f,0x93,0x54,0x82,0xee,0x1f,
    0xdf,0x82,0xdf,0xef,0x10,0x00,0x05,
    0x00}},
  {{0x83,0x63,0x87,0x68,0x16,0x66,0xf0,
    0x57,0x8e,0x57,0x67,0x20,0x00,0x06,
    0x01}},
  {{0x9f,0x7f,0x83,0x84,0x92,0x0e,0xf1,
    0xff,0x86,0xff,0x0f,0x10,0x00,0x02,
    0x01,}},
  {{0xbf,0x9f,0x83,0xa4,0x12,0x0e,0xde,
    0xff,0x86,0xff,0x0f,0x01,0x00,0x07,
    0x01}},
  {{0xce,0xae,0x92,0xb3,0x01,0x28,0x10,
    0x19,0x80,0x19,0x29,0x0f,0x00,0x03,
    0x00}}
#if 0
 {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x6f,0x4f,0x93,0x54,0x82,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x83,0x63,0x87,0x68,0x16,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x06,
   0x01}},
 {{0x9f,0x7f,0x83,0x84,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x02,
   0x01}},
 {{0xbf,0x9f,0x83,0xa4,0x12,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x07,
   0x01}},
 {{0xce,0xae,0x92,0xb3,0x01,0x28,0x10,
   0x1a,0x80,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_1_H[] = 
{
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x8f,0x81,0x8f,0x9f,0x30,0x00,0x05,
  0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x90,0x83,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xdf,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x57,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf1,
   0xff,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x76,0x56,0x9a,0x5b,0x89,0x28,0x10,
   0x1c,0x80,0x19,0x29,0x0b,0x00,0x05,
   0x00}}
#if 0
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x92,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x76,0x56,0x9a,0x5b,0x89,0x28,0x10,
   0x1c,0x80,0x19,0x29,0x0b,0x00,0x05,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_2[] =  
{
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x02,
   0x01}},
 {{0xce,0x72,0x91,0x84,0x92,0x28,0x92,
   0xff,0x83,0x85,0x84,0x11,0x00,0x02,
   0x01}},
 {{0xce,0x63,0x92,0x8e,0x1c,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x7f,0x92,0x9c,0x0a,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xac,0x1a,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x07,
   0x01}},
 {{0xce,0xae,0x92,0xbc,0x0a,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
#if 0
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x03,
   0x01}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x4f,0x92,0x8c,0x1a,0x28,0x9e,
   0x03,0x87,0xdf,0x29,0x01,0x00,0x03,
   0x00}},
 {{0xce,0x63,0x92,0x96,0x04,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x07,
   0x01}},
 {{0xce,0x7f,0x92,0xa4,0x12,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xb4,0x02,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x03,
   0x01}},
 {{0xce,0xae,0x92,0xbc,0x0a,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x03,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11400x1050_2_H[] =  
{
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xd7,0x8b,0x5d,0x5c,0x21,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xbe,0x82,0x44,0x43,0x01,0x00,0x06,
   0x01}},
 {{0xa6,0x4a,0x89,0x5c,0x0a,0x28,0x92,
   0xff,0x83,0x85,0x84,0x11,0x00,0x06,
   0x01}},
 {{0x9c,0x31,0x80,0x5c,0x8a,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x92,0x5c,0x0a,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x06,
   0x01}},
 {{0x7e,0x4f,0x82,0x5c,0x0a,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x06,
   0x01}},
 {{0x76,0x56,0x9a,0x64,0x92,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x05,
   0x00}}
#if 0
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xdb,0x8f,0x8f,0x29,0x21,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9a,
   0xc2,0x86,0x5d,0x29,0x01,0x00,0x06,
   0x00}},
 {{0xa6,0x27,0x8a,0x64,0x92,0x28,0x9e,
   0x03,0x87,0xdf,0x29,0x01,0x00,0x06,
   0x00}},
 {{0x9c,0x31,0x80,0x64,0x92,0x28,0xd4,
   0x3f,0x83,0x57,0x29,0x01,0x00,0x06,
   0x01}},
 {{0x8e,0x3f,0x92,0x64,0x12,0x28,0xd4,
   0x93,0x87,0xff,0x29,0x21,0x00,0x06,
   0x01}},
 {{0x7e,0x4f,0x82,0x64,0x12,0x28,0x5a,
   0x13,0x87,0xff,0x29,0x29,0x00,0x06,
   0x01}},
 {{0x76,0x56,0x9a,0x64,0x92,0x28,0x10,
   0x20,0x84,0x19,0x29,0x0f,0x00,0x05,
   0x00}}
#endif   
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_1[] =
{
 {{0x83,0x4F,0x87,0x5B,0x13,0x06,0x3E,
   0xB3,0x86,0x8F,0x07,0x20,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x87,0x5B,0x13,0xD4,0x1F,
   0x81,0x84,0x5D,0xD5,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x87,0x5B,0x13,0x06,0x3E,
   0xB3,0x86,0x8F,0x07,0x20,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x87,0x5B,0x13,0xD4,0x1F,
   0x81,0x84,0x5D,0xD5,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4F,0x87,0x5B,0x13,0x56,0xBA,
   0x03,0x86,0xDF,0x57,0x00,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9B,0x6F,0x07,0xCE,0xF0,
   0x7B,0x8E,0x57,0xCF,0x20,0x00,0x02,
   0x01}},
 {{0xB3,0x7F,0x97,0x8B,0x83,0x76,0xF5,
   0x23,0x86,0xFF,0x77,0x10,0x00,0x06,
   0x01}},
 {{0xD3,0x9F,0x97,0xAB,0x03,0x76,0x5A,
   0x23,0x86,0xFF,0x77,0x09,0x00,0x03,
   0x01}},
 {{0xE2,0xAE,0x86,0xBA,0x92,0x90,0x10,
   0x3D,0x80,0x19,0x91,0x0F,0x00,0x03,
   0x00}},
 {{0xFB,0xC7,0x9F,0xD3,0x8B,0x26,0x11,
   0xD3,0x86,0xAF,0x27,0x3F,0x00,0x07,
   0x00}}
#if 0
 {{0x83,0x4f,0x87,0x51,0x09,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x06,
   0x00}},
 {{0x83,0x4f,0x87,0x51,0x09,0x10,0x3e,
   0xe0,0x84,0xdf,0x11,0x00,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9b,0x65,0x1d,0x88,0xf0,
   0x58,0x8c,0x57,0x89,0x20,0x00,0x06,
   0x01}},
 {{0xb3,0x7f,0x97,0x81,0x99,0x30,0xf5,
   0x00,0x84,0xff,0x31,0x10,0x00,0x02,
   0x01}},
 {{0xd3,0x9f,0x97,0xa1,0x19,0x30,0x5a,
   0x00,0x84,0xff,0x31,0x09,0x00,0x07,
   0x01}},
 {{0xe2,0xae,0x86,0xb0,0x88,0x4a,0x10,
   0x1a,0x8e,0x19,0x4b,0x2f,0x00,0x03,
   0x00}},
 {{0xfb,0xc7,0x9f,0xc9,0x81,0xe0,0x10,
   0xb0,0x84,0xaf,0xe1,0x2f,0x00,0x07,
   0x00}}
#endif
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_1_H[] =
{
 {{0x5B,0x27,0x9F,0x33,0x0B,0x06,0x2E,
   0xB3,0x86,0x8F,0x07,0x20,0x00,0x01,
   0x00}},
 {{0x5B,0x27,0x9F,0x29,0x01,0x8E,0x1F,
   0x81,0x84,0x5D,0xD5,0x10,0x00,0x06,
   0x00}},
 {{0x5B,0x27,0x9F,0x33,0x0B,0x06,0x2E,
   0xB3,0x86,0x8F,0x07,0x20,0x00,0x01,
   0x00}},
 {{0x83,0x4F,0x87,0x5B,0x13,0xD4,0x1F,
   0x81,0x84,0x5D,0xD5,0x10,0x00,0x06,
   0x00}},
 {{0x5B,0x27,0x9F,0x33,0x0B,0x56,0xBA,
   0x03,0x86,0xDF,0x57,0x00,0x00,0x01,
   0x00}},
 {{0x65,0x31,0x89,0x3D,0x95,0xCE,0xF0,
   0x7B,0x8E,0x57,0xCF,0x20,0x00,0x01,
   0x01}},
 {{0x73,0x3F,0x97,0x4B,0x83,0x76,0xF5,
   0x23,0x86,0xFF,0x77,0x10,0x00,0x05,
   0x01}},
 {{0xD3,0x9F,0x97,0xAB,0x03,0x76,0x5A,
   0x23,0x86,0xFF,0x77,0x09,0x00,0x03,
   0x01}},
 {{0xE2,0xAE,0x86,0xBA,0x92,0x90,0x10,
   0x3D,0x80,0x19,0x91,0x0F,0x00,0x03,
   0x00}},
 {{0x97,0x63,0x9B,0x6F,0x07,0xE0,0x10,
   0xB0,0x84,0xAF,0xE1,0x2F,0x00,0x06,
   0x00}}
#if 0
 {{0x5b,0x27,0x9f,0x29,0x01,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0xc0,0x1f,
   0x90,0x84,0x8f,0xc1,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0x8e,0x1f,
   0x5e,0x82,0x5d,0x8f,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x27,0x9f,0x29,0x01,0x10,0x3e,
   0xe0,0x84,0xdf,0x11,0x00,0x00,0x01,
   0x00}},
 {{0x65,0x31,0x89,0x33,0x8b,0x88,0xf0,
   0x58,0x8c,0x57,0x89,0x20,0x00,0x01,
   0x01}},
 {{0x73,0x3f,0x97,0x41,0x99,0x30,0xf5,
   0x00,0x84,0xff,0x31,0x10,0x00,0x01,
   0x01}},
 {{0x83,0x4f,0x87,0x51,0x09,0x30,0x5a,
   0x00,0x84,0xff,0x31,0x09,0x00,0x06,
   0x01}},
 {{0x8a,0x56,0x8e,0x58,0x10,0x4a,0x10,
   0x1a,0x8e,0x19,0x4b,0x2f,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9b,0x65,0x1d,0xe0,0x10,
   0xb0,0x84,0xaf,0xe1,0x2f,0x00,0x06,
   0x00}}
#endif
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_2[] =
{
 {{0xFB,0x87,0x86,0x97,0x0F,0x26,0x97,
   0x43,0x86,0xDB,0xDA,0x11,0x00,0x07,
   0x01}},
 {{0xFB,0x87,0x86,0x97,0x0F,0x26,0x97,
   0x2A,0x8D,0xC2,0xC1,0x11,0x00,0x07,
   0x01}},
 {{0xFB,0x87,0x86,0x97,0x0F,0x26,0x97,
   0x43,0x86,0xDB,0xDA,0x11,0x00,0x07,
   0x01}},
 {{0xFB,0x87,0x86,0x97,0x0F,0x26,0x97,
   0x2A,0x8D,0xC2,0xC1,0x11,0x00,0x07,
   0x01}},
 {{0xFB,0x87,0x86,0x97,0x0F,0x26,0x9F,
   0x6B,0x8E,0x03,0x02,0x01,0x00,0x07,
   0x01}},
 {{0xFB,0x63,0x9F,0xA1,0x99,0x26,0xD5,
   0xA7,0x8A,0xBF,0xBE,0x01,0x00,0x07,
   0x01}},
 {{0xFB,0x7F,0x9F,0xAF,0x87,0x26,0xDD,
   0xFB,0x8E,0x13,0x12,0x31,0x00,0x03,
   0x01}},
 {{0xFB,0x9F,0x9F,0xBF,0x97,0x26,0x5B,
   0x7B,0x8E,0xFF,0x27,0x39,0x00,0x03,
   0x01}},
 {{0xFB,0xAE,0x9F,0xC6,0x9E,0x26,0x11,
   0x88,0x8B,0x19,0x27,0x1F,0x00,0x03,
   0x00}},
 {{0xFB,0xC7,0x9F,0xD3,0x8B,0x26,0x11,
   0xD3,0x86,0xAF,0x27,0x3F,0x00,0x07,
   0x00}}
#if 0
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x07,
   0x01}},
 {{0xfb,0x88,0x87,0x90,0x08,0xe0,0x96,
   0x48,0x8c,0xe1,0xe0,0x11,0x00,0x07,
   0x01}},
 {{0xfb,0x63,0x9f,0x9a,0x92,0xe0,0xd4,
   0x9b,0x8f,0x9d,0x9c,0x21,0x00,0x07,
   0x01}},
 {{0xfb,0x7f,0x9f,0xa8,0x80,0xe0,0xd4,
   0xef,0x83,0xff,0xe1,0x21,0x00,0x03,
   0x01}},
 {{0xfb,0x9f,0x9f,0xb8,0x90,0xe0,0x5a,
   0x6f,0x83,0xff,0xe1,0x29,0x00,0x03,
   0x01}},
 {{0xfb,0xae,0x9f,0xbf,0x97,0xe0,0x10,
   0x7c,0x80,0x19,0xe1,0x0f,0x00,0x03,
   0x00}},
 {{0xfb,0xc7,0x9f,0xc9,0x84,0xe0,0x10,
   0xc7,0x8b,0xaf,0xe1,0x0f,0x00,0x07,
   0x00}}
#endif
};

static const SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11600x1200_2_H[] = 
{
 {{0xD3,0x5F,0x9E,0x6F,0x07,0x26,0x97,
   0x43,0x86,0xDB,0xDA,0x11,0x00,0x02,
   0x01}},
 {{0xD3,0x27,0x97,0x6F,0x07,0x26,0x97,
   0x6B,0x8E,0x83,0x82,0x01,0x00,0x03,
   0x01}},
 {{0xD3,0x5F,0x9E,0x6F,0x07,0x26,0x97,
   0x43,0x86,0xDB,0xDA,0x11,0x00,0x02,
   0x01}},
 {{0xD3,0x27,0x97,0x6F,0x07,0x26,0x97,
   0x07,0x8B,0xA0,0x9F,0x01,0x00,0x02,
   0x01}},
 {{0xD3,0x27,0x97,0x6F,0x07,0x26,0x97,
   0x6B,0x8E,0x83,0x82,0x01,0x00,0x03,
   0x01}},
 {{0xC9,0x31,0x8D,0x6F,0x07,0x26,0xD5,
   0xA7,0x8A,0xBF,0xBE,0x01,0x00,0x03,
   0x01}},
 {{0xBB,0x3F,0x9F,0x6F,0x87,0x26,0xDD,
   0xFB,0x8E,0x13,0x12,0x31,0x00,0x02,
   0x01}},
 {{0xAB,0x4F,0x8F,0x68,0x80,0xE0,0x5A,
   0x6F,0x83,0xFF,0xE1,0x29,0x00,0x02,
   0x01}},
 {{0xA3,0x56,0x87,0x67,0x9F,0xE0,0x10,
   0x7C,0x80,0x19,0xE1,0x0F,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9B,0x68,0x00,0xE0,0x10,
   0xC7,0x8B,0xAF,0xE1,0x0F,0x00,0x02,
   0x00}}
#if 0
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x20,0x84,0xb9,0xb8,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x07,0x8b,0xa0,0x9f,0x01,0x00,0x02,
   0x01}},
 {{0xd3,0x60,0x9f,0x68,0x00,0xe0,0x96,
   0x48,0x8c,0xe1,0xe0,0x11,0x00,0x02,
   0x01}},
 {{0xc9,0x31,0x8d,0x68,0x00,0xe0,0xd4,
   0x9b,0x8f,0x9d,0x9c,0x21,0x00,0x03,
   0x01}},
 {{0xbb,0x3f,0x9f,0x68,0x80,0xe0,0xd4,
   0xef,0x83,0xff,0xe1,0x21,0x00,0x02,
   0x01}},
 {{0xab,0x4f,0x8f,0x68,0x80,0xe0,0x5a,
   0x6f,0x83,0xff,0xe1,0x29,0x00,0x02,
   0x01}},
 {{0xa3,0x56,0x87,0x67,0x9f,0xe0,0x10,
   0x7c,0x80,0x19,0xe1,0x0f,0x00,0x06,
   0x00}},
 {{0x97,0x63,0x9b,0x68,0x00,0xe0,0x10,
   0xc7,0x8b,0xaf,0xe1,0x0f,0x00,0x02,
   0x00}}
#endif
};

/* CRT1 CRTC for Chrontel TV slave modes */

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1UNTSC[] =  
{ 
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
   0x00 }},
 {{0x5d,0x4f,0x81,0x56,0x99,0x56,0xba,
   0x0a,0x84,0xdf,0x57,0x00,0x00,0x01,
   0x00 }},
 {{0x80,0x63,0x84,0x6d,0x0f,0xec,0xf0,
   0x7a,0x8f,0x57,0xed,0x20,0x00,0x06,
   0x01 }},
 {{0x8c,0x7f,0x90,0x86,0x09,0xaf,0xf5,
   0x36,0x88,0xff,0xb0,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1ONTSC[] =
{
 {{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
   0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
   0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
   0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x5a,0x9f,0x0b,0x3e,
   0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
   0x00 }},
 {{0x5d,0x4f,0x81,0x58,0x9d,0x0b,0x3e,
   0xe8,0x84,0xdf,0x0c,0x00,0x00,0x01,
   0x00 }},
 {{0x7d,0x63,0x81,0x68,0x0e,0xba,0xf0,
   0x78,0x8a,0x57,0xbb,0x20,0x00,0x06,
   0x01 }},
 {{0x8c,0x7f,0x90,0x82,0x06,0x46,0xf5,
   0x15,0x88,0xff,0x47,0x70,0x00,0x02,
   0x01 }}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1UPAL[] =    
{ 
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x64,0x4f,0x88,0x5a,0x9f,0x6f,0xba,
   0x15,0x83,0xdf,0x70,0x00,0x00,0x01,
   0x00 }},
 {{0x73,0x63,0x97,0x69,0x8b,0xec,0xf0,
   0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
   0x01 }},
 {{0xaa,0x7f,0x8e,0x8e,0x96,0xe6,0xf5,
   0x50,0x88,0xff,0xe7,0x10,0x00,0x02,
   0x01}}
};

static const SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1OPAL[] =
{
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x64,0x4f,0x88,0x58,0x9d,0x6f,0xba,
   0x15,0x83,0xdf,0x70,0x00,0x00,0x01,
   0x00 }},
 {{0x71,0x63,0x95,0x69,0x8c,0x6f,0xf0,
   0x5a,0x8b,0x57,0x70,0x20,0x00,0x05,
   0x01 }},
 {{0xaa,0x7f,0x8e,0x8f,0x96,0x69,0xf5,
   0x28,0x88,0xff,0x6a,0x10,0x00,0x02,
   0x01 }}
};

typedef struct _SiS310_CHTVRegDataStruct
{
 	UCHAR Reg[16];
} SiS310_CHTVRegDataStruct;

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UNTSC[] =
{
 {{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x4a,0x77,0xbb,0x94,0x84,0x48,0xfe,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x6a,0x77,0xbb,0x6e,0x84,0x2e,0x02,0x5a,0x04,0x00,0x80,0x20,0x7e,0x80,0x98,0x00}},
 {{0xcf,0x77,0xb7,0xc8,0x84,0x3b,0x02,0x5a,0x04,0x00,0x80,0x19,0x88,0x30,0x7f,0x00}},
 {{0xee,0x77,0xbb,0x66,0x87,0x32,0x01,0x5a,0x04,0x00,0x80,0x1b,0xd3,0xf2,0x36,0x00}}
}; /* WRONG: 0x02: should be 0xfx, because if CIVEnable is clear, this should be set;
             0x07: Blacklevel: NTSC/PAL-M: Should be 131 (0x83), and not 0x50/0x5a
	                       PAL/PAL-N:  110 (0x6e)
			       NTSC-J:     102 (0x66)
	     0x0c-0x0f: CIV is not default as in datasheet
      MISSING: 0x21: Should set D1 to ZERO (for NTSC, PAL-M) or ONE (PAL, NTSC-J)
      Most of this is wrong in all NTSC and PAL register arrays. But I won't correct
      it as long as it works. For NTSC-J, the blacklevel is corrected in init301.c;
      for PAL-M and PAL-N all above is corrected.
    */

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_ONTSC[] =
{
 {{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x49,0x77,0xbb,0x7b,0x84,0x34,0x00,0x50,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x69,0x77,0xbb,0x6e,0x84,0x1e,0x00,0x5a,0x04,0x00,0x80,0x25,0x1a,0x43,0x04,0x00}},
 {{0xce,0x77,0xb7,0xb6,0x83,0x2c,0x02,0x5a,0x04,0x00,0x80,0x1c,0x00,0x82,0x97,0x00}},
 {{0xed,0x77,0xbb,0x66,0x8c,0x21,0x02,0x5a,0x04,0x00,0x80,0x1f,0x9f,0xc1,0x0c,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPAL[] =
{
 {{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x41,0x7f,0xb7,0x80,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x41,0x7f,0xb7,0x12,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x26,0x2a,0x55,0x5d,0x00}},
 {{0xc3,0x7f,0xb7,0x7a,0x84,0x40,0x02,0x5a,0x05,0x00,0x80,0x1f,0x84,0x3d,0x28,0x00}},
 {{0xe5,0x7f,0xb7,0x1d,0xa7,0x3e,0x04,0x5a,0x05,0x00,0x80,0x20,0x3e,0xe4,0x22,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPAL[] =
{
 {{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x83,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x26,0x2a,0x55,0x5d,0x00}},
 {{0xc1,0x7f,0xb7,0x4d,0x8c,0x1e,0x31,0x5a,0x05,0x00,0x80,0x26,0x78,0x19,0x34,0x00}},
 {{0xe4,0x7f,0xb7,0x1e,0xaf,0x29,0x37,0x5a,0x05,0x00,0x80,0x25,0x8c,0xb2,0x2a,0x00}}
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPALM[] =
{
 {{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x52,0x77,0xbb,0x94,0x84,0x48,0xfe,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x72,0x77,0xfb,0x6e,0x84,0x2e,0x02,0x83,0x04,0x00,0x80,0x20,0x76,0xdb,0x6e,0x00}},
 {{0xd7,0x77,0xf7,0xc8,0x84,0x3b,0x02,0x83,0x04,0x00,0x80,0x19,0x84,0x0a,0xc7,0x00}},
 {{0xf6,0x77,0xfb,0x66,0x87,0x32,0x01,0x83,0x04,0x00,0x80,0x1b,0xdc,0xb0,0x8d,0x00}}
#if 0 /* Correct blacklevel and CFRB */
 {{0x72,0x77,0xbb,0x6e,0x84,0x2e,0x02,0x5a,0x04,0x00,0x80,0x20,0x76,0xdb,0x6e,0x00}},
 {{0xd7,0x77,0xb7,0xc8,0x84,0x3b,0x02,0x5a,0x04,0x00,0x80,0x19,0x84,0x0a,0xc7,0x00}},
 {{0xf6,0x77,0xbb,0x66,0x87,0x32,0x01,0x5a,0x04,0x00,0x80,0x1b,0xdc,0xb0,0x8d,0x00}}
#endif
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPALM[] =
{
 {{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x51,0x77,0xbb,0x7b,0x84,0x34,0x00,0x83,0x04,0x00,0x80,0x00,0x00,0x00,0x00,0x01}},
 {{0x71,0x77,0xfb,0x6e,0x84,0x1e,0x00,0x83,0x04,0x00,0x80,0x25,0x1a,0x1f,0x59,0x00}},
 {{0xd6,0x77,0xf7,0xb6,0x83,0x2c,0x02,0x83,0x04,0x00,0x80,0x1b,0xf8,0x1f,0x82,0x00}},
 {{0xf5,0x77,0xfb,0x66,0x8c,0x21,0x02,0x83,0x04,0x00,0x80,0x1f,0x58,0x46,0x9f,0x00}}
#if 0 /* Correct blacklevel and CFRB */
 {{0x71,0x77,0xbb,0x6e,0x84,0x1e,0x00,0x5a,0x04,0x00,0x80,0x25,0x1a,0x1f,0x59,0x00}},
 {{0xd6,0x77,0xb7,0xb6,0x83,0x2c,0x02,0x5a,0x04,0x00,0x80,0x1b,0xf8,0x1f,0x82,0x00}},
 {{0xf5,0x77,0xbb,0x66,0x8c,0x21,0x02,0x5a,0x04,0x00,0x80,0x1f,0x58,0x46,0x9f,0x00}}
#endif
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPALN[] =
{
 {{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x41,0x7f,0xb7,0x80,0x85,0x50,0x00,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x41,0x7f,0xb7,0x34,0xad,0x50,0x34,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x41,0x7f,0xb7,0x12,0x85,0x50,0x00,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0xc3,0x7f,0xb7,0x7a,0x84,0x40,0x02,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0xe5,0x7f,0xb7,0x1d,0xa7,0x3e,0x04,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}}
#if 0 /* Correct blacklevel, CIV and CFRB */
 {{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x1f,0x0d,0x54,0x5e,0x00}},
 {{0xc3,0x7f,0xb7,0x7a,0x84,0x40,0x02,0x5a,0x05,0x00,0x80,0x19,0x78,0xef,0x35,0x00}},
 {{0xe5,0x7f,0xb7,0x1d,0xa7,0x3e,0x04,0x5a,0x05,0x00,0x80,0x1a,0x33,0x3f,0x2f,0x00}}
#endif
};

static const SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPALN[] =
{
 {{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x41,0x7f,0xb7,0x36,0xad,0x50,0x34,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x41,0x7f,0xb7,0x86,0x85,0x50,0x00,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0xc1,0x7f,0xb7,0x4d,0x8c,0x1e,0x31,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}},
 {{0xe4,0x7f,0xb7,0x1e,0xaf,0x29,0x37,0x6e,0x05,0x00,0x80,0x00,0x00,0x00,0x00,0x03}}
#if 0 /* Correct blacklevel, CIV and CFRB */
 {{0x61,0x7f,0xb7,0x99,0x84,0x35,0x04,0x5a,0x05,0x00,0x80,0x1f,0x0d,0x54,0x5e,0x00}},
 {{0xc1,0x7f,0xb7,0x4d,0x8c,0x1e,0x31,0x5a,0x05,0x00,0x80,0x1f,0x15,0xc0,0x1e,0x00}},
 {{0xe4,0x7f,0xb7,0x1e,0xaf,0x29,0x37,0x5a,0x05,0x00,0x80,0x1d,0xf1,0x6c,0xcb,0x00}}
#endif
};

static const UCHAR SiS310_CHTVVCLKUNTSC[] = {0x41,0x41,0x41,0x41,0x42,0x46,0x53};
static const UCHAR SiS310_CHTVVCLKONTSC[] = {0x48,0x48,0x48,0x48,0x45,0x43,0x51};

static const UCHAR SiS310_CHTVVCLKUPAL[]  = {0x47,0x47,0x47,0x47,0x48,0x4a,0x54};
static const UCHAR SiS310_CHTVVCLKOPAL[]  = {0x47,0x47,0x47,0x47,0x48,0x4f,0x52};

static const UCHAR SiS310_CHTVVCLKUPALM[] = {0x41,0x41,0x41,0x41,0x42,0x46,0x53};
static const UCHAR SiS310_CHTVVCLKOPALM[] = {0x48,0x48,0x48,0x48,0x45,0x43,0x51};

static const UCHAR SiS310_CHTVVCLKUPALN[] = {0x47,0x47,0x47,0x47,0x48,0x4a,0x54};
static const UCHAR SiS310_CHTVVCLKOPALN[] = {0x47,0x47,0x47,0x47,0x48,0x4f,0x52};


