#!/usr/bin/perl

# automatically generate the xf86DefModeSet.c file from a normal
# XF86Config style file of Modelines
#
# run as 
#
# perl /modeline2c.pl < [modesfile] > xf86DefModes.c
#
# hackish perl - author Dirk Hohndel
#
# Copyright 1999-2003 by The XFree86 Project, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# Except as contained in this notice, the name of the copyright holder(s)
# and author(s) shall not be used in advertising or otherwise to promote
# the sale, use or other dealings in this Software without prior written
# authorization from the copyright holder(s) and author(s).
#
# $XFree86: xc/programs/Xserver/hw/xfree86/common/modeline2c.pl,v 1.10 2003/08/24 17:36:49 dawes Exp $

#my %flagshash;
$flagshash{""} = "0";
# $flagshash{"Interlace"} = "V_INTERLACE";
# $flagshash{"+hsync"} = "V_PHSYNC";
# $flagshash{"-hsync"} = "V_NHSYNC";
# $flagshash{"+vsync"} = "V_PVSYNC";
# $flagshash{"-vsync"} = "V_NVSYNC";
# XXX I'm definitely not a perl guru...   -- tsi
$flagshash{"+hsync +vsync"} = "V_PHSYNC | V_PVSYNC";
$flagshash{"+hsync -vsync"} = "V_PHSYNC | V_NVSYNC";
$flagshash{"-hsync +vsync"} = "V_NHSYNC | V_PVSYNC";
$flagshash{"-hsync -vsync"} = "V_NHSYNC | V_NVSYNC";
$flagshash{"+hsync +vsync interlace"} = "V_PHSYNC | V_PVSYNC | V_INTERLACE";
$flagshash{"+hsync -vsync interlace"} = "V_PHSYNC | V_NVSYNC | V_INTERLACE";
$flagshash{"-hsync +vsync interlace"} = "V_NHSYNC | V_PVSYNC | V_INTERLACE";
$flagshash{"-hsync -vsync interlace"} = "V_NHSYNC | V_NVSYNC | V_INTERLACE";

# stop CVS from expanding the XFree86 Id here...

$proj = "XFree86";
printf("/* \$$proj: \$ */

/* THIS FILE IS AUTOMATICALLY GENERATED -- DO NOT EDIT -- LOOK at
 * modeline2c.pl */

/*
 * Copyright 1999-2003 by The XFree86 Project, Inc.
 *
 * Author: Dirk Hohndel <hohndel\@XFree86.Org>
 */

#ifdef __UNIXOS2__
#define I_NEED_OS2_H
#endif
#include \"xf86.h\"
#include \"xf86Config.h\"
#include \"xf86Priv.h\"
#include \"xf86_OSlib.h\"

#include \"globals.h\"

#define MODEPREFIX(name) NULL, NULL, name, 0,M_T_DEFAULT
#define MODESUFFIX       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,0,NULL,0,0.0,0.0

DisplayModeRec xf86DefaultModes [] = {
");
while (<>) {
  if (/^\#/) {
    s/^\#//;
    chop;
    print "/*" . $_ . " */\n";
  }
  if (/^ModeLine\s+(\S+)\s+([\d.\s]+)(.*)/i) {
    $name = $1;
    $values = $2;
    $flags = $3;
    $flags =~ y/A-Z/a-z/;
    $values =~ /([\d.]+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/;
    printf("\t{MODEPREFIX(%s),%d, %d,%d,%d,%d,0, %d,%d,%d,%d,0, %s, MODESUFFIX},\n",
	   $name,$1*1000,$2,$3,$4,$5,$6,$7,$8,$9,$flagshash{$flags});
# Also generate half-width doublescanned modes
    printf("\t{MODEPREFIX(\"%dx%d\"),%d, %d,%d,%d,%d,0, %d,%d,%d,%d,0, %s | V_DBLSCAN, MODESUFFIX},\n",
	   $2/2,$6/2,$1*500,$2/2,$3/2,$4/2,$5/2,$6/2,$7/2,$8/2,$9/2,$flagshash{$flags});
  }


}
printf("\t{MODEPREFIX(NULL),0,0,0,0,0,0,0,0,0,0,0,0,MODESUFFIX}\n};\n");
