#!/bin/sh

# Build script template [20060202]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=gnome_misc_plamo
ORIGVER=4.2
PKGVER=P3
GNOMEVER=2.12.2.1
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-noarch-$PKGVER.tgz
SRCPKG=gnome-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

SRCDIR1=background-properties
SRCDIR2=desktop-links
SRCDIR3=icons
SRCDIR4=../garnome-Ptgz-kit

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

mkdir -p $PKGROOT$PREFIX/share/gnome-background-properties
install -c -o0 -g0 -m0644 $SRCDIR1/* $PKGROOT$PREFIX/share/gnome-background-properties

mkdir -p $PKGROOT$PREFIX/share/applications
install -c -o0 -g0 -m0644 $SRCDIR2/* $PKGROOT$PREFIX/share/applications

mkdir -p $PKGROOT$PREFIX/share/pixmaps
install -c -o0 -g0 -m0644 $SRCDIR3/* $PKGROOT$PREFIX/share/pixmaps

mkdir -p $PKGROOT$PREFIX/src/garnome-Ptgz-kit
(cd $SRCDIR4; tar cf - README PlamoBuild.sh files hacks tools) | (cd $PKGROOT$PREFIX/src/garnome-Ptgz-kit; tar xf -)
(
    cd $PKGROOT$PREFIX/src/garnome-Ptgz-kit
    mkdir download packages
    chown -R 0:0 .
    find . -type d -exec chmod 755 {} ';'
    find . -type f -exec chmod 644 {} ';'
)

mkdir -p $PKGROOT$DOCPREFIX/GNOME-$GNOMEVER-for-Plamo-$ORIGVER
cp doc/* $PKGROOT$DOCPREFIX/GNOME-$GNOMEVER-for-Plamo-$ORIGVER
gzip $PKGROOT$DOCPREFIX/GNOME-$GNOMEVER-for-Plamo-$ORIGVER/README

## Custom packaging sequence:

mkdir $PKGROOT/install
echo "if [ -x $PREFIX/bin/update-desktop-database ]; then" > $PKGROOT/install/initpkg
echo "  $PREFIX/bin/update-desktop-database $PREFIX/share/applications" >> $PKGROOT/install/initpkg
echo 'fi' >> $PKGROOT/install/initpkg

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

mkdir $PKGROOT$PREFIX/src/$SHORTNAME-build
(cd $SRCROOT; tar cf - $0 $SRCDIR1 $SRCDIR2 $SRCDIR3 doc) | (cd $PKGROOT$PREFIX/src/$SHORTNAME-build; tar xf -)
cd $PKGROOT$PREFIX/src
tar zcf $SRCPKG garnome-Ptgz-kit $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
