#include "pty.H"

// ƥåʥ(ʥϥɥǤȤ)
int Pty::child = 0;
struct termios Pty::tt;
int Pty::wfd = 0;
int Pty::hs = 0;
char* Pty::ce = 0;
char* Pty::ts = 0;
char* Pty::ds = 0;
char Pty::endstr[] = "";
char Pty::endmsg[] = "";

// 󥹥ȥ饯
Pty::Pty(int ac, char** av, char* amsg, char* emsg)
{
    // Ķѿ TERM Υȥ
    char buff[BUFSIZ];
    char* term = getenv("TERM");
    if (!term)
        term = "vt100";
    int ret = tgetent(buff, term);
    if (ret != 1) {
        tgetent(buff, "vt100");
        putenv("TERM=vt100");
    }

    // termcap ѤΥȥäƤ
    char funcstr[BUFSIZ];
    char* pt = funcstr;

    // ɥ (ȿž)
    so = tgetstr("so", &pt);
    adjstr(so);
    se = tgetstr("se", &pt);
    adjstr(se);

    // 饤 ()
    us = tgetstr("us", &pt);
    adjstr(us);
    ue = tgetstr("ue", &pt);
    adjstr(ue);

    // ֤¸¸֤ؤ
    sc = tgetstr("sc", &pt);
    adjstr(sc);
    rc = tgetstr("rc", &pt);
    adjstr(rc);

    // ֤ԤκǸޤǤ
    ce = tgetstr("ce", &pt);
    adjstr(ce);

    // ơ饤äƤ뤫ɤ
    hs = tgetflag("hs");

    // kon  jfbterm Ǥϥơ饤Ȥʤ
    if (strcmp(term, "kon") == 0)
        hs = 0;
    if (strcmp(term, "jfbterm") == 0)
        hs = 0;

    // ơ饤ذư
    if (hs) {
        ts = tgoto(tgetstr("ts", &pt), 0, 0);
        adjstr(ts);
        fs = tgetstr("fs", &pt);
        adjstr(fs);
        ds = tgetstr("ds", &pt);
        adjstr(ds);
        if (ds) {
            strcat(endstr, ds);
            strcat(endstr, ce);
        }
    }
    else {
        char* cs = tgoto(tgetstr("cs", &pt), tgetnum("li") - 2, 0);
        adjstr(cs);
        if (cs) {
            write(1, ce, strlen(ce));
            write(1, cs, strlen(cs));
        }
        char* cl = tgetstr("cl", &pt);
        adjstr(cl);
        if (cl) {
            write(1, cl, strlen(cl));
            strcat(endstr, cl);
        }
        ds = tgoto(tgetstr("cs", &pt), tgetnum("li") - 1, 0);
        adjstr(ds);
        if (ds) {
            strcat(endstr, ds);
            strcat(endstr, ce);
        }
        ts = tgoto(tgetstr("cm", &pt), 0, tgetnum("li") - 1);
        adjstr(ts);
        fs = rc;
    }

    // ϤȽλΥå
    if (amsg && ac == 1)
        write(1, amsg, strlen(amsg));
    if (emsg && ac == 1)
        strcpy(endmsg, emsg);

    // Ѥ벾üǥХ̾
    // XX  [p-s][0-f] 
    strcpy(line, "/dev/ptyXX");

    // üǵư shell ϲ
    char* shell = getenv("SHELL");
    if (shell == NULL)
        shell = "/bin/sh";

    // ޥǥХμ
    getmaster();

    // üν
    fixtty();

    // եޤ
    child = fork();
    if (child < 0) {
        perror("fork");
        fail();
    }

    // ҶǤ
    if (child == 0) {
        subchild = child = fork();
        if (child < 0) {
            perror("fork");
            fail();
        }
        if (child) {
            close(0);
            int cc;
            int ret;
            char obuf[BUFSIZ];
            char buff[BUFSIZ];
            fd_set readfds;
            FD_ZERO(&readfds);
            FD_SET(master, &readfds);
            while (1) {
                ret = select(master + 1, &readfds, 0, 0, 0);
                if (ret == -1)
                    break;
                if (!FD_ISSET(master, &readfds))
                    continue;
                cc = (int) read(master, obuf, BUFSIZ);
                if (cc <= 0)
                    break;
                write(1, obuf, cc);
            }
            done();
        }
        int t = open("/dev/tty", O_RDWR);
        if (t >= 0) {
            ioctl(t, TIOCNOTTY, (char*) 0);
            close(t);
        }
        getslave();
        close(master);
        dup2(slave, 0);
        dup2(slave, 1);
        dup2(slave, 2);
        close(slave);
        if (ac > 1)
            execvp(av[1], &av[1]);
        else
            execl(shell, strrchr(shell, '/') + 1, 0);
        perror(shell);
        fail();
    }

    // ƤǤ
    rfd = 0;
    wfd = master;

    // ʥϥɥ
    signal(SIGCHLD, (SIG_PF) finish);
    signal(SIGWINCH, (SIG_PF) winchange);
}

// ǥȥ饯
Pty::~Pty()
{
    done();
}

// λ˸ƤФ
void
Pty::done()
{
    if (subchild) {
        close(master);
        exit(0);
    }

    tcsetattr(0, TCSAFLUSH, &tt);
    exit(0);
}

// 㳲ä
void
Pty::fail()
{
    kill(0, SIGTERM);
    done();
}

// termcap ȥ꤫ѥǥ󥰤
void
Pty::adjstr(char* str)
{
    char* sp = strdup(str);
    char* p = sp;
    while (*p != '\0') {
        if (strncmp(p, "$<", 2) == 0) {
            while (*p != '>')
                p++;
            *p = '\0';
        }
        *str++ = *p++;
    }
    free(sp);
}

// ޥǥХ
void 
Pty::getmaster()
{
    struct stat stb;

    char* pty = &line[strlen("/dev/ptyp")];
    for (char* p = "pqrs"; *p; p++) {
        line[strlen("/dev/pty")] = *p;
        *pty = '0';
        if (stat(line, &stb) < 0)
            break;
        for (char* s = "0123456789abcdef"; *s; s++) {
            *pty = *s;
            master = open(line, O_RDWR);
            if (master < 0) 
                continue;
            char* t = &line[strlen("/dev/")];
            *t = 't';
            int ok = access(line, R_OK|W_OK) == 0;
            *t = 'p';
            if (ok) {
                tcgetattr(0, &tt);
                tt.c_iflag &= ~ISTRIP;
                ioctl(0, TIOCGWINSZ, (char*) &win);
                return;
            }
            close(master);
        }
    }

    printf("Out of pty's\n");
    fail();
}

// 졼֥ǥХ
void
Pty::getslave()
{
    line[strlen("/dev/")] = 't';
    slave = open(line, O_RDWR);
    if (slave < 0) {
        perror(line);
        fail();
    }
    tcsetattr(slave, TCSAFLUSH, &tt);
    if (!hs)
        win.ws_row--;
    ioctl(slave, TIOCSWINSZ, (char*) &win);
    setsid();
#if !defined(sun)
    close(slave);
    slave = open(line, O_RDWR);
    if (slave < 0) {
        perror(line);
        fail();
    }
#endif
}

// üν
void
Pty::fixtty()
{
    struct termios rtt;
    rtt = tt;
    rtt.c_iflag &= ~(INLCR|IGNCR|ICRNL|IXON|IXOFF|ISTRIP);
    rtt.c_lflag &= ~(ISIG|ICANON|ECHO);
    rtt.c_oflag &= ~OPOST;
    rtt.c_cc[VMIN] = 1;
    rtt.c_cc[VTIME] = 0;
    tcsetattr(0, TCSAFLUSH, &rtt);
}

// ʥ˸ƤФ
void
Pty::finish()
{
    int status;
    int pid;
    int die = 0;
    while ((pid = wait3(&status, WNOHANG, 0)) > 0) { 
        if (pid == child)
            die = 1;
    }
    if (die) {
        tcsetattr(0, TCSAFLUSH, &tt);
        if (strlen(endstr) != 0)
            printf("%s", endstr);
        if (strlen(endmsg) != 0)
            printf("%s", endmsg);
        exit(0);
    }
}

// ɥΥꥵ˸ƤФ
void
Pty::winchange()
{
    signal(SIGWINCH, SIG_IGN);

    // ơ饤󤬻Ȥʤ cs/ds/ts ľ
    if (!hs) {
        char buff[BUFSIZ];
        char* term = getenv("TERM");
        tgetent(buff, term);
        char funcstr[BUFSIZ];
        char* pt = funcstr;
        char* cs = tgoto(tgetstr("cs", &pt), tgetnum("li") - 2, 0);
        adjstr(cs);
        if (cs) {
            write(1, ce, strlen(ce));
            write(1, cs, strlen(cs));
        }
        char* cl = tgetstr("cl", &pt);
        adjstr(cl);
        if (cl) {
            write(1, cl, strlen(cl));
            strcpy(endstr, cl);
        }
        ds = tgoto(tgetstr("cs", &pt), tgetnum("li") - 1, 0);
        adjstr(ds);
        if (ds) {
            strcat(endstr, ds);
            strcat(endstr, ce);
        }
        ts = tgoto(tgetstr("cm", &pt), 0, tgetnum("li") - 1);
        adjstr(ts);
    }

    // ɥΥꤷľ (stty -a  Կ/ )
    struct winsize win;
    ioctl(0, TIOCGWINSZ, (char*) &win);
    if (!hs)
        win.ws_row--;
    ioctl(wfd, TIOCSWINSZ, (char*) &win);

    signal(SIGWINCH, (SIG_PF) winchange);
}
