#include "canna.H"

// ǥեȤΥ (Ѥ man ascii )
#define FEP_KEY 15
#define ESC_KEY 27

// 󥹥ȥ饯
Canna::Canna(int ac, char** av, char* amsg, char* emsg):
    Pty(ac, av, amsg, emsg)
{
    // ʤν
    jrKanjiControl(0, KC_INITIALIZE, 0);
    jrKanjiControl(0, KC_SETAPPNAME, "canfep");
    jrKanjiControl(0, KC_SETBUNSETSUKUGIRI, (char*) &ksv);
    jrKanjiControl(0, KC_QUERYMODE, (char*) saveMode);
    jrKanjiControl(0, KC_SETWIDTH, (char*) 72);

    mode(saveMode);
}

// ǥȥ饯
Canna::~Canna()
{
    // ʤνλ
    jrKanjiControl(0, KC_KILL, (char*) &ksv);
    jrKanjiControl(0, KC_FINALIZE, 0);

    mode(saveMode);
}

// ꤷʸϤ
void
Canna::kakutei(unsigned char* p)
{
    write(wfd, p, strlen((char*) p));
}

// Ѵ(̤)ʸϤ
void
Canna::henkan(unsigned char* p, int pos, int len)
{
    write(rfd, sc, strlen(sc));
    write(rfd, rc, strlen(rc));
    write(rfd, us, strlen(us));
    write(rfd, p, pos);
    write(rfd, ue, strlen(ue));
    write(rfd, so, strlen(so));
    write(rfd, p + pos, len);
    write(rfd, se, strlen(se));
    write(rfd, us, strlen(us));
    write(rfd, p + pos + len, strlen((char*) p + pos + len));
    write(rfd, ue, strlen(ue));
}

// ̤ʸ
void
Canna::delhenkan(int len)
{
    if (len != 0) {
        write(rfd, rc, strlen(rc));
        write(rfd, sc, strlen(sc));
        for (int i = 0; i < len; i++)
            write(rfd, " ", 1);
        write(rfd, rc, strlen(rc));
    }
    write(rfd, sc, strlen(sc));
}

// ߤΥ⡼ɤ򥹥ơ饤˽Ϥ
void
Canna::mode(unsigned char* p)
{
    write(rfd, sc, strlen(sc));
    write(rfd, ts, strlen(ts));
    write(rfd, ce, strlen(ce));
    write(rfd, p, strlen((char*) p));
    write(rfd, fs, strlen(fs));
}

// ɥ饤˰ɽ줿ν
void
Canna::gline(unsigned char* p, unsigned char* l, int pos, int len)
{
    write(rfd, sc, strlen(sc));
    write(rfd, ts, strlen(ts));
    write(rfd, ce, strlen(ce));
    write(rfd, p, strlen((char*) p));
    write(rfd, " ", 1);
    write(rfd, l, pos);
    write(rfd, so, strlen(so));
    write(rfd, l + pos, len);
    write(rfd, se, strlen(se));
    write(rfd, l + pos + len, strlen((char*) l + pos +len));
    write(rfd, fs, strlen(fs));
}

// ʤΥ롼
void
Canna::loop()
{
    unsigned char buff[BUFSIZ];
    buff[0] = '\0';

    // ǽϥե٥åϥ⡼ɤˤ
    ksv.ks = &ks;
    ksv.buffer = buff;
    ksv.bytes_buffer = BUFSIZ;
    ksv.val = CANNA_MODE_AlphaMode;
    jrKanjiControl(0, KC_CHANGEMODE, (char*) &ksv);

    // ߤΥ⡼ɤɽ
    jrKanjiControl(0, KC_QUERYMODE, (char*) currentMode);
    mode(currentMode);

    int c;
    int nbytes = 0;
    int length = 0;
    while (1) {

        // ʸȤ
        c = getchar();
        if (c == EOF)
            continue;

        //  C-o ϥ⡼ѹˤƤޤ (Vine  ~/.canna к)
        if (length == 0 && c == FEP_KEY) {
            if (strcmp((char*) saveMode, (char*) currentMode) == 0)
                ksv.val = CANNA_MODE_HenkanMode;
            else
                ksv.val = CANNA_MODE_AlphaMode;
            jrKanjiControl(0, KC_CHANGEMODE, (char*) &ksv);
            jrKanjiControl(0, KC_QUERYMODE, (char*) currentMode);
            mode(currentMode);
            continue;
        }

        // ESC 줿饢ե٥åϥ⡼ɤˤޤ (vi Ѥü)
        if (length == 0 && c == ESC_KEY) {
            ksv.val = CANNA_MODE_AlphaMode;
            jrKanjiControl(0, KC_CHANGEMODE, (char*) &ksv);
            jrKanjiControl(0, KC_QUERYMODE, (char*) currentMode);
            mode(currentMode);
            write(wfd, "\033", 1);
            continue;
        }

        // ̤ʸ
        delhenkan(length);

        // ʸϤѴ
        nbytes = jrKanjiString(0, c, (char*) buff, BUFSIZ, &ks);

        // ⡼ɤѲä
        if (ks.info & KanjiModeInfo) {
            jrKanjiControl(0, KC_QUERYMODE, (char*) currentMode);
            mode(currentMode);
        }

        // ɥ饤Ѳä
        if (ks.info & KanjiGLineInfo && ks.gline.length != 0) {
            gline(currentMode, ks.gline.line, ks.gline.revPos, ks.gline.revLen);
        }

        // Ѵꤷ
        if (nbytes > 0) {
            buff[nbytes] = '\0';
            kakutei(buff);
            buff[0] = '\0';
            length = 0;
        }

        // ̤ʸν
        if (ks.length > 0) {
            henkan(ks.echoStr, ks.revPos, ks.revLen);
            length = ks.length;
        }

        // ̤ξ֤ ESC 򲡤ꤷ
        if (ks.length < 0) {
            jrKanjiControl(0, KC_KILL, (char*) &ksv);
            buff[0] = '\0';
            length = 0;
        }
    }
}
