/*
 *  Emi Clock $B!=(B EmiClock Widget (Emi Clock $B@lMQ=hM}(B)
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $B#X%D!<%k%-%C%H%W%m%0%i%_%s%0$KI,MW$J%X%C%@!<(B */
#include <X11/IntrinsicP.h>		/* $B%$%s%H%j%s%7%C%/$NDj5A(B (private) */
#include <X11/StringDefs.h>		/* $BI8=`%j%=!<%9J8;zNs$NDj5A(B */

/* X11 Extensions */
#include <X11/extensions/shape.h>	/* X11 Shape Extension $B4X78(B */

/* $B#C8@8l%i%$%V%i%j(B */
#include <stdlib.h>			/* $BI8=`%i%$%V%i%j(B */
#include <sys/types.h>			/* $B7?$NDj5A(B */
#include <time.h>			/* $B;~4V4X78(B (1) */
#include <sys/time.h>			/* $B;~4V4X78(B (2) */
#include <math.h>			/* $B?t3X4X78(B */

/* Emi Clock $BFH<+$N%X%C%@!<(B */
#include "config.h"			/* $B%3%s%Q%$%k4D6-$NDj5A(B */
#include "include/system.h"		/* $B%7%9%F%`4D6-$N:9J,5[<}(B */
#include "include/const.h"		/* $BDj?tDj5A(B */
#include "include/types.h"		/* $BFC<l$J7?$NDj5A(B */
#include "include/public.h"		/* $BHFMQ4X?t!?30ItDj5A%G!<%?$N@k8@(B */
#include "include/util.h"		/* $B%^%/%mDj5A(B */

/* EmiClock Widget */
#include "EmiClockP.h"			/* EmiClock Widget $BDj5A(B (private) */

/* Shape Extension $B$N%^%9%/(B */
#include "graphics/misc/cbase_mask.xbm"

/* $BG-$N<j%+!<%=%k(B */
#ifndef	USE_SMALL_CURSOR
#include "graphics/misc/curs1.xbm"
#include "graphics/misc/curs1_mask.xbm"
#include "graphics/misc/curs2.xbm"
#include "graphics/misc/curs2_mask.xbm"
#else	/* USE_SMALL_CURSOR */
#include "graphics/misc/scurs1.xbm"
#include "graphics/misc/scurs1_m.xbm"
#include "graphics/misc/scurs2.xbm"
#include "graphics/misc/scurs2_m.xbm"
#endif	/* !USE_SMALL_CURSOR */

/* RCS ID */
rcsId(EmiClockId, "$Id: EmiClock.c,v 1.8 1999/09/26 16:18:18 koba Exp $")

/* $B%m!<%+%k4X?t$N%W%m%H%?%$%W@k8@(B */
static void Initialize __P((Widget, Widget, ArgList, Cardinal *));
static void CreateGC __P((EmiClockWidget));
static void GenCursor __P((EmiClockWidget));
static void EmiClockRandomInit __P((EmiClockWidget));
static void AllocAllColorCells __P((EmiClockWidget));
static void Realize __P((Widget, XtValueMask *, XSetWindowAttributes *));
static void DrawHand __P((EmiClockWidget, struct tm *));
static void TimerBasePixmapGen __P((EmiClockWidget, struct tm *));
static Boolean IsSqueeze __P((EmiClockWidget, struct tm *));
static Pixmap SqueezeCharPixmap __P((EmiClockWidget, Pixmap, struct tm *));
static void NewTime __P((EmiClockWidget));
static void NewInterval __P((EmiClockWidget));
static void TimerDraw __P((EmiClockWidget, struct tm *));
static void DressUp __P((EmiClockWidget));
static void Destroy __P((Widget));
static void Redisplay __P((Widget, XEvent *, Region));
static Boolean SetValues __P((Widget, Widget, Widget, ArgList, Cardinal *));
static XtGeometryResult QueryGeometry __P((Widget, XtWidgetGeometry *, XtWidgetGeometry *));
static void TimerButtonPress __P((EmiClockWidget, XButtonEvent *, String *, Cardinal *));
static void TimerButtonRelease __P((EmiClockWidget, XButtonEvent *, String *, Cardinal *));
static void RaiseTimer __P((EmiClockWidget, XButtonEvent *, String *, Cardinal *));
static void RepaintTimer __P((EmiClockWidget, XButtonEvent *, String *, Cardinal *));
static void GenPixmapAndDraw __P((EmiClockWidget));
static void UpdateTimer __P((EmiClockWidget));

/* $B%j%=!<%9%F!<%V%k(B */
static XtResource	resources[] = {
    {
	XtNhandBorder, XtCForeground, XtRPixel, sizeof(Pixel),
		XtOffset(EmiClockWidget, emiclock.handBorderPixel),
			XtRString, "black"
    },
    {
	XtNhandColor, XtCForeground, XtRPixel, sizeof(Pixel),
		XtOffset(EmiClockWidget, emiclock.handColorPixel),
			XtRString, "white"
    },
    {
	XtNsecondHand, XtCForeground, XtRPixel, sizeof(Pixel),
		XtOffset(EmiClockWidget, emiclock.secondHandPixel),
			XtRString, "red"
    },
    {
	XtNnoSecond, XtCNoSecond, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isNoSecond),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNhourlyCharacterChange, XtCHourlyCharacterChange,
		XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isHourlyCharChange),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNanimateCharacter, XtCAnimateCharacter,
		XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isAnimateCharacter),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNperfect, XtCPerfect, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isPerfect),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNnoShape, XtCNoShape, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isNoShape),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNhourlyChime, XtCHourlyChime, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isHourlyChime),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNhalfHourChime, XtCHalfHourChime, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isHalfHourChime),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNplayAlarm, XtCPlayAlarm, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isPlayAlarm),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNoneTime, XtCOneTime, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isOneTime),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNdailyAlarm, XtCDailyAlarm, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isDailyAlarm),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNmono, XtCMono, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isMono),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNgrayscale, XtCGrayscale, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isGrayscale),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNgray4, XtCGray4, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isGray4),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNtransparent, XtCTransparent, XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isTransparent),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNcbaseNo, XtCCbaseNo, XtRInt, sizeof(int),
		XtOffset(EmiClockWidget, emiclock.cbaseNo),
			XtRImmediate, (XtPointer)0
    },
    {
	XtNcharNo, XtCCharNo, XtRInt, sizeof(int),
		XtOffset(EmiClockWidget, emiclock.charNo),
			XtRImmediate, (XtPointer)0
    },
    {
	XtNreverseCharacter, XtCReverseCharacter,
		XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.isReverseCharacter),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNcanUpdateTimer, XtCCanUpdateTimer,
		XtRBoolean, sizeof(Boolean),
		XtOffset(EmiClockWidget, emiclock.canUpdateTimer),
			XtRImmediate, (XtPointer)TRUE
    },
    {
	XtNcostumesMenuClearCallback, XtCCostumesMenuClearCallback,
		XtRCallback, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.costumesMenuClearCallback),
			XtRCallback, NULL
    },
    {
	XtNcostumesMenuSetCallback, XtCCostumesMenuSetCallback,
		XtRCallback, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.costumesMenuSetCallback),
			XtRCallback, NULL
    },
    {
	XtNhourlyChimeCallback, XtCHourlyChimeCallback,
		XtRCallback, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.hourlyChimeCallback),
			XtRCallback, NULL
    },
    {
	XtNhalfHourChimeCallback, XtCHalfHourChimeCallback,
		XtRCallback, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.halfHourChimeCallback),
			XtRCallback, NULL
    },
    {
	XtNalarmCallback, XtCAlarmCallback,
		XtRCallback, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.alarmCallback),
			XtRCallback, NULL
    },
    {
	XtNalarmTime, XtCAlarmTime,
		XtRPointer, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.alarmTime),
			XtRCallback, NULL
    },
    {
	XtNtransparentCallback, XtCTransparentCallback,
		XtRCallback, sizeof(XtPointer),
		XtOffset(EmiClockWidget, emiclock.transparentCallback),
			XtRCallback, NULL
    },
};

/* $B%"%/%7%g%s%F!<%V%k(B */
static XtActionsRec	actionList[] = {
    { "timerButtonPress",	(XtActionProc)TimerButtonPress },
    { "timerButtonRelease",	(XtActionProc)TimerButtonRelease },
    { "raiseTimer",		(XtActionProc)RaiseTimer },
    { "repaintTimer",		(XtActionProc)RepaintTimer },
};

/* $B%H%i%s%9%l!<%7%g%s(B */
static char	defaultTranslations[] =
	"<BtnDown>:	timerButtonPress() raiseTimer() repaintTimer()\n\
	 <BtnUp>:	timerButtonRelease()";

/* $B%/%i%9%l%3!<%I(B */
EmiClockClassRec	emiClockClassRec = {
    /* Core Class */
    {
	&widgetClassRec,			/* superclass */
	"EmiClock",				/* class_name */
	sizeof(EmiClockRec),			/* size */
	NULL,					/* class_initialize */
	NULL,					/* class_part_initialize */
	FALSE,					/* class_inited */
	(XtInitProc)Initialize,			/* initialize */
	NULL,					/* initialize_hook */
	(XtRealizeProc)Realize,			/* realize */
	actionList,				/* actions */
	XtNumber(actionList),			/* num_actions */
	resources,				/* resources */
	XtNumber(resources),			/* num_resources */
	NULLQUARK,				/* xrm_class */
	TRUE,					/* compress_motion */
	TRUE,					/* compress_exposure */
	TRUE,					/* compress_enterleave */
	TRUE,					/* visible_interest */
	(XtWidgetProc)Destroy,			/* destroy */
	XtInheritResize,			/* resize */
	(XtExposeProc)Redisplay,		/* expose */
	(XtSetValuesFunc)SetValues,		/* set_values */
	NULL,					/* set_values_hook */
	XtInheritSetValuesAlmost,		/* set_values_almost */
	NULL,					/* get_values_hook */
	NULL,					/* accept_focus */
	XtVersion,				/* version */
	NULL,					/* callback_private */
	defaultTranslations,			/* tm_table */
	(XtGeometryHandler)QueryGeometry,	/* query_geometry */
	NULL,					/* display_accelerator */
	NULL,					/* extension */
    },
    /* EmiClock Class */
    {
	(int)NULL ,				/* dummy */
    },
};

WidgetClass	emiClockWidgetClass = (WidgetClass) &emiClockClassRec;


/*
 *  Widget Initialize $B%a%=%C%I(B
 */
static void
Initialize(request, new, args, num_args)
    Widget	request, new;
    ArgList	args;
    Cardinal	*num_args;
{
    EmiClockWidget	cw = (EmiClockWidget)new;
    int			eventBase, errorBase;

    /* $B%&%#%s%I%&$N%5%$%:$rD4@0(B */
    if (request->core.width == 0) {
	cw->core.width = CBASE_WIDTH;
    }
    if (request->core.height == 0) {
	cw->core.height = CBASE_HEIGHT;
    }

    /* Shape Extenshion $B$,%5%]!<%H$5$l$F$$$k$+$I$&$+$r3NG'(B */
    if (!XShapeQueryExtension(XtDisplay(cw), &eventBase, &errorBase)) {
	cw->emiclock.isNoShape = True;
    }

    /* Shape Extension $BMQ$N%S%C%H%^%C%W$r@8@.(B */
    cw->emiclock.shapeBitmap =
		XCreateBitmapFromData(XtDisplay(cw),
			RootWindowOfScreen(XtScreen(cw)),
			cbase_mask_bits, cbase_mask_width, cbase_mask_height);

    /* depth $B$rD4$Y$k(B */
    if (cw->core.depth <= 1) {
	cw->emiclock.isMono = True;	/* $B%b%N%/%mI=<(MQ$N2hA|$r;H$&(B */
    } else if (cw->core.depth <= 4) {
	cw->emiclock.isGray4 = True;	/* 4$B?'%0%l%$%9%1!<%kI=<($r9T$&(B */
    }

    /* $B%"%W%j%1!<%7%g%s$N%T%/%;%kCM$rJ]B8$9$kFbIt%G!<%?$r=i4|2=(B */
    cw->emiclock.pixelTable = AppPixelTableInit();

    /* GC $B$N@8@.(B */
    CreateGC(cw);

    /* $B%+!<%=%k$N@8@.(B */
    GenCursor(cw);

    /* EmiClock $BFbIt>pJs$N%i%s%@%`=i4|2=(B */
    EmiClockRandomInit(cw);

    /* $B$=$NB>$NJQ?t$r=i4|2=(B */
    cw->emiclock.intervalId = 0;
    cw->emiclock.isSqueezed = False;
    cw->emiclock.isTransparent = False;
    cw->emiclock.isReverseCharacter = False;
    cw->emiclock.canUpdateTimer = True;

    /* $B%+%i!<%;%k$N3NJ](B */
    if (cw->emiclock.isPerfect) {
	AllocAllColorCells(cw);
    }
}


/*
 *  $BI,MW$J(B GC $B$N@8@.(B
 */
static void
CreateGC(w)
    EmiClockWidget	w;
{
    XGCValues	gv;
    XtGCMask	mask;

    mask = (XtGCMask)NULL;

    w->emiclock.bgCopyGC =
	XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 0L, NULL);
    if (w->emiclock.isNoShape) {
	/* Shape $B%S%C%H%^%C%W$r%/%j%C%T%s%0%Q%?!<%s$K$9$k(B ($B6k7AI=<(MQ(B) */
	XSetClipMask(XtDisplay(w), w->emiclock.bgCopyGC,
						w->emiclock.shapeBitmap);
    }

    w->emiclock.charCopyGC =
	XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 0L, NULL);

    if (w->emiclock.isMono ||
		w->emiclock.isGrayscale || w->emiclock.isGray4) {
	gv.foreground = BlackPixel(XtDisplay(w), DefaultScreen(XtDisplay(w)));
    } else {
	gv.foreground = w->emiclock.secondHandPixel;
    }
    SetSpecialAppPixel(w->emiclock.pixelTable, gv.foreground);
    gv.line_width = 1;
    mask = GCForeground | GCLineWidth;
    w->emiclock.secondHandGC = XtGetGC((Widget)w, mask, &gv);

    if (w->emiclock.isMono ||
		w->emiclock.isGrayscale || w->emiclock.isGray4) {
	gv.foreground = BlackPixel(XtDisplay(w), DefaultScreen(XtDisplay(w)));
    } else {
	gv.foreground = w->emiclock.handBorderPixel;
    }
    SetSpecialAppPixel(w->emiclock.pixelTable, gv.foreground);
    gv.line_width = 3;
    gv.cap_style = CapRound;
    mask = GCForeground | GCLineWidth | GCCapStyle;
    w->emiclock.handBorderGC = XtGetGC((Widget)w, mask, &gv);

    if (w->emiclock.isMono ||
		w->emiclock.isGrayscale || w->emiclock.isGray4) {
	gv.foreground = WhitePixel(XtDisplay(w), DefaultScreen(XtDisplay(w)));
    } else {
	gv.foreground = w->emiclock.handColorPixel;
    }
    SetSpecialAppPixel(w->emiclock.pixelTable, gv.foreground);
    gv.line_width = 1;
    mask = GCForeground | GCLineWidth;
    w->emiclock.handColorGC = XtGetGC((Widget)w, mask, &gv);
}


/*
 *  $B%+!<%=%k$N@8@.(B
 */
static void
GenCursor(w)
    EmiClockWidget	w;
{
    XColor	blackColor, cursColor, exact;

    if (XAllocNamedColor(XtDisplay(w),
		DefaultColormap(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		"black", &blackColor, &exact) == 0) {
	FatalError("Can't XAllocNamedColor \"black\".");
    }
    SetSpecialAppPixel(w->emiclock.pixelTable, blackColor.pixel);

    if (w->emiclock.isMono ||
		w->emiclock.isGrayscale || w->emiclock.isGray4) {
	if (XAllocNamedColor(XtDisplay(w),
		DefaultColormap(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		"white", &cursColor, &exact) == 0) {
	    FatalError("Can't XAllocNamedColor \"white\".");
	}
    } else {
	if (XAllocNamedColor(XtDisplay(w),
		DefaultColormap(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		"AntiqueWhite", &cursColor, &exact) == 0) {
	    FatalError("Can't XAllocNamedColor \"AntiqueWhite\".");
	}
    }
    SetSpecialAppPixel(w->emiclock.pixelTable, cursColor.pixel);

    w->emiclock.neko1Curs = XCreatePixmapCursor(XtDisplay(w),
			XCreateBitmapFromData(XtDisplay(w),
				RootWindowOfScreen(XtScreen(w)),
				neko1_cursor_bits,
				neko1_cursor_width, neko1_cursor_height),
			XCreateBitmapFromData(XtDisplay(w),
				RootWindowOfScreen(XtScreen(w)),
				neko1_cursor_mask_bits,
				neko1_cursor_mask_width,
				neko1_cursor_mask_height),
			&blackColor, &cursColor,
			neko1_cursor_x_hot, neko1_cursor_y_hot);

    w->emiclock.neko2Curs = XCreatePixmapCursor(XtDisplay(w),
			XCreateBitmapFromData(XtDisplay(w),
				RootWindowOfScreen(XtScreen(w)),
				neko2_cursor_bits,
				neko2_cursor_width, neko2_cursor_height),
			XCreateBitmapFromData(XtDisplay(w),
				RootWindowOfScreen(XtScreen(w)),
				neko2_cursor_mask_bits,
				neko2_cursor_mask_width,
				neko2_cursor_mask_height),
			&blackColor, &cursColor,
			neko2_cursor_x_hot, neko2_cursor_y_hot);
}


/*
 *  EmiClock $BFbIt>pJs$N%i%s%@%`=i4|2=(B
 */
static void
EmiClockRandomInit(w)
    EmiClockWidget	w;
{
    long	now;
    struct tm	*tm;

    /* $B;~4V$r<h$j=P$9(B */
    now = time(NULL);
    tm = localtime(&now);

    /* $BJ8;zHWHV9f$N@_Dj(B */
    if (tm->tm_hour < 12) {
	w->emiclock.cbaseNo = 0;		/* AM */
    } else {
	w->emiclock.cbaseNo = 1;		/* PM */
    }

    /* 0 $B!A(B (NUM_OF_CHAR - 2) $B$NMp?t$r:n$C$F!"%-%c%i%/%?HV9f$K@_Dj(B */
    srandom(now);
    w->emiclock.charNo = (int)((double)random() * (double)(NUM_OF_CHAR - 2) /
							2147483647.0);
					/* (2**31)-1 == 2147483647 */
    if (w->emiclock.charNo > (NUM_OF_CHAR - 2)) {
	w->emiclock.charNo = 0;	/* $BG0$N$?$a(B :-) */
    }
}


/*
 *  $B3($rI=<($9$k$N$KI,MW$JA4$F$N%+%i!<%;%k$N3NJ](B
 */
static void
AllocAllColorCells(w)
    EmiClockWidget	w;
{
    int		i;

    for (i = 0; i < NUM_OF_CBASE; i++) {
	AllocPImageCollors((Widget)w,
		DefaultColormap(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		cbasePImageTable[i]);
    }

    for (i = 0; i < NUM_OF_CHAR; i++) {
	AllocPImageCollors((Widget)w,
		DefaultColormap(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		charPImageTable[i]);
    }
}


/*
 *  Widget Realize $B%a%=%C%I(B
 */
static void
Realize(w, valueMask, attrs)
    Widget			w;
    XtValueMask			*valueMask;
    XSetWindowAttributes	*attrs;
{
    EmiClockWidget	cw = (EmiClockWidget)w;
    long		now;
    struct tm		*tm;

    XtCreateWindow(w, (unsigned)InputOutput, (Visual *)CopyFromParent,
							*valueMask, attrs);

    /* $B%+!<%=%k$N@_Dj(B */
    XDefineCursor(XtDisplay(w), XtWindow(w), cw->emiclock.neko1Curs);

    /* $B3($rIA$/$?$a$N(B Pixmap $B@8@.(B */
    cw->emiclock.timerDrawPixmap =
		XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
			CBASE_WIDTH, CBASE_HEIGHT, cw->core.depth);
    cw->emiclock.cbaseAndCharPixmap =
		XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
			CBASE_WIDTH, CBASE_HEIGHT, cw->core.depth);

    /* $B2<3($N:n@.(B */
    TimerBasePixmapGen(cw, NULL);

    /* $B2<3($rIA2hMQ$N(B Pixmap $B$K%3%T!<(B */
    XCopyArea(XtDisplay(w), cw->emiclock.cbaseAndCharPixmap,
			cw->emiclock.timerDrawPixmap,
			cw->emiclock.bgCopyGC, 0, 0,
			CBASE_WIDTH, CBASE_HEIGHT, 0, 0);

    /* $B;~4V$r<h$j=P$9(B */
    now = time(NULL);
    tm = localtime(&now);

    /* $B?K$rIA$/(B */
    DrawHand(cw, tm);

    /* Pixmap $B$NFbMF$r%&%#%s%I%&$K%3%T!<(B */
    if (cw->emiclock.isNoShape) {
	XClearWindow(XtDisplay(w), XtWindow(w));
    }
    XCopyArea(XtDisplay(w), cw->emiclock.timerDrawPixmap,
			XtWindow(w), cw->emiclock.bgCopyGC, 0, 0,
			CBASE_WIDTH, CBASE_HEIGHT, 0, 0);

    /* Shape $B$N@_Dj(B */
    if (!(cw->emiclock.isNoShape)) {
	Widget	parent;
	int	x, y;

	/* $B:G>e0L$N(B Widget $B$r8!:w(B */
	for (x = 0, y = 0, parent = w; XtParent(parent);
				parent = XtParent(parent)) {
	    x += parent->core.x + parent->core.border_width;
	    y += parent->core.y + parent->core.border_width;
	}

	/* Shape Extension $BMQ$N%S%C%H%^%C%W$r%&%#%s%I%&$K@_Dj(B */
	XShapeCombineMask(XtDisplay(parent), XtWindow(parent),
				ShapeBounding, x, y,
				cw->emiclock.shapeBitmap, ShapeSet);
    }

    /* $B%$%s%?!<%P%k$N@_Dj(B */
    NewInterval(cw);
}


/*
 *  $B?K$NIA2h(B
 */
static void
DrawHand(w, tm)
    EmiClockWidget	w;
    struct tm		*tm;
{
    int		x0, y0, x1, y1;
    double	r, a;
    int		x2, y2;

    /* $B@~$r0z$/$?$a$NA0=hM}(B */
    x0 = CBASE_WIDTH / 2; y0 = CBASE_HEIGHT / 2;	/* $BCf?4$N:BI8(B */

    /* $BC;?K$rIA$/(B */
    r = TIMER_R * 0.65;
    a = -(2.0 * M_PI * (((double)(tm->tm_hour % 12) * 60.0 * 60.0 +
			 (double)(tm->tm_min) * 60.0 +
			 (double)(tm->tm_sec)) / (12.0 * 60.0 * 60.0))
			- M_PI_2);
    if (w->emiclock.cbaseNo != CBASE_REVERSE) {
	x1 = x0 + (int)(r * cos(a));
    } else {
	x1 = x0 - (int)(r * cos(a));
    }
    y1 = y0 - (int)(r * sin(a));
    XDrawLine(XtDisplay(w), w->emiclock.timerDrawPixmap,
				w->emiclock.handBorderGC, x0, y0, x1, y1);
    XDrawLine(XtDisplay(w), w->emiclock.timerDrawPixmap,
				w->emiclock.handColorGC, x0, y0, x1, y1);

    /* $BD9?K$rIA$/(B */
    r = TIMER_R * 0.80;
    a = -(2.0 * M_PI * (((double)(tm->tm_min) * 60.0 +
    			 (double)(tm->tm_sec)) / (60.0 * 60.0))
			- M_PI_2);
    if (w->emiclock.cbaseNo != CBASE_REVERSE) {
	x1 = x0 + (int)(r * cos(a));
    } else {
	x1 = x0 - (int)(r * cos(a));
    }
    y1 = y0 - (int)(r * sin(a));
    XDrawLine(XtDisplay(w), w->emiclock.timerDrawPixmap,
				w->emiclock.handBorderGC, x0, y0, x1, y1);
    XDrawLine(XtDisplay(w), w->emiclock.timerDrawPixmap,
				w->emiclock.handColorGC, x0, y0, x1, y1);

    /* $BIC?K$rIA$/(B */
    if (!(w->emiclock.isNoSecond)) {
	r = TIMER_R * 0.85;
	a = -(2.0 * M_PI * ((double)(tm->tm_sec) / 60.0) - M_PI_2);
	if (w->emiclock.cbaseNo != CBASE_REVERSE) {
	    x1 = x0 + (int)(r * cos(a));
	} else {
	    x1 = x0 - (int)(r * cos(a));
	}
	y1 = y0 - (int)(r * sin(a));
	r = TIMER_R * 0.25;
	if (w->emiclock.cbaseNo != CBASE_REVERSE) {
	    x2 = x0 - (int)(r * cos(a));
	} else {
	    x2 = x0 + (int)(r * cos(a));
	}
	y2 = y0 + (int)(r * sin(a));
	XDrawLine(XtDisplay(w), w->emiclock.timerDrawPixmap,
				w->emiclock.secondHandGC, x1, y1, x2, y2);
    }
}


/*
 *  $B2<3($N:n@.(B
 */
static void
TimerBasePixmapGen(w, tm)
    EmiClockWidget	w;
    struct tm		*tm;
{
    static int		isFirst = True;
    int			i;
    AllocPixel		prevCbasePixels[PIXELS_8], prevCharPixels[PIXELS_8];
    int			prevNumOfCbasePixels, prevNumOfCharPixels;
    XImage		*image;
    Pixmap		cbasePixmap;
    Pixmap		doubleCharPixmap, charPixmap;
    Window		root;
    int			x, y;
    unsigned int	width, height, border_width, depth;

    /*
     *  $B0JA0@8@.$7$?2<3($G;H$C$F$$$?%+%i!<%;%k$NB`Hr(B
     */
    if (!(w->emiclock.isMono) &&
		((w->core.depth <= 8) && !(w->emiclock.isPerfect))) {
	if (!isFirst) {
	    for (i = 0; i < w->emiclock.numOfCbasePixels; i++) {
		prevCbasePixels[i] = w->emiclock.cbasePixels[i];
	    }
	    prevNumOfCbasePixels = w->emiclock.numOfCbasePixels;

	    for (i = 0; i < w->emiclock.numOfCharPixels; i++) {
		prevCharPixels[i] = w->emiclock.charPixels[i];
	    }
	    prevNumOfCharPixels = w->emiclock.numOfCharPixels;
	}
    }

    if (!(w->emiclock.isMono)) {
	/*
	 *  CBASE $B$N(B Pixmap $B$r@8@.(B
	 */
	cbasePixmap = XCreatePixmap(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
			CBASE_WIDTH, CBASE_HEIGHT, w->core.depth);

	/* $B%$%a!<%8<hF@(B */
	image = PImage2XImage((Widget)w, DefaultColormap(XtDisplay(w),
						DefaultScreen(XtDisplay(w))),
				cbasePImageTable[w->emiclock.cbaseNo],
				w->emiclock.pixelTable,
				w->emiclock.cbasePixels,
				&(w->emiclock.numOfCbasePixels),
				w->emiclock.isGrayscale,
				w->emiclock.isGray4,
				w->emiclock.isPerfect);

	/* $B%$%a!<%8$NFbMF$r(B Pixmap $B$K@_Dj(B */
	XPutImage(XtDisplay(w), cbasePixmap, w->emiclock.bgCopyGC,
						image, 0, 0, 0, 0,
						CBASE_WIDTH, CBASE_HEIGHT);

	/* $BITMW$K$J$C$?%$%a!<%8$rGK4~(B */
	XtFree(image->data);
	XFree(image);
    } else {
	cbasePixmap = BitmapTable2Pixmap((Widget)w,
				&(cbaseBitmapTable[w->emiclock.cbaseNo]));
    }

    if (!(w->emiclock.isMono)) {
	/*
	 *  CHAR $B$N(B Pixmap $B$r@8@.(B
	 */
	doubleCharPixmap = XCreatePixmap(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
			CHAR_WIDTH * 2, CHAR_HEIGHT, w->core.depth);

	/* $B%$%a!<%8<hF@(B */
	image = PImage2XImage((Widget)w, DefaultColormap(XtDisplay(w),
						DefaultScreen(XtDisplay(w))),
				charPImageTable[w->emiclock.charNo],
				w->emiclock.pixelTable,
    				w->emiclock.charPixels,
    				&(w->emiclock.numOfCharPixels),
				w->emiclock.isGrayscale,
				w->emiclock.isGray4,
				w->emiclock.isPerfect);

	/* $B%$%a!<%8$NFbMF$r(B Pixmap $B$K@_Dj(B */
	XPutImage(XtDisplay(w), doubleCharPixmap, w->emiclock.charCopyGC,
						image, 0, 0, 0, 0,
						CHAR_WIDTH * 2, CHAR_HEIGHT);

	/* $BITMW$K$J$C$?%$%a!<%8$rGK4~(B */
	XtFree(image->data);
	XFree(image);
    } else {
	doubleCharPixmap = BitmapTable2Pixmap((Widget)w,
				&(charBitmapTable[w->emiclock.charNo]));
    }
    charPixmap = XCreatePixmap(XtDisplay(w),
			RootWindowOfScreen(XtScreen(w)),
			CHAR_WIDTH, CHAR_HEIGHT, w->core.depth);

    /*
     *  $B!H#1J,$4$H$KH?E>%"%K%a!I$K1~$8$?2hA|$rA*Br(B
     */
    if (tm != NULL) {
	if (w->emiclock.isAnimateCharacter && (tm->tm_sec == 0)) {
	    w->emiclock.isReverseCharacter =
		    w->emiclock.isReverseCharacter ? False : True;
	}
    }
    XCopyArea(XtDisplay(w), doubleCharPixmap, charPixmap,
		w->emiclock.bgCopyGC,
		w->emiclock.isReverseCharacter ? CHAR_WIDTH : 0, 0,
		CHAR_WIDTH, CHAR_HEIGHT, 0, 0);

    /*
     *  CHAR $B$N(B Pixmap $B$H(B CBASE $B$N(B Pixmap $B$r9g@.$7$?(B Pixmap $B$N:n@.(B
     */
    XCopyArea(XtDisplay(w), cbasePixmap, w->emiclock.cbaseAndCharPixmap,
				w->emiclock.bgCopyGC, 0, 0,
				CBASE_WIDTH, CBASE_HEIGHT, 0, 0);
    if (IsSqueeze(w, tm)) {
	Pixmap	newCharPixmap;

	/* $B%-%c%i%/%?$N3($r=L$a$k(B */
	newCharPixmap = SqueezeCharPixmap(w, charPixmap, tm);
	XFreePixmap(XtDisplay(w), charPixmap);
	charPixmap = newCharPixmap;
    }
    XGetGeometry(XtDisplay(w), charPixmap,
    			&root, &x, &y, &width, &height,
    			&border_width, &depth);
    XCopyArea(XtDisplay(w), charPixmap, w->emiclock.cbaseAndCharPixmap,
				w->emiclock.charCopyGC, 0, 0,
				width, height,
				(CBASE_WIDTH - width) / 2,
				(CBASE_HEIGHT - height) / 2);

    /* $BITMW$K$J$C$?(B Pixmap $B$rGK4~(B */
    XFreePixmap(XtDisplay(w), cbasePixmap);
    XFreePixmap(XtDisplay(w), doubleCharPixmap);
    XFreePixmap(XtDisplay(w), charPixmap);

    /*
     *  $B%+%i!<%;%k3+J|(B
     */
    if (!(w->emiclock.isMono) &&
		((w->core.depth <= 8) && !(w->emiclock.isPerfect))) {
	if (!isFirst) {
	    unsigned long	unNeedPixels[PIXELS_8];
	    int			numOfUnNeedPixels;

	    for (i = 0, numOfUnNeedPixels = 0; i < prevNumOfCbasePixels; i++) {
		if (prevCbasePixels[i].isAlloc) {
		    unNeedPixels[numOfUnNeedPixels++] =
						prevCbasePixels[i].pixel;
		}
	    }
	    XeFreeColors(XtDisplay(w), DefaultColormap(XtDisplay(w),
						DefaultScreen(XtDisplay(w))),
					w->emiclock.pixelTable,
					unNeedPixels, numOfUnNeedPixels, 0L);

	    for (i = 0, numOfUnNeedPixels = 0; i < prevNumOfCharPixels; i++) {
		if (prevCharPixels[i].isAlloc) {
		    unNeedPixels[numOfUnNeedPixels++] =
						prevCharPixels[i].pixel;
		}
	    }
	    XeFreeColors(XtDisplay(w), DefaultColormap(XtDisplay(w),
						DefaultScreen(XtDisplay(w))),
					w->emiclock.pixelTable,
					unNeedPixels, numOfUnNeedPixels, 0L);
	}
    }

    isFirst = False;
}


/*
 *  $B%-%c%i%/%?05=LH=Dj(B
 */
static Boolean
IsSqueeze(w, tm)
    EmiClockWidget	w;
    struct tm		*tm;
{
    if (w->emiclock.isAnimateCharacter) {
	if (tm != NULL) {
	    if ((tm->tm_sec >= 58) || (tm->tm_sec <= 1)) {
		return(True);
	    }
	}
    } else if (w->emiclock.isHourlyCharChange && !(w->emiclock.isNoSecond)) {
	if (tm != NULL) {
	    if (((tm->tm_min == 59) && (tm->tm_sec >= 58)) ||
			((tm->tm_min == 0) && (tm->tm_sec <= 1))) {
		return(True);
	    }
	}
    }

    return(False);
}


/*
 *  $B%-%c%i%/%?05=L(B
 */
static Pixmap
SqueezeCharPixmap(w, charPixmap, tm)
    EmiClockWidget	w;
    Pixmap		charPixmap;
    struct tm		*tm;
{
    double	rate;

    w->emiclock.isSqueezed = True;

    switch (tm->tm_sec) {
    case 58:
    case 1:
	rate = SQUEEZE_SIZE_1;
	break;
    case 59:
    case 0:
	rate = SQUEEZE_SIZE_2;
	break;
    default:
	rate = 1.0;
	break;
    }

    return(SqueezePixmapWidth((Widget)w, w->emiclock.charCopyGC,
							charPixmap, rate));
}


/*
 *  $B%$%s%?!<%P%k=hM}(B
 */
static void
NewTime(w)
    EmiClockWidget	w;
{
    long	now;
    struct tm	*tm;
    int		year;

    NewInterval(w);	/* $B%$%s%?!<%P%k$N@_Dj(B */

    /* $B;~4V$r<h$j=P$9(B */
    now = time(NULL);
    tm = localtime(&now);

    /* $B;~7W$N?K$rIA$/(B */
    TimerDraw(w, tm);

    /* 0$BJ,%A%c%$%`(B */
    if (w->emiclock.isHourlyChime) {
	if ((tm->tm_min == 0) && (tm->tm_sec == 0)) {
	    /* 0$BJ,%A%c%$%`$rLD$i$9(B */
	    XtCallCallbacks((Widget)w, XtNhourlyChimeCallback, NULL);
	}
    }

    /* 30$BJ,%A%c%$%`(B */
    if (w->emiclock.isHalfHourChime) {
	if ((tm->tm_min == 30) && (tm->tm_sec == 0)) {
	    /* 30$BJ,%A%c%$%`$rLD$i$9(B */
	    XtCallCallbacks((Widget)w, XtNhalfHourChimeCallback, NULL);

	    /* $B8+$($J$$%I%l%9$N=hM}(B */
	    if (((w->emiclock.alarmTime)->year == 1958) &&
		((w->emiclock.alarmTime)->month == 10) &&
		((w->emiclock.alarmTime)->date == 24) &&
		((w->emiclock.alarmTime)->hour == 6) &&
		((w->emiclock.alarmTime)->minute == 33)) {
		w->emiclock.isTransparent = True;
		XtCallCallbacks((Widget)w, XtNtransparentCallback, NULL);
	    }
	}
    }

    /* $B%"%i!<%`$N=hM}(B */
    if (w->emiclock.isDailyAlarm) {
	if (((w->emiclock.alarmTime)->hour == tm->tm_hour) &&
		((w->emiclock.alarmTime)->minute == tm->tm_min) &&
		(tm->tm_sec == 0)) {
	    XtCallCallbacks((Widget)w, XtNalarmCallback, NULL);
	}
    } else if (w->emiclock.isOneTime){
	year = tm->tm_year + 1900;
	if (((w->emiclock.alarmTime)->year == year) &&
		((w->emiclock.alarmTime)->month == (tm->tm_mon + 1)) &&
		((w->emiclock.alarmTime)->date == tm->tm_mday) &&
		((w->emiclock.alarmTime)->hour == tm->tm_hour) &&
		((w->emiclock.alarmTime)->minute == tm->tm_min) &&
		(tm->tm_sec == 0)) {
	    XtCallCallbacks((Widget)w, XtNalarmCallback, NULL);
	}
    }
}


/*
 *  $B%$%s%?!<%P%k$N@_Dj(B
 */
static void
NewInterval(w)
    EmiClockWidget	w;
{
#ifdef	HAVE_GETTIMEOFDAY
    struct timeval	tp;
#ifndef	solaris
    struct timezone	tzp;
#endif	/* !solaris */
#endif	/* HAVE_GETTIMEOFDAY */

    /* $BA02s$N%$%s%?!<%P%k$N<h>C(B */
    if (w->emiclock.intervalId != 0) {
	XtRemoveTimeOut(w->emiclock.intervalId);
	w->emiclock.intervalId = 0;
    }

    /* $B%$%s%?!<%P%k$N@_Dj(B */
#ifdef	HAVE_GETTIMEOFDAY
#if !(defined(solaris) || (defined(__sony_news) && defined(SVR4)))
    if (gettimeofday(&tp, &tzp) != 0) {
#else
    if (gettimeofday(&tp) != 0) {
#endif
	FatalError("Can't gettimeofday.");
    }

    if (!(w->emiclock.isNoSecond)) {
	w->emiclock.intervalId =
		XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)w),
			(unsigned long)(1000 - (tp.tv_usec / 1000)),
				/* 1000 milliseconds == 1 second */
			(XtTimerCallbackProc)NewTime, w);
    } else {
	struct tm	*tm;

	tm = localtime(&(tp.tv_sec));
	w->emiclock.intervalId =
		XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)w),
				(unsigned long)(60 * 1000 -
						(tm->tm_sec * 1000 +
						(tp.tv_usec / 1000))),
				(XtTimerCallbackProc)NewTime, w);
    }
#else	/* !HAVE_GETTIMEOFDAY */
    if (!(w->emiclock.isNoSecond)) {
	w->emiclock.intervalId =
		XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)w),
			(unsigned long)1000,
				/* 1000 milliseconds == 1 second */
			(XtTimerCallbackProc)NewTime, w);
    } else {
	long		now;
	struct tm	*tm;

	time(&now);
	tm = localtime(&now);
	w->emiclock.intervalId =
		XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)w),
				(unsigned long)((60 - tm->tm_sec) * 1000),
				(XtTimerCallbackProc)NewTime, w);
    }
#endif	/* HAVE_GETTIMEOFDAY */
}


/*
 *$B!!;~7WIA2h(B
 */
static void
TimerDraw(w, tm)
    EmiClockWidget	w;
    struct tm		*tm;
{
    /* $BCe$;BX$((B */
    if (w->emiclock.isHourlyCharChange &&
		((tm->tm_min == 0) && (tm->tm_sec == 0))) {
	/* $B%a%K%e!<$N%A%'%C%/9`L\$r>C$9(B */
	XtCallCallbacks((Widget)w, XtNcostumesMenuClearCallback,
					(XtPointer)(w->emiclock.charNo));

	DressUp(w);
	TimerBasePixmapGen(w, tm);	/* $B2<3($N:n$jD>$7(B */

 	/* $B%a%K%e!<$N%A%'%C%/9`L\$r@_Dj$9$k(B */
	XtCallCallbacks((Widget)w, XtNcostumesMenuSetCallback,
					(XtPointer)(w->emiclock.charNo));
    } else if (IsSqueeze(w, tm)) {
	TimerBasePixmapGen(w, tm);	/* $B2<3($N:n$jD>$7(B */
    } else if (w->emiclock.isSqueezed) {
	w->emiclock.isSqueezed = False;
	TimerBasePixmapGen(w, tm);	/* $B2<3($N:n$jD>$7(B */
    }

    /* $B2<3($r%3%T!<$9$k(B */
    XCopyArea(XtDisplay(w), w->emiclock.cbaseAndCharPixmap,
			w->emiclock.timerDrawPixmap,
			w->emiclock.bgCopyGC, 0, 0,
			CBASE_WIDTH, CBASE_HEIGHT, 0, 0);

    /* $B?K$rIA$/(B */
    DrawHand(w, tm);

    /* $B40@.$7$?3($rI=<($9$k(B */
    if (XtIsRealized((Widget)w) && w->core.visible) {
	XCopyArea(XtDisplay(w), w->emiclock.timerDrawPixmap, XtWindow(w),
					w->emiclock.bgCopyGC, 0, 0,
					CBASE_WIDTH, CBASE_HEIGHT, 0, 0);
    }
}


/*
 *  $BCe$;BX$((B
 */
static void
DressUp(w)
    EmiClockWidget	w;
{
    w->emiclock.charNo++;

    if (w->emiclock.isTransparent) {
	if (w->emiclock.charNo >= NUM_OF_CHAR) {
	    w->emiclock.charNo = 0;
	}
    } else {
	if (w->emiclock.charNo >= (NUM_OF_CHAR - 1)) {
	    w->emiclock.charNo = 0;
	}
    }
}


/*
 *  Widget Destroy $B%a%=%C%I(B
 */
static void
Destroy(w)
    Widget	w;
{
    EmiClockWidget	cw = (EmiClockWidget)w;

    XtFree((char *)(cw->emiclock.pixelTable));

    XFreeGC(XtDisplay(w), cw->emiclock.bgCopyGC);
    XFreeGC(XtDisplay(w), cw->emiclock.charCopyGC);
    XtReleaseGC(w, cw->emiclock.secondHandGC);
    XtReleaseGC(w, cw->emiclock.handBorderGC);
    XtReleaseGC(w, cw->emiclock.handColorGC);

    XFreeCursor(XtDisplay(w), cw->emiclock.neko1Curs);
    XFreeCursor(XtDisplay(w), cw->emiclock.neko2Curs);

    XFreePixmap(XtDisplay(w), cw->emiclock.shapeBitmap);
    XFreePixmap(XtDisplay(w), cw->emiclock.cbaseAndCharPixmap);
    XFreePixmap(XtDisplay(w), cw->emiclock.timerDrawPixmap);
}


/*
 *  Widget Redisplay $B%a%=%C%I(B
 */
static void
Redisplay(w, event, region)
    Widget	w;
    XEvent	*event;
    Region	region;
{
    EmiClockWidget	cw = (EmiClockWidget)w;

    if (cw->core.visible) {
	if (event->xexpose.count == 0) {
	    XCopyArea(XtDisplay(w),
			cw->emiclock.timerDrawPixmap, XtWindow(w),
				cw->emiclock.bgCopyGC, 0, 0,
					CBASE_WIDTH, CBASE_HEIGHT, 0, 0);
	}
    }
}


/*
 *  Widget SetValues $B%a%=%C%I(B
 */
static Boolean
SetValues(old, request, new, args, num_args)
    Widget	old, request, new;
    ArgList	args;
    Cardinal	*num_args;
{
    EmiClockWidget	cold = (EmiClockWidget)old;
    EmiClockWidget	cnew = (EmiClockWidget)new;
    Boolean		isUpdateTimer = False;

    /*
     *  $B<!$N%j%=!<%9$O!"CM$r%@%$%J%_%C%/$KJQ99$G$-$J$$!#(B
     *
     *    XtNperfect    ... emiclock.isPerfect
     *    XtNnoShape    ... emiclock.isNoShape
     *    XtNmono       ... emiclock.isMono
     *    XtNgrayscale  ... emiclock.isGrayscale
     *    XtNgray4      ... emiclock.isGray4
     */
    if (cnew->emiclock.isPerfect != cold->emiclock.isPerfect) {
	cnew->emiclock.isPerfect = cold->emiclock.isPerfect;
    }
    if (cnew->emiclock.isNoShape != cold->emiclock.isNoShape) {
	cnew->emiclock.isNoShape = cold->emiclock.isNoShape;
    }
    if (cnew->emiclock.isMono != cold->emiclock.isMono) {
	cnew->emiclock.isMono = cold->emiclock.isMono;
    }
    if (cnew->emiclock.isGrayscale != cold->emiclock.isGrayscale) {
	cnew->emiclock.isGrayscale = cold->emiclock.isGrayscale;
    }
    if (cnew->emiclock.isGray4 != cold->emiclock.isGray4) {
	cnew->emiclock.isGray4 = cold->emiclock.isGray4;
    }

    /* $BJ8;zHWHV9f$NL7=b$rD4$Y$k(B */
    if (cnew->emiclock.cbaseNo < 0) {
	cnew->emiclock.cbaseNo = 0;
    } else if (cnew->emiclock.cbaseNo >= NUM_OF_CBASE) {
	cnew->emiclock.cbaseNo = NUM_OF_CBASE - 1;
    }

    /* $B%-%c%i%/%?HV9f$NL7=b$rD4$Y$k(B */
    if (cnew->emiclock.charNo < 0) {
	cnew->emiclock.charNo = 0;
    } else {
	int	charNoMax;

	if (!(cnew->emiclock.isTransparent)) {
	    charNoMax = NUM_OF_CHAR - 2;
	} else {
	    charNoMax = NUM_OF_CHAR - 1;
	}

	if (cnew->emiclock.charNo > charNoMax) {
	    cnew->emiclock.charNo = charNoMax;
	}
    }

    /* $B%"%i!<%`DLCN$NL7=b$rD4$Y$k(B */
    if (cnew->emiclock.isOneTime && cnew->emiclock.isDailyAlarm) {
	cnew->emiclock.isDailyAlarm = False;
    }

    /* $B%T%/%;%kCM$NJQ2=$rD4$Y$k(B */
    if (!(cnew->emiclock.isMono ||
		cnew->emiclock.isGrayscale || cnew->emiclock.isGray4)) {
	XGCValues	gv;
	XtGCMask	mask;

	if (cnew->emiclock.secondHandPixel != cold->emiclock.secondHandPixel) {
	    gv.foreground = cnew->emiclock.secondHandPixel;
	    gv.line_width = 1;
	    mask = GCForeground | GCLineWidth;
	    XtReleaseGC(old, cold->emiclock.secondHandGC);
	    cnew->emiclock.secondHandGC = XtGetGC((Widget)cold, mask, &gv);
	    isUpdateTimer = True;
	}

	if (cnew->emiclock.handBorderPixel != cold->emiclock.handBorderPixel) {
	    gv.foreground = cnew->emiclock.handBorderPixel;
	    gv.line_width = 3;
	    gv.cap_style = CapRound;
	    mask = GCForeground | GCLineWidth | GCCapStyle;
	    XtReleaseGC(old, cold->emiclock.handBorderGC);
	    cnew->emiclock.handBorderGC = XtGetGC((Widget)cold, mask, &gv);
	    isUpdateTimer = True;
	}

	if (cnew->emiclock.handColorPixel != cold->emiclock.handColorPixel) {
	    gv.foreground = cnew->emiclock.handColorPixel;
	    gv.line_width = 1;
	    mask = GCForeground | GCLineWidth;
	    XtReleaseGC(old, cold->emiclock.handColorGC);
	    cnew->emiclock.handColorGC = XtGetGC((Widget)cold, mask, &gv);
	    isUpdateTimer = True;
	}
    }

    /* $B;~7W$NIA$-D>$7$NI,MW@-$rD4$Y$k(B */
    if ((cnew->emiclock.isNoSecond != cold->emiclock.isNoSecond) ||
		(cnew->emiclock.cbaseNo != cold->emiclock.cbaseNo) ||
		(cnew->emiclock.charNo != cold->emiclock.charNo) ||
		(cnew->emiclock.isReverseCharacter !=
					cold->emiclock.isReverseCharacter)) {
	isUpdateTimer = True;
    }

    if (cnew->emiclock.charNo != cold->emiclock.charNo) {
	/* $B%a%K%e!<$N%A%'%C%/9`L\$r>C$9(B */
	XtCallCallbacks((Widget)cold, XtNcostumesMenuClearCallback,
					(XtPointer)(cold->emiclock.charNo));

 	/* $B%a%K%e!<$N?7$7$$%A%'%C%/9`L\$r@_Dj$9$k(B */
	XtCallCallbacks((Widget)cnew, XtNcostumesMenuSetCallback,
					(XtPointer)(cnew->emiclock.charNo));
    }

    /* $B;~7W$NIA$-D>$7(B */
    if (cnew->emiclock.canUpdateTimer && isUpdateTimer) {
	UpdateTimer((EmiClockWidget)new);
    }

    return(FALSE);
}


/*
 *  Widget QueryGeometry $B%a%=%C%I(B
 */
static XtGeometryResult
QueryGeometry(w, proposed, answer)
    Widget		w;
    XtWidgetGeometry	*proposed, *answer;
{
    answer->request_mode = CWWidth | CWHeight;
    answer->width = CBASE_WIDTH;
    answer->height = CBASE_HEIGHT;

    if (((proposed->request_mode & (CWWidth | CWHeight)) ==
					(CWWidth | CWHeight)) &&
		(proposed->width == answer->width) &&
		(proposed->height == answer->height)) {
	return(XtGeometryYes);
    } else if ((answer->width == w->core.width) &&
    		(answer->height == w->core.height)) {
	return(XtGeometryNo);
    }

    return(XtGeometryAlmost);
}


/*
 *  $B%^%&%9%\%?%s$,2!$5$l$?;~$N=hM}(B
 */
static void
TimerButtonPress(w, event, params, numParams)
    EmiClockWidget	w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    /* $BG-$N<j%+!<%=%k$rJQ99$9$k(B */
    XDefineCursor(XtDisplay(w), XtWindow(w), w->emiclock.neko2Curs);
}


/*
 *  $B%^%&%9%\%?%s$,N%$5$l$?;~$N=hM}(B
 */
static void
TimerButtonRelease(w, event, params, numParams)
    EmiClockWidget	w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    /* $BG-$N<j%+!<%=%k$rJQ99$9$k(B */
    XDefineCursor(XtDisplay(w), XtWindow(w), w->emiclock.neko1Curs);
}


/*
 *  $B;~7W$N(B Raise
 */
static void
RaiseTimer(w, event, params, numParams)
    EmiClockWidget	w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    Widget	parent;

    /* $B:G>e0L$N(B Widget $B$r8!:w(B */
    for (parent = (Widget)w; XtParent(parent); parent = XtParent(parent));

    /* $B%&%#%s%I%&$r%H%C%W$K;}$C$F9T$/(B */
    XRaiseWindow(XtDisplay(parent), XtWindow(parent));
}


/*
 *  $B;~7W$N3($NIA$-D>$7(B
 */
static void
RepaintTimer(w, event, params, numParams)
    EmiClockWidget	w;
    XButtonEvent	*event;
    String		*params;
    Cardinal		*numParams;
{
    if (!(w->emiclock.isMono) &&
		((w->core.depth <= 8) && !(w->emiclock.isPerfect))) {
	/* $B8=:_$N%+%i!<%^%C%W$K$*$$$F:GE,$@$H;W$o$l$k?'$r;H$C$F:FIA2h(B */
	GenPixmapAndDraw(w);
    }
}


/*
 *  $B2<3($N:n@.$H;~7WIA2h(B
 */
static void
GenPixmapAndDraw(w)
    EmiClockWidget	w;
{
    long	now;
    struct tm	*tm;

    TimerBasePixmapGen(w, NULL);	/* $B2<3($N:n@.(B */

    /* $B;~4V$r<h$j=P$9(B */
    now = time(NULL);
    tm = localtime(&now);

    TimerDraw(w, tm);			/* $B;~7WIA2h(B */
}


/*
 *  $B4D6-$NJQ2=$KBP1~$7$?;~7W$NIA$-D>$7(B
 */
static void
UpdateTimer(w)
    EmiClockWidget	w;
{
    if (XtIsRealized((Widget)w)) {
	GenPixmapAndDraw(w);
    }

    NewInterval(w);
}


/*
 *  $B%T%/%;%kCM%F!<%V%k$N<h$j=P$7(B
 */
int *
GetPixelTable(w)
    Widget	w;
{
    EmiClockWidget	cw = (EmiClockWidget)w;

    return(cw->emiclock.pixelTable);
}


/*
 *  $BG-$N<j%+!<%=%k!J$=$N#1!K$N<h$j=P$7(B
 */
Cursor
GetNeko1Curs(w)
    Widget	w;
{
    EmiClockWidget	cw = (EmiClockWidget)w;

    return(cw->emiclock.neko1Curs);
}
