#!/bin/sh

# URI1=http://www2.wbs.ne.jp/~znc/tcsh/tcsh-6.13.00.tar.gz
# URI2=http://www2.wbs.ne.jp/~znc/tcsh/tcsh-6.13.00.add.tar.gz

VERSION=6.13.00
SRC1=tcsh-${VERSION}
SRC2=tcsh-${VERSION}.add

DOCDIR=/usr/share/doc
MANDIR=/usr/share/man

P=`pwd`/work

tar xzpf $SRC1.tar.gz
tar xzpf $SRC2.tar.gz
(cd $SRC2 ; ./merge.sh )

cd $SRC1

./configure --build=i386-pc-linux --prefix=/usr --bindir=/bin --mandir=${MANDIR}
make
cd nls
LANG=ja_JP.eucJP make catalogs SUBDIRS=ja
LANG=C make catalogs SUBDIRS=C
cd ..

rm -rf $P
mkdir -p ${P}/bin
touch ${P}/bin/tcsh
chmod 755 ${P}/bin/tcsh
mkdir -p ${P}/usr/share/locale/ja_JP.eucJP/LC_MESSAGES/
mkdir -p ${P}${DOCDIR}/tcsh-${VERSION}/tcsh-${VERSION}.additional
mkdir -p ${P}${MANDIR}/man1
mkdir -p ${P}${MANDIR}/man3

make install-strip DESTDIR=$P
rm -f ${P}/bin/tcsh.old
chmod 555 ${P}/bin/tcsh
make install.man DESTDIR=$P
install glob.3 ${P}${MANDIR}/man3/glob.3

gzip -f ${P}${MANDIR}/man*/*.*

cp -p tcsh.ja.multi.cat ${P}/usr/share/locale/ja_JP.eucJP/LC_MESSAGES/tcsh
chown root:root ${P}/usr/share/locale/ja_JP.eucJP/LC_MESSAGES/tcsh

cp -p tcsh.ja*.cat ${P}${DOCDIR}/tcsh-${VERSION}/tcsh-${VERSION}.additional/
for i in BUGS FAQ Fixes NewThings Ported README README.imake WishList Y2K ; do
cp -p $i ${P}${DOCDIR}/tcsh-${VERSION}/$i
gzip -f ${P}${DOCDIR}/tcsh-${VERSION}/$i
done
cp -p ../PlamoBuild.sh ${P}${DOCDIR}/tcsh-${VERSION}/.
cp -p ../$SRC2.tar.gz ${P}${DOCDIR}/tcsh-${VERSION}/.
chown -R root:root ${P}${DOCDIR}/tcsh-${VERSION}

cd $P
/sbin/makepkg tcsh-${VERSION}-i386-P1.tgz << EOF
y
EOF
