/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: sysfs.c,v 1.2 2003/08/10 04:23:56 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

#define	WAIT_PROC_FILE	4

int
get_sysfs_kind(struct mu_op *opp)
{
	char *path;
	unsigned int value;

	path = make_devpath(opp,"bNumConfigurations");
	if (SYSFS_VALUE10_WAIT(path,&value,WAIT_PROC_FILE) == GOOD)
		return MU_SYSFS_DEVICE;
	path = make_devpath(opp,"iInterface");
	if (SYSFS_VALUE16_WAIT(path,&value,WAIT_PROC_FILE) == GOOD)
		return MU_SYSFS_INTERFACE;
	return MU_SYSFS_INVALID;
}

int
get_sysfs_product(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	path = make_devpath(opp,"idVendor");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->product.vendor = value;
	DPRINTF(LOG_LEVEL,"idVendor 0x%x",value);

	path = make_devpath(opp,"idProduct");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->product.product = value;
	DPRINTF(LOG_LEVEL,"idProduct 0x%x",value);

	return GOOD;
}

int
get_sysfs_type(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	path = make_devpath(opp,"bDeviceClass");
	if (SYSFS_VALUE10(path,&value) == INVALID)
		return INVALID;
	config->device.class = value;
	DPRINTF(LOG_LEVEL,"bDeviceClass %d",value);

	path = make_devpath(opp,"bDeviceSubClass");
	if (SYSFS_VALUE10(path,&value) == INVALID)
		return INVALID;
	config->device.subclass = value;
	DPRINTF(LOG_LEVEL,"bDeviceSubClass %d",value);

	path = make_devpath(opp,"bDeviceProtocol");
	if (SYSFS_VALUE10(path,&value) == INVALID)
		return INVALID;
	config->device.protocol = value;
	DPRINTF(LOG_LEVEL,"bDeviceProtocol %d",value);

	return GOOD;
}

int
get_sysfs_interface(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	path = make_devpath(opp,"bInterfaceClass");
	if (SYSFS_VALUE10(path,&value) == INVALID)
		return INVALID;
	config->device.class = value;
	DPRINTF(LOG_LEVEL,"bInterfaceClass %d",value);

	path = make_devpath(opp,"bInterfaceSubClass");
	if (SYSFS_VALUE10(path,&value) == INVALID)
		return INVALID;
	config->device.subclass = value;
	DPRINTF(LOG_LEVEL,"bInterfaceSubClass %d",value);

	path = make_devpath(opp,"bInterfaceProtocol");
	if (SYSFS_VALUE10(path,&value) == INVALID)
		return INVALID;
	config->device.protocol = value;
	DPRINTF(LOG_LEVEL,"bInterfaceProtocol %d",value);

	return GOOD;
}
