/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: product.c,v 3.6 2003/05/17 21:06:01 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

#define		SEP	'/'

/*
 * format: x/x/x
 */

int
get_id_usb_product(struct mu_op *opp)
{
	char *ptr;
	char *sep;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	ptr = getenv("PRODUCT");
	if (ptr == NULL) {
		config->product.vendor = 0;
		config->product.product = 0;
		config->product.device_lo = 0;
		config->product.device_hi = 0;
		return INVALID;
	}
	
	config->product.vendor = strtoul(ptr,&sep,16);	/* vendor */
	DPRINTF(LOG_LEVEL,"vender 0x%x\n",config->product.vendor);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	config->product.product = strtoul(ptr,&sep,16);	/* product */
	DPRINTF(LOG_LEVEL,"product 0x%x\n",config->product.product);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	config->product.device_lo = strtoul(ptr,NULL,16);	/* device */
	DPRINTF(LOG_LEVEL,"device(_lo) 0x%x\n",config->product.device_lo);

	return GOOD;	
}
