/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 3.6 2003/05/17 21:06:24 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

static MU_usb_config_t config;

static int
get_info_usb(struct mu_op *opp)
{
	if (FLAG_CHECK(opp->flag,FLAG_SYSFS) && opp->devpath != NULL) {
		switch(get_sysfs_kind(opp)) {
		case MU_SYSFS_DEVICE:
			if (get_sysfs_product(opp) == INVALID)
				return INVALID;
			if (get_sysfs_type(opp) == INVALID)
				return INVALID;
			break;	/* verbose */
		case MU_SYSFS_INTERFACE:
			if (get_sysfs_interface(opp) == INVALID)
				return INVALID;
			break;	/* verbose */
		default:
			return INVALID;
		} 
	} else {
		if (get_id_usb_type(opp) == INVALID)
			return INVALID;
		if (get_id_usb_product(opp) == INVALID)
			return INVALID;
	}

	return GOOD;
}

struct mu_op mu_op = {
	flag: FLAG_NONE,
	device: usb,
	device_name: MU_ARG_USB,
	command: MU_MURASAKI "." MU_ARG_USB,
	mappath: MU_CONF_DIR "/" MU_USBMAP,
	default_mapname: MU_DEFAULT_USBMAP,
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_usb,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
