/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: sysfs.c,v 1.1 2003/05/17 20:56:15 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

int
sysfs_init(struct mu_op *opp)
{
	char *path;
	unsigned int dummy;	/* ignore wrong type */

	path = make_devpath(opp,"resource");
	if (SYSFS_VALUE16_WAIT(path,&dummy,3) == INVALID)
		return INVALID;

	return GOOD;
}

int
get_sysfs_class(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_pci_config_t *config;

	config = (MU_pci_config_t *)opp->config;

	path = make_devpath(opp,"class");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->class = value;	
	config->class_mask = 0;	/* not used */
	DPRINTF(LOG_LEVEL,"class 0x%x",config->class);

	return GOOD;
}

int
get_sysfs_vendor(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_pci_config_t *config;

	config = (MU_pci_config_t *)opp->config;

	/* vendor */
	path = make_devpath(opp,"vendor");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->id.vendor = value;	
	DPRINTF(LOG_LEVEL,"vendor 0x%x",config->id.vendor);

	/* subsystem_vendor */
	path = make_devpath(opp,"subsystem_vendor");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->sub_id.vendor = value;	
	DPRINTF(LOG_LEVEL,"sybsystem_vendor 0x%x",config->sub_id.vendor);

	return GOOD;
}

int
get_sysfs_device(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_pci_config_t *config;

	config = (MU_pci_config_t *)opp->config;

	/* device */
	path = make_devpath(opp,"device");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->id.device = value;	
	DPRINTF(LOG_LEVEL,"device 0x%x",config->id.device);

	/* subsystem_device */
	path = make_devpath(opp,"subsystem_device");
	if (SYSFS_VALUE16(path,&value) == INVALID)
		return INVALID;
	config->sub_id.device = value;	
	DPRINTF(LOG_LEVEL,"sybsystem_device 0x%x",config->sub_id.device);

	return GOOD;
}
