/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.4 2003/05/17 20:59:30 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

MU_pci_config_t config;

static int
get_info_pci(struct mu_op *opp)
{
	if (FLAG_CHECK(opp->flag,FLAG_SYSFS) && opp->devpath != NULL) {
		if (sysfs_init(opp) == INVALID)
			return INVALID;
		if (get_sysfs_class(opp) == INVALID)
			return INVALID;
		if (get_sysfs_vendor(opp) == INVALID)
			return INVALID;
		if (get_sysfs_device(opp) == INVALID)
			return INVALID;
	} else {
		if (get_id_pci_class(opp) == INVALID)
			return INVALID;
		if (get_id_pci_id(opp) == INVALID)
			return INVALID;
	}

	return GOOD;
}


struct mu_op mu_op = {
	flag: FLAG_NONE,
	device: pci,
	device_name: MU_ARG_PCI,
	command: MU_MURASAKI "." MU_ARG_PCI,
	mappath: MU_CONF_DIR "/" MU_PCIMAP,
	default_mapname: MU_DEFAULT_PCIMAP,
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_pci,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
