/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: init.c,v 1.11 2003/09/21 04:14:00 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<dirent.h>
#include	<fcntl.h>
#include	<string.h>
#include	<unistd.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<wait.h>
#define	__USE_XOPEN_EXTENDED 1
#include	<ftw.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

#define	PCI_PROC_DIR	"/proc/bus/pci"
#define	dprintf(arg...)	if(debug) printf(arg)
#define	IGNORE_CLASS		"0000"
#define	IGNORE_SUBSYS_ID	"0000:0000"

#define	SCRATCH_BUFSIZE		256

/* global */
int debug = 0;
char *sysfs = NULL;	/* SYSFS dir */

struct pci_init {
	char *	bus;
	char *	slot_fn;
	u_int16_t vendor;
	u_int16_t device;
};

static void
execute_hotplug(struct pci_init *pci)
{
	char buf[SCRATCH_BUFSIZE],*scratch;
	char *argv[3],*envp[16];
	int i;
	char *ptr;

	switch (fork()) {
	case -1:
		dprintf("fork error\n");
		exit(1);
	case 0:
		init_argument(argv,MU_ARG_PCI);

		i = 0;
		scratch = buf;
		if ((ptr = getenv("MURASAKI_BEEP")) != NULL) {
			envp[i++] = ptr-14;	/* uum */
		}
		envp[i++] = "HOME=/";
		envp[i++] = "PATH=/sbin:/bin:/usr/sbin:/usr/bin";
		envp[i++] = "ACTION=add";
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_CLASS=%s",IGNORE_CLASS);
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_ID=%04X:%04X",pci->vendor,pci->device);
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_SUBSYS_ID=%s",IGNORE_SUBSYS_ID);
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_SLOT_NAME=%s:%s",pci->bus,pci->slot_fn);
		envp[i] = 0;

		execve(argv[0], argv, envp);
		break;
	default:
		if (debug) {
			wait(NULL);
		}
		break;
	}

}

#ifdef	ONLY_CARDBUS
static int
check_cardbus(char *config)
{
	unsigned char pci_header;
	u_int32_t cardbus_cis;

	pci_header = config[PCI_HEADER_TYPE];
	cardbus_cis = config[PCI_CARDBUS_CIS] |
		config[PCI_CARDBUS_CIS+1] << 8 |
		config[PCI_CARDBUS_CIS+2] << 16 |
		config[PCI_CARDBUS_CIS+3] << 24;
	dprintf("pci_header=0x%02x cardbus_cis=0x%08x\n",
		pci_header,cardbus_cis);
	if (pci_header != PCI_HEADER_TYPE_NORMAL ||
		cardbus_cis == 0) {

		dprintf("Not CardBus device\n");
		return 0;
	}

	dprintf("This is a CardBus device\n");
	return 1;
}
#endif	/* ONLY_CARDBUS */

static int
scan_device(char *dirname,struct pci_init *pci)
{
	int fd,size;
	char path[PATH_MAX];
	unsigned char buf[PCI_PROC_BUF];

	strcpy(path,dirname);
	strcat(path,"/");
	strcat(path,pci->slot_fn);

	if ((fd = open(path,O_RDONLY)) == -1) {
		dprintf("open error %s\n",path);
		return -1;
	}
	size = read(fd,buf,PCI_PROC_BUF);
#ifdef	ONLY_CARDBUS
	if (!check_cardbus(buf))
		return 0;
#endif	/* ONLY_CARDBUS */
	pci->vendor = *(u_int16_t *)buf;
	pci->device = *((u_int16_t *)buf+1);
	dprintf("bus:%s slot_fn:%s vendor:%04x device:%04x\n",
			pci->bus,pci->slot_fn,pci->vendor,pci->device);
	if (debug == 0) {
		execute_hotplug(pci);
	}

	close(fd);

	return 0;
}

static int
scan_bus(char *dirname,struct pci_init *pci)
{
	char path[PATH_MAX];
	int n, i;
	struct dirent **names, **ent;

	strcpy(path,dirname);
	strcat(path,"/");
	strcat(path,pci->bus);
	if ((n = scandir(path, &names, NULL, alphasort)) < 0) {
		dprintf("scandir error %s\n",path);
		return -1;
	}
	for (i = 0, ent = names; i < n; i++, ent++) {
		if ((*ent)->d_name[0] == '.')
			continue;
		pci->slot_fn = (*ent)->d_name;
		if (scan_device(path,pci) != 0)
			break;
	}
	if (names != NULL)
		free(names);

	return 0;
}

/*
 * sysfs
 */

#ifdef	ONLY_CARDBUS
static int
check_cardbus_file(const char *path)
{
	int fd,ret;
	unsigned char buf[PCI_PROC_BUF];

	fd = open(path,O_RDONLY);
	if(fd == -1)
		return 0;
	if (read(fd,buf,PCI_PROC_BUF) == -1)
		return 0;
	ret = check_cardbus(buf);
	close(fd);

	return ret;
}
#endif	/* ONLY_CARDBUS */

static int
sysfs_sub(const char *path,const struct stat *st,int flag,struct FTW *s)
{
	char dname[PATH_MAX],*ptr;

	if (flag == FTW_F) {
		if (strcmp(path + s->base,"config") == 0
#ifdef	ONLY_CARDBUS
			&& check_cardbus_file(path)
#endif	/* ONLY_CARDBUS */
			) {
			strcpy(dname,path+strlen(sysfs));
			ptr = strrchr(dname,'/');
			*ptr = '\0';
			dprintf("devpath=%s\n",dname);
			if (debug == 0) {
				execute_hotplug_sysfs(dname,MU_ARG_PCI);
			}
		}
	}

	return 0;
}

int
main(int argc,char **argv)
{
	int n, i;
	struct dirent **names, **ent;
	char *dirname = PCI_PROC_DIR;
	struct pci_init pci;
	char sysfs_devices[PATH_MAX];

	if (check_config(MU_INIT_PCI) == ARG_OFF) {
		syslog(LOG_LEVEL,"%s is defined as \"%s\"",
		 	config_list[0],config_list[1]);
		exit(0);
	}

	if (getenv("MURASAKI_DEBUG"))
		debug = 1;

	sysfs = check_sysfs(NULL);
	if (sysfs != NULL) {
		strcpy(sysfs_devices,sysfs);
		strcat(sysfs_devices,"/devices");
		nftw(sysfs_devices,sysfs_sub,16,FTW_PHYS);
	} else {
		if ((n = scandir(dirname, &names, NULL, alphasort)) < 0) {
			dprintf("scandir error %s\n",dirname);
			exit(1);
		}
		for (i = 0, ent = names; i < n; i++, ent++) {
			if ((*ent)->d_name[0] == '.')
				continue;
			dprintf("dirname %s\n",(*ent)->d_name);
			if (isdigit((*ent)->d_name[0]) &&
				isdigit((*ent)->d_name[1])) {
				pci.bus = (*ent)->d_name;
				scan_bus(dirname,&pci);
			}
		}
		if (names != NULL)
			free(names);
	}

	return 0;
}
