/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: value.c,v 1.2 2003/08/10 04:06:34 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<stdlib.h>	/* strtoul */

#include	"murasaki.h"

#define	XVALUE_LEN	12	/* 32bits */

int
sysfs_value(char *fname,unsigned int *ret,int base,int max_sleep)
{
	int fd;
	char buf[XVALUE_LEN+1];
	ssize_t len;
	int sleep_count;

	for(sleep_count = 0;sleep_count < max_sleep;sleep_count++) {
		if (access(fname,R_OK) != -1)
			break;
		DPRINTF(LOG_LEVEL,"sysfs_value sleep %d",sleep_count);
		sleep(1);
	}

	if ((fd = open(fname,O_RDONLY)) == -1) {
		DPRINTF(LOG_LEVEL,"open error \"%s\"",fname);
		return INVALID;
	}
	if ((len = read(fd,buf,XVALUE_LEN)) <= 0) {
		DPRINTF(LOG_LEVEL,"read error \"%s\"",fname);
		return INVALID;
	}
	close(fd);
	buf[len] = '\0';
	*ret = strtoul(buf,NULL,base);
	DPRINTF(LOG_LEVEL,"%s=%d 0x%x",fname,*ret,*ret);

	return GOOD;
}
