/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: script.c,v 1.5 2003/09/25 05:25:33 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>	/* for exit(3) */
#include	<string.h>
#include	<unistd.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/wait.h>

#include	"murasaki.h"

#define	SCRIPT_MAX_ARG	3
#define	DEVICE_NAME_MAX	16	/* Now max length = 9 "ieee1394" */

char *alias_list[LIST_MAX];

/*
 * called by load_module() and exec_script()
 */
void
executing(struct mu_op *opp,char *path,char *argv[],int process)
{
	pid_t pid;

	DPRINTF(LOG_LEVEL,"exec %s %s %s",argv[0],argv[1],argv[2]);
	if (process == FORK_ON) {
		pid = fork();
		switch(pid) {
		case -1:
			syslog(LOG_LEVEL,"fork error err=%d",errno);
			break;
		case 0:	/* child */
			execvp(path,argv);
			beep(INVALID,opp->flag);
			syslog(LOG_LEVEL,"exec error \"%s\" err=%d",path,errno);
			break;
		default:	/* parent */
			wait(NULL);
			break;
		}
	} else {
		execvp(path,argv);
		beep(INVALID,opp->flag);
		syslog(LOG_LEVEL,"exec error \"%s\" err=%d",path,errno);
	}
}

/* 
 * called: exec_module_script,exec_device_script
 */
static void
exec_scriptlist(char **argv,struct mu_op *opp, int process)
{
	int i;
	char *cmd[SCRIPT_MAX_ARG];

	if (opp->action == ACTION_ADD)
		cmd[1] = "start";
	else 
		cmd[1] = "stop";
	cmd[2] = NULL;
	for(i=0;argv[i] != NULL;i++) {
		cmd[0] = argv[i];
		syslog(LOG_LEVEL,"Executing \"%s\" \"%s\"",cmd[0],cmd[1]);
		if (process == FORK_OFF && argv[i+1] == NULL) {
			executing(opp,cmd[0],cmd,FORK_OFF);
		} else {
			executing(opp,cmd[0],cmd,FORK_ON);
		}
	}
}

/*
 * called:exec_script
 */
static void
exec_module_script(struct mu_op *opp,int timing)
{
#ifdef	KERNEL_JOB
	int i;
#endif

	/* clear list */
	memset(script_list,0,sizeof(char *)*LIST_MAX);

	/*
	 * execute script files
	 */
	if (get_modulescript(script_list,module_list,timing) == INVALID) {
		DPRINTF(LOG_LEVEL,"get_modulescript return INVALID");
		exit(1);
	}
	if (get_modulescript(script_list,alias_list,timing) == INVALID) {
		DPRINTF(LOG_LEVEL,"get_modulescript return INVALID");
		exit(1);
	}
	if (count_of_list(script_list) != 0)
		exec_scriptlist(script_list,opp,FORK_ON);

#ifdef	KERNEL_JOB
	for(i = 0;module_list[i] != NULL;i++)
		free(module_list[i]);
	for(i = 0;script_list[i] != NULL;i++)
		free(script_list[i]);
#endif /* KERNEL_JOB */
}

/*
 * [xxx]: yyy
 * xxx = device
 * yyy = executable script(or binary)
 */
void
exec_device_script(struct mu_op *opp, int timing)
{
	char device_name[DEVICE_NAME_MAX+3];	/* 3: '['+']'+'\0' */
	char *list[2];
	unsigned int len;
	int fork_flag;

	if ((len = strlen(opp->device_name)) > DEVICE_NAME_MAX) {
		syslog(LOG_LEVEL,"Device name is too long \"%s\"",opp->device_name);
		exit(1);
	}
	device_name[0] = '[';
	strcpy(device_name+1,opp->device_name);
	device_name[1+len] = ']';
	device_name[1+len+1] = '\0';
	list[0] = device_name;
	list[1] = NULL;

	/* clear list */
	memset(device_list,0,sizeof(char *)*LIST_MAX);

	/* expand [device] into device_list[] */
	if (get_devicescript(device_list,list,timing) == INVALID) {
		/* error message is not need */
		exit(1);
	}
	/* if executable script exists , call exec_scriptlist() */
	if (count_of_list(device_list) != 0) {
		if (timing == PRECALL) 
			fork_flag = FORK_ON;
		else
			fork_flag = FORK_OFF;	/* never come back */
		exec_scriptlist(device_list,opp,fork_flag);
	}
}

/*
 * called ieee1394(opp->end), usb(opp->end), pci(end_pci)
 */
void
exec_script(struct mu_op *opp,int timing)
{
	exec_module_script(opp,timing);
	exec_device_script(opp,timing);
}
