/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: save_sysdir.c,v 1.1 2003/05/17 20:52:07 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<dirent.h>
#include	<sys/stat.h>
#include	<limits.h>
#include	<string.h>
#include	<errno.h>
#include	<fcntl.h>
#include	<unistd.h>

#include	"murasaki.h"

#define		DIR_MODE	0755
#define		FILE_MODE	0444
#define		COPY_BUF_SIZE	PATH_MAX+1

static void copy_dir(char *,char *);

static void
mkdir_sysfs(char *dpath)
{
	struct stat st;
	char *ptr = dpath,*eptr;

	if (*ptr == '/')
		ptr++;
	while((eptr = strchr(ptr,'/')) != NULL) {
		*eptr = '\0';
		if (stat(dpath,&st) == -1 && (errno == ENOENT))
			mkdir(dpath,DIR_MODE);
		*eptr = '/';	/* restore */
		ptr = eptr+1;
	}
	if (stat(dpath,&st) == -1 && (errno == ENOENT))
		mkdir(dpath,DIR_MODE);
}

/*
 * src, dest have enough length for full path
 */
static int
copy_file(char *src,char *dest,char *fname)
{
	int sfd,dfd;
	char buf[COPY_BUF_SIZE];
	size_t len;
	struct stat st;

	strcat(src,"/");
	strcat(src,fname);
	DPRINTF(LOG_LEVEL,"src name \"%s\"\n",src);

	strcat(dest,"/");
	strcat(dest,fname);
	DPRINTF(LOG_LEVEL,"dest name \"%s\"\n",dest);

	if (lstat(src,&st) == -1)
		return -1;
	if (S_ISLNK(st.st_mode)) {
		readlink(src,buf,COPY_BUF_SIZE);
		symlink(buf,dest);
	} else if (S_ISDIR(st.st_mode)) {
		mkdir(dest,st.st_mode);
		copy_dir(src,dest);	/* recursive */
	} else {
		if ((sfd = open(src,O_RDONLY)) == -1)
			return -1;
		if ((dfd = open(dest,O_RDWR|O_CREAT,FILE_MODE)) == -1)
			return -1;
		while((len = read(sfd,buf,COPY_BUF_SIZE)) != 0) {
			write(dfd,buf,len);
		}
		close(sfd);
		close(dfd);
	}

	return 0;
}

static void
copy_dir(char *src,char *dest)
{
	DIR *dir;
	struct dirent *dent;
	char *sptr,*dptr;	/* for faster */

	sptr = src + strlen(src);
	dptr = dest + strlen(dest);
	if ((dir = opendir(src)) == NULL)
		return;
	while((dent = readdir(dir)) != NULL) {
		DPRINTF(LOG_LEVEL,"fname \"%s\"\n",dent->d_name);
		if (dent->d_name[0] == '.')
			continue;
		copy_file(src,dest,dent->d_name);
		*sptr = '\0';
		*dptr = '\0';
	}
	closedir(dir);
}

void
save_sysfs(struct mu_op *opp,char *newdir)
{
	char src[PATH_MAX+1], dest[PATH_MAX+1];

	if (opp->action == ACTION_REMOVE)
		return;
	if (! FLAG_CHECK(opp->flag,FLAG_SYSFS))
		return;
	if (opp->devpath == NULL)
		return;

	strcpy(src,opp->sysfs);
	strcat(src,"/");
	strcat(src,opp->devpath);

	strcpy(dest,MU_CONF_DIR);
	strcat(dest,"/");
	strcat(dest,src+1);
	
	mkdir_sysfs(dest);
	copy_dir(src,dest);
}
