/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: proc.c,v 1.2 2003/08/10 04:14:24 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>

#define		TMP_BLOCK_SIZE	1024

char *
alloc_read(char *fname,int *total)
{
	char *buf,*ret = NULL;
	int fd,sum,sub;
	struct stat st;

	if ((fd = open(fname,O_RDONLY)) == -1)
		goto ret;
	if (fstat(fd,&st) == -1 || st.st_size == 0) {
		if ((buf = (char *)malloc(TMP_BLOCK_SIZE)) == NULL)
			goto ret_close;
		sum = 0;
		while((sub = read(fd,buf,TMP_BLOCK_SIZE)) > 0)
			sum += sub;
		if (sub == -1)
			goto ret_free;
		if (sum > TMP_BLOCK_SIZE) {
			free(buf);
			if ((buf = (char *)malloc(sum)) == NULL)
				goto ret_close;
		}
	} else {
		sum = st.st_size;
		if ((buf = (char *)malloc(sum)) == NULL)
			goto ret_close;
	}
	lseek(fd,0,SEEK_SET);
	read(fd,buf,sum); 
	*total = sum;
	ret = buf;
	goto ret_close;

ret_free:
	free(buf);
ret_close:
	close(fd);
ret:
	return ret;
}	

