/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: main.c,v 3.10 2003/07/12 07:15:28 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/utsname.h>
#include	<string.h>

#include	"murasaki.h"

int flag_debug = DEBUG_NONE;	/* debug flag */

static int
set_flag_and_log(struct mu_op *opp)
{
	char *ptr;
	struct utsname uts;

	if ((ptr = getenv("MURASAKI_DEBUG")) != NULL)
		flag_debug = atoi(ptr);
	if (flag_debug > DEBUG_TRACE)
		openlog(opp->command,LOG_PID|LOG_CONS,LOG_DAEMON);
	else
		openlog(opp->command,LOG_PID,LOG_DAEMON);
	/* check beep on/off */
	switch(check_config("beep")) {
	case INVALID:
	case ARG_ON:
		break;	/* it may a problem */
	case ARG_OFF:
		FLAG_OFF(opp->flag,FLAG_BEEP);
		break;
	}
	if (uname(&uts) == -1)
		return INVALID;
	if (uts.release[2] >= '5')
		FLAG_ON(opp->flag,FLAG_KERNEL25);
	opp->sysfs = check_sysfs(opp);
	set_devpath(opp);

	return GOOD;
}

/*
 * This is common main routine
 *
 * mu_op must be each object. Don't make common main.o.
 */
int
main(int argc,char **argv)
{
	struct mu_op *opp = &mu_op;

	/* kind of murasaki.generic */
	if (strcmp(opp->device_name,MU_ARG_GENERIC) == 0) {
		opp->device_name = argv[1];
	} else if (argc > 1) {
		syslog(LOG_LEVEL,"%s version %s",MU_MURASAKI,MU_VERSION);
		exit(0);
	}

	if (set_flag_and_log(opp) == INVALID)
		exit(1);

	DPRINTF(LOG_CONS,"PATH = \"%s\"",getenv("PATH"));
		
	if (get_action(opp) == INVALID) {
		syslog(LOG_LEVEL,"The action is invalid");
		exit(1);
	}
	if (opp->get_info && opp->get_info(opp) == INVALID) {
		syslog(LOG_LEVEL,"The get_info is invalid");
		exit(1);
	}

	/* build module list */
	if (opp->get_list && opp->get_list(opp) == INVALID)
		exit(1);
	/* pre-call */
	if (opp->prepare)
		opp->prepare(opp,PRECALL);
	/* load/unload */
	if (opp->run && opp->run(opp) == INVALID) {
		syslog(LOG_LEVEL,"fail to execute");
		exit(1);
	}
	save_sysfs(opp,MU_CONF_DIR);
	closelog();
	/* post-call */
	if (opp->end)
		opp->end(opp,POSTCALL);

	return 0;
}
