/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: filelist.c,v 1.3 2003/09/25 05:26:10 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/mman.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"

#define		CHAR_RSEP	'\n'


enum string_status {ST_START, ST_IN };

#define	NUM_ERROR -1

/*
 * "list" is allocated, so Don't forget free "list[0]".
 */
int
list_from_file(char *fname,char **list,int max)
{
	char *buf,*ptr;
	int count,sum;
	enum string_status status = ST_START;
#ifdef	DEBUG
	int i;
#endif

	if ((buf = alloc_read(fname,&sum)) == NULL || sum == 0) {
		list[0] = NULL;	/* end mark */
		return 0;
	}

	for (ptr = buf,count = 0;ptr < buf + sum;ptr++) {
		if (status == ST_START) {
			if (count == max) {
				syslog(LOG_LEVEL,"%s list is overflow(max %d).",
					fname,max);
				break;	/* report count of list */
			}
			list[count++] = ptr;
			status = ST_IN;
		} else {
			if (*ptr == CHAR_RSEP) {
				*ptr = '\0';
				status = ST_START;
			}
		}
	}
	list[count] = NULL;	/* end mark */
#ifdef	DEBUG
	for (i = 0;i < count;i++) {
		syslog(LOG_LEVEL,"buf[%d] \"%s\"",i,list[i]);
	}
#endif

	return count;
}
