/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: exec_sysfs.c,v 1.2 2003/09/21 04:19:35 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<sys/wait.h>

#include	"murasaki.h"

#define	SCRATCH_BUFSIZE	256
#define	dprintf(arg...)	if (debug) printf(arg)

extern int debug;

void
init_argument(char **argv,char *device)
{
	int i;
	static char *hotplug_path = NULL;

	if (hotplug_path == NULL && (hotplug_path = get_hotplug()) == NULL)
		hotplug_path = DEFAULT_HOTPLUG;

	i = 0;
	argv[i++] = hotplug_path;
	argv[i++] = device;
	argv[i] = 0;
}

void
execute_hotplug_sysfs(char *dname,char *device)
{
	int i;
	char *argv[3],*envp[8],*ptr;
	char buf[SCRATCH_BUFSIZE],*scratch;

	switch(fork()) {
	case -1:
		syslog(LOG_LEVEL,"fork error\n");
		exit(1);
	case 0:
		init_argument(argv,device);
		i = 0;
		scratch = buf;
		if ((ptr = getenv("MURASAKI_BEEP")) != NULL) {
			envp[i++] = ptr-14;	/* uum */
		}
		envp[i++] = "HOME=/";
		envp[i++] = "PATH=/sbin:/bin:/usr/sbin:/usr/bin";
		envp[i++] = "ACTION=add";
		envp[i++] = scratch;
		scratch += sprintf(scratch,"DEVPATH=%s",dname);
		envp[i] = 0;
		dprintf("execve [0]:%s [1]:%s\n",argv[0],argv[1]);
		execve(argv[0],argv,envp);
	default:
		if (debug) {
			wait(NULL);
		}
		break;
	}
}

