/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: depend.c,v 3.12 2003/09/25 05:22:32 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<string.h>
#include	<strings.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<sys/mman.h>

#include	"murasaki.h"

#define	CHAR_RSEP		'\n'
#define	CHAR_DEP		':'

#define DEPEND_PATH	MU_CONF_DIR "/" DEPEND_FILE
#define	CONFIG_PATH	MU_CONF_DIR "/" CONFIG_FILE
#define	CALL_PATH	MU_CONF_DIR "/" CALL_FILE
#define	PRECALL_PATH	MU_CONF_DIR "/" PRECALL_FILE

char *module_list[LIST_MAX];
char *script_list[LIST_MAX];
char *device_list[LIST_MAX];
char *config_list[LIST_MAX];

enum string_status {ST_START, ST_END };

/*
 * except_list: except list
 * ptr: point to next for ':'
 */
static char *
append_module_list(char **list,char **except_list,char *ptr,char *endp,int max_arg,int silent)
{
	char *module,*mod_start = NULL;/* for warning */
	int mod_len;
	enum string_status status = ST_END;

	for(;ptr <= endp;ptr++) {
		if (status == ST_END) {
			if (*ptr == ' ' || *ptr == '\t') /* skip */
				continue;
			if (*ptr == CHAR_RSEP)	/* invalid line end */
				return NULL;
			status = ST_START;
			mod_start = ptr;
		} else {	/* status == ST_START */
			if (*ptr != ' ' && *ptr != '\t' && *ptr != CHAR_RSEP)
				continue;
			mod_len = ptr - mod_start;
			module = malloc(mod_len+1);
			if (module == NULL)
				return NULL;
			memcpy(module,mod_start,mod_len);
			module[mod_len] = '\0';
			if (silent == MSG_ON)
				syslog(LOG_LEVEL,"Dependence(%s) was found",module);
			/* 
			 * 2nd pass for except list(blacklist and sticky)
			 */
			if (except_list != NULL && except_list[0] != NULL) {
				if (find_module_list(except_list,module) == NOT_FOUND) {
					if (add_to_list(list,module,max_arg) == INVALID)
						return NULL;
				} else {
					syslog(LOG_LEVEL,"%s was excepted",module);
					free(module);
				}
			} else {
				if (add_to_list(list,module,max_arg) == INVALID)
					return NULL;
			}
			if (*ptr == CHAR_RSEP)	/* all modules be appended */
				break;
			status = ST_END;	/* -> next modules */
		}
	}
	return ptr;
}

/* 
 * expand_list: destination list for 'list'
 * list: source list should be expanded
 * except_list: except list
 *
 * search list[0] to list[max_arg]
 * copy expanded list[#] to expand_list
 */

static int
get_helper(char *fname,
	char **expand_list,
	char **list,
	char **except_list,
	int max_arg,
	int silent)
{
	struct stat st;
	int fd,base_len;
	char *mp,*endp,*ptr;
	int index;

	/*
	 * If the file is not exist, do nothing
	 */
	if ((fd = open(fname,O_RDONLY)) == -1)
		return GOOD;
	if (fstat(fd,&st) == -1)
		return INVALID;
	if ((mp = mmap(0,st.st_size,PROT_READ,MAP_SHARED,fd,0)) == MAP_FAILED)
		return INVALID;
	close(fd);
	endp = mp+st.st_size;

#if 0	/* Think! flag_debug depends on main.c */
	if (flag_debug > DEBUG_NONE) {
		syslog(LOG_LEVEL,"walking through %s",fname);
	}
#endif
	/* try to match an argument for 'modprobe' */
	for(index = 0;list[index] != NULL;index++) {
#if 0	/* Think! flag_debug depends on main.c */
		if (flag_debug > DEBUG_NONE) {
			syslog(LOG_LEVEL,"trying to expand \"%s\"",list[index]);
		}
#endif
		base_len = strlen(list[index]);
		for(ptr = mp;ptr < endp;ptr++) {
			/* module is matched */
			if ((ptr[base_len] == CHAR_DEP) &&
				(ptr + base_len < endp) &&
				(memcmp(ptr,list[index],base_len) == 0)) {
				/* base_len + 1 -> point to next character for ':' */
				ptr = append_module_list(expand_list,except_list,ptr+base_len+1,endp,max_arg,silent);
				if (ptr == NULL) {
					syslog(LOG_LEVEL,"%s is invalid",fname);
					return INVALID;
				}
			} else {	/* skip an unmatched line */
				while(ptr < endp) {
					if (*ptr == CHAR_RSEP)
						break;
					ptr++;
				}
			}
		}
	}	/* list loop */

	munmap(mp,st.st_size);

	return GOOD;
}

/*
 * already created [0]:loader [1]:loader option [2]:module
 * now creat [3]:dep-mod ...
 */
int
get_depend(char **list,char **blacklist)
{
	return get_helper(DEPEND_PATH,list,list,blacklist,LIST_MAX,MSG_ON);
}

/*
 * create [0]:...    script-file
 */
int
get_modulescript(char **expand_list,char **list,int timing)
{
	char  *fname;

	if (timing == PRECALL)
		fname = PRECALL_PATH;
	else
		fname = CALL_PATH;

	return get_helper(fname,expand_list,list,NULL,LIST_MAX,MSG_ON);
}

/*
 * create [0]:... 
 */
int
get_devicescript(char **expand_list,char **list,int timing)
{
	char  *fname;

	if (timing == PRECALL)
		fname = PRECALL_PATH;
	else
		fname = CALL_PATH;

	return get_helper(fname,expand_list,list,NULL,LIST_MAX,MSG_ON);
}

/*
 * create [0]:...   configuration 
 */
static int
get_config(char **expand_list , char **list)
{
	return get_helper(CONFIG_PATH,expand_list,list,NULL,LIST_MAX,MSG_OFF);
}

/*
 * check if the argument is on/off
 * default: on
 */
int
check_config(char *arg)
{
	config_list[0] = arg;
	config_list[1] = NULL;
	if (get_config(config_list,config_list) == INVALID) {
		syslog(LOG_LEVEL,"%s cound Not be opened", config_list[0]);
		return ARG_ON;
	}
	if (config_list[1] && strcasecmp(config_list[1],"off") == 0) {
		syslog(LOG_LEVEL,"%s is defined as \"%s\"",
			config_list[0],config_list[1]);
		return ARG_OFF;
	}
	return ARG_ON;
}
