/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: action.c,v 3.7 2003/07/12 07:15:09 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"

int
get_action(struct mu_op *opp)
{
	char *ptr;

	ptr = getenv("ACTION");
	if (ptr == NULL)
		return INVALID;

	/* common action pattern in 2.4 and 2.5 */
	if (strcmp(ptr,"add") == 0 || strcmp(ptr,"register") == 0) {
		opp->action = ACTION_ADD;
		syslog(LOG_LEVEL,"%s device is %sed",opp->device_name,ptr);
		return GOOD;
	} else if (strcmp(ptr,"remove") == 0 || strcmp(ptr,"unregister") == 0) {
		opp->action = ACTION_REMOVE;
		syslog(LOG_LEVEL,"%s device is %sd",opp->device_name,ptr);
		return GOOD;
	}
	return INVALID;
}

