/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki_pci.h,v 1.4 2003/08/13 05:51:39 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_PCI_H
#define	_MURASASKI_PCI_H

#define	PCI_PROC_BUF	256

#include	<linux/types.h>
typedef unsigned long kernel_ulong_t;
#include	<linux/pci.h>

/* PCI configuration */
typedef struct {
	unsigned int vendor;
	unsigned int device;
} MU_pci_id_t;

typedef struct {
	char *name;
	unsigned int class;
	unsigned int class_mask;
	MU_pci_id_t id;
	MU_pci_id_t sub_id;
	char *slot;
} MU_pci_config_t;

extern int get_id_pci_class(struct mu_op *);
extern int get_id_pci_id(struct mu_op *);
extern int get_id_pci_slot(struct mu_op *);
/* sysfs */
extern int get_sysfs_class(struct mu_op *);
extern int get_sysfs_vendor(struct mu_op *);
extern int get_sysfs_device(struct mu_op *);
extern int sysfs_init(struct mu_op *);

#endif	/* _MURASAKI_PCI_H */
