/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki.h,v 3.19 2003/09/19 13:57:49 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_H
#define	_MURASAKI_H

#include	<syslog.h>
#include	"datatype.h"
#include	"env.h"

#define	LOG_LEVEL	LOG_INFO

#ifdef	DEBUG
#define	DPRINTF( args... )	syslog(args)
#define	DPRINT_LIST(list)	print_list(list)
#else
#define	DPRINTF( args... )
#define	DPRINT_LIST(list)
#endif

/* name about file */
#define	MU_MURASAKI	"murasaki"
#define	MU_ARG_USB		"usb"
#define	MU_ARG_PCI		"pci"
#define	MU_ARG_IEEE1394		"ieee1394"

#define MU_ARG_GENERIC		"generic"
#ifdef	INCLUDE_GENERIC_LIST
#define	MU_ARG_NET		"net"	/* -> "generic" */
#define MU_ARG_SCSI		"scsi"	/* -> "generic" */
#define	MU_ARG_SCSI_HOST	"scsi_host"
#define	MU_ARG_SCSI_DEVICE	"scsi_device"
#define	MU_ARG_BLOCK		"block"
#define	MU_ARG_USB_HOST		"usb_host"
#endif	/* INCLUDE_GENERIC_LIST */

#define	MU_INIT_USB		"init.usb"
#define	MU_INIT_PCI		"init.pci"
#define	MU_INIT_IEEE1394	"init.ieee1394"

/* path about /proc */
#define	MODPROBE_FILE	"/proc/sys/kernel/modprobe"
#define	HOTPLUG_FILE	"/proc/sys/kernel/hotplug"
#define DEFAULT_HOTPLUG	"/sbin/hotplug"
#define	get_loader()	get_path(MODPROBE_FILE)
#define get_hotplug()	get_path(HOTPLUG_FILE)

/* flag */
#define	FLAG_ON(flag,value)	(flag) |= (value)
#define	FLAG_OFF(flag,value)	(flag) &= ~(value)
#define	FLAG_CHECK(flag,value)	((flag) & (value))
#define	FLAG_NONE	0
#define	FLAG_KERNEL25	1
#define	FLAG_BEEP	(1<<1)
#define	FLAG_SYSFS	(1<<2)

/* about SYSFS */
#define	SYSFS_VALUE10(path,ptr)	sysfs_value((path),(ptr),10,0)
#define	SYSFS_VALUE16(path,ptr)	sysfs_value((path),(ptr),16,0)
#define	SYSFS_VALUE10_WAIT(path,ptr,wait) sysfs_value((path),(ptr),10,wait)
#define	SYSFS_VALUE16_WAIT(path,ptr,wait) sysfs_value((path),(ptr),16,wait)

#define	LIST_MAX		16
/* prefix for alias */
#define	ALIAS_STR		"alias-"

/* common */
extern struct mu_op mu_op;
extern int flag_debug;
extern char *module_list[];
extern char *script_list[];
extern char *device_list[];
extern char *config_list[];
extern char *alias_list[];

extern int match_config(char **,char **,char *,char *,void *);
extern void print_config(void *);
extern void inform_config(void *);
/* action.c */
extern int get_action(struct mu_op *);
/* beep.c */
extern void beep(int,int);
/* depend.c */
extern int get_depend(char **,char **);
extern int get_modulescript(char **,char **,int );
extern int get_devicescript(char **,char **,int );
extern int check_config(char *);
/* list.c */
extern int find_module_list(char **,char *);
extern int add_to_list(char **,char *,int);
extern int count_of_list(char **);
extern void remove_from_list(char **,int);
#ifdef	DEBUG
extern void print_list(char **);
#endif
/* loader.c */
extern void executing(struct mu_op *,char *,char **argv,int );
extern int load_module(struct mu_op *);
extern int create_modulelist(struct mu_op *);
/* script.c */
extern void exec_device_script(struct mu_op *,int );
extern void exec_script(struct mu_op *,int );
/* path.c */
extern char * get_path(char *);
/* filelist.c */
extern int list_from_file(char *,char **,int );
/* sysfs.c */
extern char *check_sysfs(struct mu_op *);
extern void set_devpath(struct mu_op *);
extern char *make_devpath(struct mu_op *,char *);
/* value.c */
extern int sysfs_value(char *,unsigned int *,int,int);
/* save_sysdir.c */
extern void save_sysfs(struct mu_op *,char *);
/* proc.c */
extern char *alloc_read(char *,int *);
/* exec_sysfs.c */
extern void execute_hotplug_sysfs(char *,char *);
extern void init_argument(char **,char *);

#endif	/* _MURASAKI_H */

