/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: datatype.h,v 3.10 2003/08/10 04:03:14 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_DATATYPE_H
#define	_MURASASKI_DATATYPE_H

enum hotplug_device {
	generic,
	usb,
	pci,
	ieee1394,
	scsi
};

struct mu_op {
	int flag;
	enum hotplug_device device;
	char *device_name;
	char *command;
	char *mappath;
	char *default_mapname;
	int  action;
	void *config;
	char *sysfs;
	char *devpath;

	int (*get_info)(struct mu_op *);
	int (*get_list)(struct mu_op *);
	int (*match_map)(char **,char **,char *,char *,void *);
	int (*run)(struct mu_op *);
	void (*prepare)(struct mu_op *,int);
	void (*end)(struct mu_op *,int);
};

#endif	/* _MURASASKI_DATATYPE_H */

