/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.5 2003/05/17 20:37:33 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_ieee1394.h"

MU_ieee1394_config_t config;

static int
get_info_ieee1394(struct mu_op *opp)
{
	if (get_id_ieee1394(opp) == INVALID)	/* always GOOD */
		return INVALID;

	return GOOD;
}

struct mu_op mu_op = {
	flag: FLAG_NONE,
	device: ieee1394,
	device_name: MU_ARG_IEEE1394,
	command: MU_MURASAKI "." MU_ARG_IEEE1394,
	mappath: MU_CONF_DIR "/" MU_IEEE1394MAP,
	default_mapname: MU_DEFAULT_IEEE1394MAP,
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_ieee1394,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
