/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: match.c,v 1.7 2003/08/10 03:59:39 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"
#include	"murasaki_ieee1394.h"

#define	CHAR_COMMENT	'#'
#define	CHAR_RSEP		'\n'

#define	ST_COMMENT		255
#define	ST_SKIP			(ST_COMMENT-1)
#define	ST_MODULE		1
#define	ST_MATCH_FLAGS	(ST_MODULE + 1)
#define	ST_VENDOR		(ST_MATCH_FLAGS + 1)
#define	ST_MODEL		(ST_VENDOR + 1)
#define	ST_SPECIFIER	(ST_MODEL + 1)
#define	ST_VERSION		(ST_SPECIFIER + 1)

static int
real_match(MU_ieee1394_config_t *active,MU_ieee1394_config_t *map)
{
	if (active->vendor == 0 &&
		active->model == 0 &&		/* model is not available */
		active->specifier == 0 &&
		active->version == 0)
		return INVALID;
	if (map->match_flags == 0)
		return INVALID;

	if ((map->match_flags & IEEE1394_MATCH_VENDOR_ID) &&
		(active->vendor != map->vendor))
		return INVALID;
	if ((map->match_flags & IEEE1394_MATCH_MODEL_ID) &&
		(active->model != map->model))
		return INVALID;
	if ((map->match_flags & IEEE1394_MATCH_SPECIFIER_ID) &&
		(active->specifier != map->specifier))
		return INVALID;
	if ((map->match_flags & IEEE1394_MATCH_VERSION) &&
		(active->version != map->version))
		return INVALID;

	return GOOD;
}

int
match_config(char **list,char **except_list,char *start,char *end,void *conf)
{
	MU_ieee1394_config_t *config = conf;
	MU_ieee1394_config_t map;
	char *ptr,*module,*module_start,*module_end = NULL;
	int status = ST_MODULE;
	unsigned int module_len = 0,value,i;
	char *fwdp;
	int mod_count = 0;

	DPRINTF(LOG_LEVEL,"vendor:0x%x specifier:0x%x version:0x%x",
		config->vendor,
		config->specifier,
		config->version);
	for(module_start = ptr = start; ptr < end;ptr++) {
		if (status == ST_COMMENT) {
			while(*ptr != CHAR_RSEP) {
				if(ptr >= end)
					goto error_return;
				ptr++;
			}
			status = ST_MODULE;
			continue;
		} else if (*ptr == CHAR_COMMENT) {
			status = ST_COMMENT;
			continue;
		}
		if (status == ST_MODULE) {
			module_start = ptr;
			while(*ptr != ' ' && *ptr != '\t') {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			module_end = ptr;
			module_len = module_end - module_start;
			/*
			 * check excepted modules
			 */
			for (i = 0;except_list[i] != NULL;i++) {
				if (memcmp(except_list[i],module_start,module_len) == 0 && except_list[i][module_len] == '\0') {
					break;
				}
			}
			if (except_list[i] != NULL) {
				status = ST_COMMENT;
				syslog(LOG_LEVEL,"%s was skipped in ieee1394map",except_list[i]);
				continue;
			}
		} else {
			value = (unsigned int)strtoul(ptr,&fwdp,0);
			ptr = fwdp;
			switch(status) {
			case ST_MATCH_FLAGS:
				map.match_flags = value;
				break;
			case ST_VENDOR:
				map.vendor = value;
				break;
/*
	If ST_GUID is turned ON, Be carefull order of it.
	'status' increment step by step.
			case ST_GUID:
				map.guid = value;
				break;
*/
			case ST_MODEL:
				map.model = value;
				break;
			case ST_SPECIFIER:
				map.specifier = value;
				break;
			case ST_VERSION:
				map.version = value;
				if (config->match_flags &
					(config->match_flags == map.match_flags))
					continue;
				if (real_match(config,&map) == GOOD) {
					/* for exclusive */
					config->match_flags = map.match_flags;

					module = malloc(module_len+1);
					if (module == NULL)
						goto error_return;
					memcpy(module,module_start,module_len);
					module[module_len] = '\0';

					syslog(LOG_LEVEL, "MATCH(%s) -> match_flag:0x%x vendor:0x%x model:0x%x specifier:0x%x version:0x%x",
						module,
						map.match_flags,
						map.vendor,
						map.model,
						map.specifier,
						map.version);
					if (add_to_list(list,module,LIST_MAX) == INVALID)
						goto error_return;
					mod_count++;
				}
				continue;
			default:
				goto error_return;
			}
		}
		status++;
	}
	return mod_count;

error_return:
	return INVALID;
}
