/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: hotplug.c,v 3.19 2003/09/14 05:49:37 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<syslog.h>
#include	<unistd.h>

#include	"murasaki.h"

#define	EXEC_PATH		MU_SCRIPT_DIR ":" MU_CONF_DIR ":" MU_BIN_DIR ":"
#define	HOTPLUG_MAX_ARGS	3

#ifdef	DEBUG
#define	DPRINTF( args... )		syslog(args)
#define	DPRINT_ARGS(name,arg)	print_args((name),(arg))
#else
#define	DPRINTF( args... )
#define	DPRINT_ARGS(name,arg)
#endif

#define	AGENT_CMD(name)		{name, MU_MURASAKI "." name}
#ifdef	INCLUDE_GENERIC_LIST
#define	AGENT_GENERIC(name)	{name, MU_MURASAKI "." MU_ARG_GENERIC}
#endif	/* INCLUDE_GENERIC_LIST */

struct arg_command {
	char *arg;
	char *cmd;
};

struct arg_command cmd_table[] = {
	AGENT_CMD(MU_ARG_USB),
	AGENT_CMD(MU_ARG_PCI),
	AGENT_CMD(MU_ARG_IEEE1394),
#ifdef	INCLUDE_GENERIC_LIST
	AGENT_GENERIC(MU_ARG_NET),
	AGENT_GENERIC(MU_ARG_SCSI),
	AGENT_GENERIC(MU_ARG_SCSI_HOST),
	AGENT_GENERIC(MU_ARG_SCSI_DEVICE),
	AGENT_GENERIC(MU_ARG_BLOCK),
	AGENT_GENERIC(MU_ARG_USB_HOST),
#endif	/* INCLUDE_GENERIC_LIST */
	{NULL,NULL}
};

int flag_debug = DEBUG_NONE;

static int
add_path(char **env)
{
	char *newpath;
	int i;

	for(i = 0;env[i] != NULL;i++) {
		if (strncmp("PATH=",env[i],sizeof("PATH=")-1) == 0)
			break;
	}
	/* 
	 * need to reallocate env if env[i] == NULL
	 * but, I think it should be error.
	 */ 
	if (env[i] == NULL)
		return -1;
	newpath = malloc(sizeof("PATH=") - 1 + sizeof(EXEC_PATH) - 1 + strlen(env[i]) + 1);
	if (newpath == NULL)
		return -1;
	strcpy(newpath,"PATH=");
	strcpy(newpath+sizeof("PATH=")-1,EXEC_PATH);
	strcpy(newpath+sizeof("PATH=")-1+sizeof(EXEC_PATH)-1,env[i]+sizeof("PATH=")-1);
	DPRINTF(LOG_LEVEL,"\"%s\"",newpath);
	env[i] = newpath;

	return 0;
}

#ifdef	DEBUG
static void
print_args(char *name,char **av)
{
	int i;

	for(i = 0;av[i] != NULL;i++)
		syslog(LOG_LEVEL,"%s[%d] = \"%s\"\n",name,i,av[i]);

}
#endif

static void
usage(void)
{
	printf("Murasaki version: %s\n",MU_VERSION);
	printf("Please see http://www.dotaster.com/~shuu/linux/murasaki/\n");
	exit(1);
}

int
main(int argc,char **argv,char **env)
{
	char *cmd[HOTPLUG_MAX_ARGS];
	int idx;
	char *ptr;

	if (argc == 1) {
		usage();
	}

	if ((ptr = getenv("MURASAKI_DEBUG")) != NULL)
		flag_debug = atoi(ptr);
	if (flag_debug > DEBUG_TRACE)
		openlog("hotplug." MU_MURASAKI,LOG_PID|LOG_CONS,LOG_DAEMON);
	else
		openlog("hotplug." MU_MURASAKI,LOG_PID,LOG_DAEMON);
	
	if (add_path(env) == -1) {
		exit(1);
	}
	DPRINT_ARGS("argv",argv);

	/* check device */
	if (check_config(argv[1]) == ARG_OFF) {
		syslog(LOG_LEVEL,"%s is defined as \"%s\"",
			config_list[0],config_list[1]);
		exit(0);
	}

	cmd[1] = NULL;
	cmd[2] = NULL;
	for (idx = 0;cmd_table[idx].arg != NULL;idx++) {
		if (strcmp(argv[1],cmd_table[idx].arg) == 0) {
			cmd[0] = cmd_table[idx].cmd;
#ifdef	INCLUDE_GENERIC_LIST
			/* When cmd == "generic", 
			 *  call the agent with the real device.
			 */
			if (strcmp(cmd[0],MU_MURASAKI "." MU_ARG_GENERIC) == 0)
				cmd[1] = argv[1];
#endif	/* INCLUDE_GENERIC_LIST */
			break;
		}
	}
	if (cmd_table[idx].arg == NULL) {
		if (access(GENERICLIST_PATH,R_OK) == 0) {
			char *list[LIST_MAX];
			int i;

			list_from_file(GENERICLIST_PATH,list,LIST_MAX);
			for (i = 0;list[i] != NULL;i++) {
				if (strcmp(argv[1],list[i]) == 0) {
					cmd[0] = MU_MURASAKI "." MU_ARG_GENERIC;
					cmd[1] = argv[1];
				}
			}
#ifdef	KERNEL_JOB
			if (list[0] != NULL)
				free(list[0]);
#endif
		}
		if (cmd[1] == NULL) {
			syslog(LOG_LEVEL,"Unknown Hotplug name \"%s\"",argv[1]);
			syslog(LOG_LEVEL,"Add \"%s\" into murasaki.genericlist if you want",argv[1]);
#ifdef	DEBUG
			print_args("argv",argv);
			print_args("env",env);
#endif
			exit(1);
		}
	}
	closelog();
	DPRINT_ARGS("cmd",cmd);
	execvp(cmd[0],cmd);

	/* not reached */
	return 0;
}
