/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: sticky.c,v 1.2 2003/06/03 07:57:54 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/mman.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"

#define		CHAR_RSEP	'\n'


enum string_status {ST_START, ST_IN };

#ifndef STICKY_PATH
#define STICKY_PATH "/etc/murasaki/murasaki.sticky"
#endif

#define	NUM_ERROR -1

static int
get_stickylist(char **list)
{
	int fd;
	char *sticky,*ptr;
	int count;
	struct stat st;
	enum string_status status = ST_START;
#ifdef	DEBUG
	int i;
#endif

	if ((fd = open(STICKY_PATH,O_RDONLY)) == -1)
		return 0;
	if (fstat(fd,&st) == -1)
		return NUM_ERROR;
	if ((sticky = (char *)malloc(st.st_size)) == NULL)
		return NUM_ERROR;
	if (read(fd,sticky,st.st_size) != st.st_size)
		return NUM_ERROR;
	close(fd);

	for (ptr = sticky,count = 0;ptr < sticky + st.st_size;ptr++) {
		if (status == ST_START) {
			list[count++] = ptr;
			status = ST_IN;
		} else {
			if (*ptr == CHAR_RSEP) {
				*ptr = '\0';
				status = ST_START;
			}
		}
	}
#ifdef	DEBUG
	for (i = 0;i < count;i++) {
		syslog(LOG_LEVEL,"sticky[%d] \"%s\"",i,list[i]);
	}
#endif

	return count;
}

/*
 * Shun-ichi TAHARA fixed free() 
 */
void
delete_stickymodule(char **list)
{
	char *sticky_list[LIST_MAX];
	int sum,i,j;

	sum = get_stickylist(sticky_list);
	if (sum == 0)
		return;
	for(i = 0;list[i] != NULL;i++) {
		for(j = 0;j < sum;j++) {
			if (strcmp(list[i],sticky_list[j]) == 0) {
				syslog(LOG_LEVEL,"%s is sticky module",list[i]);
				remove_from_list(list,i);
				i--;
				break;
			}
		}
	}
	free(sticky_list[0]);
}

#ifdef DEBUG_WITH_MAIN
int
main()
{
	int num;

	num = get_stickylist(sticky_list);
	printf("num %d\n",num);

	return 0;
}
#endif /* DEBUG_WITH_MAIN */
