/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__COMMON_H_
#define _XFMEDIA__COMMON_H_

#include <glib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gtk/gtk.h>

#define round(x) ( ((gdouble)x-(gint)x) >= 0.5000 ? ((gint)x)+1 : (gint)x )
#define BORDER 8

#define XFMEDIA_STOCK_VOLUME       "xfmedia-volume"

#define AUTOHIDE_TIMEOUT           500

G_BEGIN_DECLS

extern const GdkPixdata xfmedia_icon;

void xfmedia_init_icon_theme();
GtkWidget *xfmedia_custom_button_new(const gchar *text, const gchar *icon);
GtkWidget *xfmedia_custom_button_new_from_pixdata(const gchar *text, const GdkPixdata *pixdata);
gchar *xfmedia_filename_to_name(const gchar *filename);
gchar *xfmedia_num_prettify(gint num);
GdkWindow *xfmedia_get_window_decorations(GdkWindow *gwindow);
GList *xfmedia_uri_list_extract_uris(const gchar *uri_list);
gint xfmedia_tree_path_to_index(GtkTreePath *path);
gboolean xfmedia_list_store_remove_path(GtkListStore *ls, GtkTreePath *path);
gchar *xfmedia_brutal_utf8_validate(const gchar *string);
void xfmedia_stock_icons_init();
GdkPixbuf *xfmedia_load_stock_control_button(const gchar *stock_id, GtkIconSize size);
GtkWidget *xfmedia_squished_stock_icon_load(const gchar *stock_id, GtkIconSize size);
GtkWidget *xfmedia_smaller_stock_icon_load(const gchar *stock_id, GtkIconSize size);
gboolean xfmedia_rectangle_contains_point(GdkRectangle *rect, gint x, gint y);
void xfmedia_widget_zero_pointer(GtkWidget **w);
GtkWidget *xfmedia_create_framebox(const gchar *title, GtkWidget **frame_bin);
gchar *xfmedia_xine_get_meta_info_helper(gpointer mwin_p, const gchar *filename, gint meta_info_id);

typedef struct _XfmediaTagInfo XfmediaTagInfo;
    
XfmediaTagInfo *xfmedia_tag_open(gpointer mwin_p, const gchar *uri);
gchar *xfmedia_tag_get_info(XfmediaTagInfo *tag_info, gint type);
void xfmedia_tag_set_info(XfmediaTagInfo *tag_info, gint type, const gchar *info);
gint xfmedia_tag_get_stream_length(XfmediaTagInfo *tag_info);
gchar *xfmedia_tag_to_string(XfmediaTagInfo *tag_info, const gchar *fmt);
gboolean xfmedia_tag_is_writable(XfmediaTagInfo *tag_info);
gboolean xfmedia_tag_is_dirty(XfmediaTagInfo *tag_info);
gboolean xfmedia_tag_flush(XfmediaTagInfo *tag_info);
void xfmedia_tag_close(XfmediaTagInfo *tag_info);

G_END_DECLS

#endif
