
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "refresh.h"

#include "entry.h"
#include "misc.h"
#include "monitor.h"

static gboolean toggle_enabled=TRUE;

G_MODULE_EXPORT
void enable_refresh_by_toggle(gboolean value){
	toggle_enabled=value;
}
G_MODULE_EXPORT
gboolean is_toggle_enabled(void){
	return toggle_enabled;
}

enum
{
    DO_REFRESH,
    DO_TOGGLE_DOT
};

static void do_it(GtkTreeModel * treemodel, GtkTreeIter * iter, GtkTreeView * treeview)
{
    tree_entry_t *en;
    GtkTreePath *treepath;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    treepath = gtk_tree_model_get_path(treemodel, iter);
    if(!en)
	assert_not_reached();
    /*if(caso == DO_TOGGLE_DOT) TOGGLE_SHOWS_HIDDEN(en->type);*/
    SET_INCOMPLETE(en->type);
    gtk_tree_view_collapse_row(treeview, treepath);
    prune_row(treemodel, iter,NULL,en);
    insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gtk_tree_path_free(treepath);
}

/* callbacks */

G_MODULE_EXPORT
void on_refresh_treeview(GtkTreeView *treeview)
{
    GtkTreeModel *treemodel;
    GtkTreeIter iter;
    tree_entry_t *en;
    
    if (!toggle_enabled) return;
    if (treeview==NULL) {
	gint tree_id = get_active_tree_id();
	treeview = tree_details->treestuff[tree_id].treeview;
    } 
    treemodel = gtk_tree_view_get_model (treeview);
    

    if(get_selectpath_iter(&iter, &en))
    {
        do_it(treemodel, &iter, treeview);
    }
    else 
    {	
	if (gtk_tree_model_get_iter_first(treemodel,&iter)){
		do{
    		   gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		   if (en && IS_EXPANDED(en->type))	
        	      do_it(treemodel, &iter, treeview);
		} while(gtk_tree_model_iter_next(treemodel,&iter));
	}
    }

}

G_MODULE_EXPORT
void on_refresh(GtkButton * button, gpointer user_data)
{
    on_refresh_treeview(NULL);
}


G_MODULE_EXPORT
void on_refresh_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    on_refresh_treeview(NULL);
}



static void hide_arrow(GtkTreeViewColumn * column,const gchar *which){
    GtkWidget *a;
    a=(GtkWidget *)g_object_get_data(G_OBJECT(column),which);
    if (a) gtk_widget_hide(a);
}
static void show_arrow(GtkTreeViewColumn * column,const gchar *which){
    GtkWidget *a;
    a=(GtkWidget *)g_object_get_data(G_OBJECT(column),which);
    if (a) gtk_widget_show(a);
}


static void arrow_trick(GtkTreeView *treeview,GtkTreeViewColumn * column){
    treestuff_t *treestuff= get_treestuff(treeview);
    hide_arrow(treestuff->column[NAME_COLUMN],"up");
    hide_arrow(treestuff->column[NAME_COLUMN],"down");
    hide_arrow(treestuff->column[OWNER_COLUMN],"up");
    hide_arrow(treestuff->column[OWNER_COLUMN],"down");
    hide_arrow(treestuff->column[GROUP_COLUMN],"up");
    hide_arrow(treestuff->column[GROUP_COLUMN],"down");
    hide_arrow(treestuff->column[DATE_COLUMN],"up");
    hide_arrow(treestuff->column[DATE_COLUMN],"down");
    hide_arrow(treestuff->column[SIZE_COLUMN],"up");
    hide_arrow(treestuff->column[SIZE_COLUMN],"down");
    hide_arrow(treestuff->column[MODE_COLUMN],"up");
    hide_arrow(treestuff->column[MODE_COLUMN],"down");
    
}

static GtkTreeViewColumn * lastcolumn=NULL;

G_MODULE_EXPORT
void on_column_click(GtkTreeViewColumn * column, gpointer data){
    GtkTreeModel *treemodel;
    GtkTreeSortable *sortable;
    static gboolean red=FALSE;
    GtkTreeView *treeview =(GtkTreeView *)data;
    treestuff_t *treestuff=get_treestuff(treeview);
    gint column_id = (gint)((long)g_object_get_data (G_OBJECT(column),"column_id"));
    
    if (!toggle_enabled || red) return;
    red=TRUE;
    arrow_trick(treeview,column);
    treemodel = gtk_tree_view_get_model(treeview);
    {
	sortable=GTK_TREE_SORTABLE(treemodel);
#ifdef DEBUG
	printf("gtk_tree_sortable_has_default_sort_func=%d\n",
		gtk_tree_sortable_has_default_sort_func(sortable));
#endif
    }
    if (column_id == GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID) {
	treestuff->ascending=0;
    }
    else {
      GtkSortType order;
      if (gtk_tree_sortable_get_sort_column_id (sortable,&(treestuff->sort_column),&order)){
	  if (column_id != treestuff->sort_column) treestuff->ascending=1;
	  else treestuff->ascending++;
      } else treestuff->ascending=1;
    }
    
    treestuff->sort_column=column_id;
    
    switch (treestuff->ascending%3) {
	case 0:
	  treestuff->sort_column =GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
	  gtk_tree_sortable_set_sort_column_id (sortable,treestuff->sort_column,GTK_SORT_ASCENDING);
	  break;
	case 1:
	  show_arrow(column,"up");
	  gtk_tree_sortable_set_sort_column_id (sortable,treestuff->sort_column,GTK_SORT_ASCENDING);
	  break;
	case 2:
	  show_arrow(column,"down");
	  gtk_tree_sortable_set_sort_column_id (sortable,treestuff->sort_column,GTK_SORT_DESCENDING);
	  break;
    }
    lastcolumn=column;
    red=FALSE;
}



