/*  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"


static gchar *password=NULL;
static GtkWidget * user, *passwd, *dialog;
static int passwd_caso;

#define EXPAND      TRUE
#define FILL        TRUE
#define NOEXPAND    FALSE
#define NOFILL      FALSE


static void
destroy_dialog (GtkWidget * widget, gpointer data)
{
  gtk_widget_destroy ((GtkWidget *) data);
  gtk_main_quit ();
}

static void
cancel_dialog (GtkWidget * widget, gpointer data)
{
  g_free(password);
  password=NULL;
  gtk_widget_destroy ((GtkWidget *) data);
  gtk_main_quit ();
}

static void
ok_dialog (GtkWidget * widget, gpointer data)
{
  char *s, *t;
  int caso;

  caso = (int) ((long) data);

  s = (char *)gtk_entry_get_text (GTK_ENTRY (user));
  t = (char *)gtk_entry_get_text (GTK_ENTRY (passwd));
  if (!strlen(s)) s="Guest";

  g_free(password);
  if (strlen (t) > 0) 
      password=g_strdup_printf ("%s%c%s", s,'%',t);
  else 
      password=g_strdup_printf ("%s%c", s,'%');

  gtk_widget_destroy (dialog);
  gtk_main_quit ();
}

static void
entry_activate (GtkWidget * entry, GdkEventKey * event, gpointer data)
{
  {
    if (entry == user)  gtk_widget_grab_focus (passwd);
    if (entry == passwd) ok_dialog (NULL, NULL);
  }
  return;

}
static const gchar *
passwd_dialog (GtkWidget *parent,int caso,const gchar *init_password, const gchar *ptext)
{
  GtkWidget *button, *hbox, *label;

  passwd_caso = caso;
  if (init_password){
      g_free(password);
      password=g_strdup(init_password);
  }

  /*SMBabortdrop=TRUE;*/
  dialog = gtk_dialog_new ();
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

  gtk_widget_realize (dialog);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  if (caso == 1 || caso == 11){
    if (ptext) label = gtk_label_new (ptext);
    else label = gtk_label_new (_("Please provide information for server "));
  }
  else {
    label = gtk_label_new (_("Please provide browsing preferences "));
  }
  
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  gtk_widget_show (hbox);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  if (caso != 11) gtk_widget_show (hbox);

  label = gtk_label_new (_("Username : "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  user = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), user, EXPAND, NOFILL, 0);
  g_signal_connect (G_OBJECT (user), "activate", 
		  GTK_SIGNAL_FUNC (entry_activate), NULL);
  gtk_widget_show (user);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Password  : "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  passwd = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), passwd, EXPAND, NOFILL, 0);
  gtk_entry_set_visibility ((GtkEntry *) passwd, FALSE);
  g_signal_connect (G_OBJECT (passwd), "activate", GTK_SIGNAL_FUNC (entry_activate), NULL);
  gtk_widget_show (passwd);

  button = gtk_button_new_with_label (_("Ok"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), button, EXPAND, NOFILL, 0);
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (ok_dialog), (gpointer) ((long) caso));
  button = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
		  button, EXPAND, NOFILL, 0);
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", 
		  GTK_SIGNAL_FUNC (cancel_dialog), (gpointer) dialog);
  g_signal_connect (G_OBJECT (dialog), "destroy", 
		  GTK_SIGNAL_FUNC (destroy_dialog), (gpointer) dialog);  
  gtk_widget_show (dialog);
  
  if (caso != 11 && password)
  {
    gchar *u,*p;
    u=g_strdup(password);
    if (strchr(u,'%')){
	p=strchr(u,'%')+1;
	*(strchr(u,'%'))=0;	
    } else p=NULL;
    if (strstr (u, "Guest") == NULL && strstr (u, "GUEST") == NULL){
	if (u && strlen(u)) {
	    gtk_entry_set_text ((GtkEntry *) user, u);
	    gtk_widget_grab_focus (user);
	}
	if (p && strlen(p)) {
	    gtk_entry_set_text ((GtkEntry *) passwd, p);
	    gtk_widget_grab_focus (passwd);
	}
    }
    
    g_free(u);
  }
  else gtk_widget_grab_focus (user);
  if (parent) gtk_window_set_transient_for (
		    GTK_WINDOW (dialog), 
		    GTK_WINDOW (parent));
  gtk_main();
  return password;
}

G_MODULE_EXPORT
const gchar *get_password(GtkWidget *parent,const gchar *ptext){
    const gchar *p;
    g_free(password);
    password=NULL;
    p=passwd_dialog (parent, 11,NULL,ptext);
    if (p && strchr(p,'%')) p = strchr(p,'%')+1;
    return p;
}

G_MODULE_EXPORT
const gchar *get_smbuserpass(GtkWidget *parent,tree_entry_t *en){
    const gchar *p;
    const gchar *u=NULL;
    /* browse password: */
    if (en && en->tag && strlen(en->tag)){
        u=en->tag;
    } else {
        if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))){
	   u=getenv("SMB_USER");
        }
    }
    p=passwd_dialog (parent, 1,u,NULL);
    return p;
}


