/*
  Copyright 1999-2005 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.
  
  You may not use this file except in compliance with the License.
  obtain a copy of the License at
  
    http://www.imagemagick.org/www/Copyright.html
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  Image private mogrify command methods.
*/
#ifndef _MAGICK_MOGRIFY_PRIVATE_H
#define _MAGICK_MOGRIFY_PRIVATE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#define MaxImageStackDepth  32
#define MogrifyImageStack(image,fire) \
if ((j <= i) && (i < argc)) \
  { \
    if ((image) == (Image *) NULL) \
      status&=MogrifyImageInfo(image_info,(int) (i-j+1),argv+j,exception); \
    else \
      if ((fire) != MagickFalse) \
        { \
          status&=MogrifyImages(image_info,(int) (i-j+1),argv+j,&(image)); \
          if ((image) != (Image *) NULL) \
            GetImageException((image),exception); \
          if (exception->severity != UndefinedException) \
            CatchException(exception); \
          j=i+1; \
          pend=MagickFalse; \
        } \
  }

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
