// Q's Nicolatter for X
// Copyright (c) 1998-2002 HORIKAWA Hisashi. All rights reserved.
//     mailto:vzw00011@nifty.ne.jp
//     http://www2.airnet.ne.jp/pak04955/

#include "../keymap.h"
#include "conv.h"

//////////////////////////////////////////////////////////////////////
// WnnConv

enum IM_State {
    MI_NYURYOKU,    // ̤
    HENKAN_MAE,     // ʥåȤ
    ZEN_HENKAN,     // ѴʥåȤʤ
    KOUHO_ICHIRAN   // ʥåȤʤ
};

class WnnConv;
struct PieceIdExecPair
{
    FuncPieceId id;
    void (WnnConv::*exec)();
};

class WnnCandidate;
class RomaKanaDef;
class WnnConv: public KanaKanjiConv
{
    typedef KanaKanjiConv super;
    typedef ptr_vector<RomaKanaDef*> RomaKanaDefs;
    typedef vector<int> IndexList;

public:
    IM_State im_state;
    string preconv;         // ɤ
    string converted;
    SizeList<int> charSizes;     // ʸΥХĹ
    int caret;
    IndexList conv_i;   // ѴʸγʸΥХȰ
    int cur_clause;
    CharStatusList statusList;
    class qWnn* wnn;

private:
    static RomaKanaDefs romaDefs;
    KanaKanjiStatus result_stat;

    IndexList read_i;   // ̾γʸʸ
    int conv_count;     // ФޤǤβ
    KanaMode kana_mode;     // 0 = ѻ1 = , 2 = ̵Ѵ
    KanaMode last_mode;     // Υ⡼ɡȥ뵡ǽȤ
    WnnCandidate* candWindow;

    static const PieceIdExecPair conv_funcs[];

public:
    WnnConv(InputContext* );
    virtual ~WnnConv();

    virtual KanaKanjiStatus input(const KeyEvent& event, int level);

    static bool loadRomaDef(const char* filename);
    void onCandidateSelected(int cand);

    virtual void all_determine();
    virtual void clear();
    virtual KanaMode getKanaMode() const;
    virtual void setKanaMode(KanaMode mode);
    virtual PreeditWindow* createPreeditWindow();
    virtual StatusWindow* createStatusWindow();
    virtual void setCandidateVisible(bool );
    virtual void updateCandidate();
private:
    void execGraphChar(const char* str, KanaKanjiStatus* charType);
    void execCtrlFunc(const CtrlFunc* func, KanaKanjiStatus* charType);

    int matchRoma(const char* buf, int len, bool last_caret,
                  const char* def) const;
    void convertRoma();
    void query();
    void addChar(const char* s);

    void through();
    void na();
    void kanji();
    void space();
    void convert();
    void next_cand();
    void prev_cand();
    void caret_left();
    void shrink();
    void caret_right();
    void expand();
    void clause_left();
    void clause_right();
    void left_erase();
    void right_erase();
    void revert();
    void head();
    void tail();
    void clause_det();
    void fixed_alnum();
};

