// Q's Nicolatter for X
// Copyright (c) 1998-2000 Hisashi HORIKAWA. All rights reserved.

#ifndef QSNICOLA_KEYMAP_H
#define QSNICOLA_KEYMAP_H

#include <string>
#include <cstdio>
#include <cassert>
using namespace std;

#include <misc.h>

//////////////////////////////////////////////////////////////////////

extern Display* top_display;

extern string getKeyName(int mod, int keycode);
extern string getKeyName2(int mod, int keycode);
extern int getKeyMod(const string& key_name);
extern int getKeyCode(const string& key_name);

//////////////////////////////////////////////////////////////////////
// Key

enum KeyType {
    UNDEF_KEY = 0,
    GRAPHIC_KEY,    // ޷ ISO/IEC 9995-1
    FUNCTION_KEY    // 業
};

class Key
{
public:
    string name;    // ̾ [Ctrl]ʻѤǤϡ"ctrl-"դ

    Key(const string& name_);
    virtual ~Key() { }
    virtual KeyType getType() const = 0;
};

//////////////////////////////////////////////////////////////////////
// GraphicKey

class GraphicKey: public Key
/*
    1999.01.17޷業̤ˡǼƤߤ롣Υǥ˴Ϥʤ
    ͳפФʤΥǥþ顤޷業̤ƥ֤ǿ
    ʸ浡ǽ֥ǥѹ롣
*/
{
    friend class KeyMap;
    string chars[3];    // ñǸեȡե
public:
    GraphicKey(const string& name, const string* s);
    virtual ~GraphicKey();
    virtual KeyType getType() const;
    virtual string getGraphChar(int level) const;
};

//////////////////////////////////////////////////////////////////////
// CtrlFunc

enum FuncPieceId {
    CF_ERROR = 0,   // ǽϳƤʤ
    CF_THROUGH = 1,
    CF_NA,
    CF_KANJI,
    CF_SPACE,
    CF_CONVERT,
    CF_NEXT_CAND,
    CF_PREV_CAND,
    CF_CARET_LEFT,
    CF_SHRINK,
    CF_CARET_RIGHT,
    CF_EXPAND,
    CF_CLAUSE_LEFT,
    CF_CLAUSE_RIGHT,
    CF_ALL_DETERMINE,
    CF_CLEAR,
    CF_LEFT_ERASE,
    CF_RIGHT_ERASE,
    CF_REVERT,
    CF_HEAD,
    CF_TAIL,
    CF_CLAUSE_DET,
    CF_FIXED_ALNUM
};

const int COUNT_IME_STAT = 4;

struct FuncNameIdPair
{
    const char* name;   // "revert"ʤ
    FuncPieceId id;     // CF_REVERT
    bool canUse[COUNT_IME_STAT];     // IMEξ֤ȤˡȤ뤫Ȥʤ
};

extern const FuncNameIdPair funcNameId[];
extern FuncPieceId find_piece_id(const string& piece_name, int ime);
extern const char* find_piece_name(FuncPieceId id);

struct CtrlFunc
    // 浡ǽ
{
    string name;        // ֳפʤɡkey.defǥ桼
    FuncPieceId piece[COUNT_IME_STAT];   // IMEξ֤Ȥεǽ
                        // key.defǤ"revert"ʤʸfuncNameIdǰ
};

//////////////////////////////////////////////////////////////////////
// FunctionKey

class FunctionKey: public Key
    // 業
{
public:
    const CtrlFunc* func[3];   // ñȡ
            // ʣΥ浡ǽǤ뤫顤業浡ǽͭʤ

    FunctionKey(const string& name);
    virtual ~FunctionKey();
    virtual KeyType getType() const;
};

//////////////////////////////////////////////////////////////////////
// KeyMap

struct KeyComp {
    bool operator () (const Key* x, const Key* y) const {
        assert(x && y);
        return x->name < y->name;
}};

struct FuncComp {
    bool operator () (const CtrlFunc* x, const CtrlFunc* y) const {
        assert(x && y);
        return x->name < y->name;
}};

class KeyMap
    // 󥯥饹
    // ƥˤĤ
    //      ޷業
    //      ޷ʸ
    //      業ʤ浡ǽ
    // ġ
    // Υ饹ɽǼΤߤǤäơ
    // ϤʸѴʤ
{
public:
    typedef ptr_set<Key*, KeyComp> KeyList;
    typedef ptr_set<CtrlFunc*, FuncComp> FuncList;

    KeyList keyList;
    FuncList funcList;

    KeyMap();
    virtual ~KeyMap();

    virtual bool load(const string& filename);
    virtual bool save(const char* filename) const;
    void clear();

    const Key* find_key(const string& key_name) const;
    void remove_key(const string& key_name);

    FunctionKey* createFuncKey(const string& key_name, const string func[]);

private:
    void saveKeyList(FILE* fp) const;
    void saveFuncList(FILE* fp) const;
    void loadKey(FILE* fp, int& line);
    void loadFunc(FILE* fp, int& line);
    const CtrlFunc* find_func(const string& func_name) const;
};

extern KeyMap* keyMap;

#endif  // QSNICOLA_KEYMAP_H
