/* @(#) ZFoutlib Ver.1.10 (ZFstdhd.c : 1995/08/19)
 *
 * (c) Copyright 1994,1995 by M.Sato
 */
#include "ZFbuild.h"

static char ihed_dbz[] =  "\"I\",\"SCRT\",\"CLAS\",\"IMG1\"";
static char ihed_pvf1[] = "\"I\",\"SCRT\",\"IMG1\"";
static char ihed_wiz[] =  "\"I\",\"SCRT\",\"INDY\",\"IMG1\"";

static char *ihed[ZF_OUTTYPES] = {
  ihed_dbz,
  ihed_pvf1,
  ihed_dbz,   /* header of ZAURUS is same as DB-Z */
  ihed_dbz,   /* for Wiz sized ZAURUS-format data */
  ihed_wiz,
};

/* contains SHIFT-JIS-KANJI and JIS-HANKAKU-KATAKANA and 
 * 2byte-HANKAKU-KATAKANA(as JIS undefined code)
 */
static char thed_dbz[]  = "\"T\",\"\x91\xae\x90\xab\",\"\xc0\xb2\xc4\xd9\",\"\xb2\xd2\xb0\xbc\xde\xc3\xde\xb0\xc0\"";

static char thed_pvf1[] = "\"T\",\"\x83\x56\x81\x5b\x83\x4e\x83\x8c\x83\x62\x83\x67\",\"\xb1\xb8\xbc\xae\xdd\xec\xda\xb0\xec\xc7\x93\xe0\x97\x65\x81\x69\x90\x7d\x8c\x60\x81\x6a\"";

static char thed_zau[]  =  "\"T\",\"\x83\x56\x81\x5b\x83\x4e\x83\x8c\x83\x62\x83\x67\",\"\xc0\xb2\xc4\xd9\",\"\xb2\xd2\xb0\xbc\xde\xc3\xde\xb0\xc0\"";

static char thed_wiz[]  =  "\"T\",\"ATTRIBUTE\",\"DATE\",\"PICTURE\"";

static char *thed[ZF_OUTTYPES] = {
  thed_dbz,
  thed_pvf1,
  thed_zau,
  thed_zau,
  thed_wiz,
};

static char dhed_titled[] =  "\"D\",\" \",\"%s\",";
static char dhed_notitle[] = "\"D\",\" \",";

static char *dhed[ZF_OUTTYPES] = {
  dhed_titled,
  dhed_notitle,
  dhed_titled,
  dhed_titled,
  dhed_titled,
};

static int dhsprintf[ZF_OUTTYPES] = {TRUE,FALSE,TRUE,TRUE,TRUE};

int ZFstdhd(outfp, outtyp, title)
  FILE *outfp;
  int outtyp;
  char title[];
{
    if (!ZFsupport(outtyp)) return (ZFerrno = ZF_UNSUPP);

    fprintf(outfp, "%s%s%s%s",
      ihed[outtyp], CR_LF,
      thed[outtyp], CR_LF
    );
    if (!ferror(outfp)) {
      if (dhsprintf[outtyp]) {
        fprintf(outfp, dhed[outtyp],title);
      } else {
        fprintf(outfp, dhed[outtyp]);
      }
    }
    if (ferror(outfp)) return (ZFerrno = ZF_FERROR);
    return (ZFerrno = ZF_OK);
}
