/* @(#) ZFoutlib Ver.1.11 (ZFout.h : 1996/08/05)
 *
 * (c) Copyright 1994-1996 by M.Sato
 * E-mail : satou@kintaro3.elcom.nitech.ac.jp (to March, 1997)
 *          cnc09351@chunichi-net.or.jp
 */
#ifndef _ZFout_H
#define _ZFout_H

/* FILE must be defined before definition of ZFwork */
#include <stdio.h>

#ifndef NULL
#include <stdlib.h>
#endif

#ifndef _ZF_LIB_BUILD
#  include <ZFconf.h>
#endif

#define ZF_VERSION 1
#define ZF_SUBVERSION 12

/* Surported formats type */
#define ZF_DBZ    0
#define ZF_PVF1   1
#define ZF_ZAURUS 2
#define ZF_ZAUWIZ 3
#define ZF_WIZ    4

#define ZF_WIZ_BW    ZF_WIZ
#define ZF_ZAURUS_BW ZF_ZAURUS

#ifndef FALSE
#  define FALSE     0
#endif
#ifndef TRUE
#  define TRUE      1
#endif

/* data size */
#define WIDTH_DBZ     192
#define HEIGHT_DBZ    109

#define WIDTH_PVF1    256
#define HEIGHT_PVF1   200

#define WIDTH_ZAURUS  198
#define HEIGHT_ZAURUS 128

#define WIDTH_WIZ     133
#define HEIGHT_WIZ    104

/* return code */
/* 0        : No error
 * positive : Error, but it is able to recover
 * negative : Error, it is NOT able to recover
 */
#define ZF_OK       0 /* no error */
#define ZF_OUTRANGE 1 /* ZFend before dot-output end etc. */
#define ZF_UNSUPP  -1 /* Unsupproted format */
#define ZF_NOMEM   -2 /* Memory over (malloc) */
#define ZF_FERROR  -3 /* File error (ferror(fp)!=0) */
#define ZF_DOTERR  -4 /* Cannot read dot */

/* ZFwork structure */
typedef struct {
  unsigned int width;
  unsigned int height;
  unsigned int xpos;
  unsigned int ypos;
  unsigned int lbyte;
  int fmt;
  unsigned char count;
  int stat;
  FILE *fp;
  unsigned char *buf;
  unsigned int bufp;
  unsigned char bitbuf;
  unsigned char pre_c;
  unsigned char bitmask;
  unsigned int lbufp;
  unsigned int cbufp;
  int retcode;
} ZFwork;

#define ZF_NULL ((ZFwork *)NULL)

#ifdef Use_ANSI_Header
  int ZFstdhd(FILE *, int, char[]);
  ZFwork *ZFstart(FILE *,int, unsigned int, unsigned int);
  ZFwork *ZFstdstart(FILE *,int, char[]);
  int ZFsupport(int);
  int ZFdotout(ZFwork *, int);
  int ZFend(ZFwork *);
  unsigned int ZFstdwidth(int);
  unsigned int ZFstdheight(int);
  int ZFeoln(FILE *);
  int ZFeod(FILE *);
  /* "+" is used to deny assignment */
# define ZFwidth(wk) (+((wk)->width))
# define ZFheight(wk) (+((wk)->height))

#else
  int ZFstdhd();
  ZFwork *ZFstart();
  ZFwork *ZFstdstart();
  int ZFsupport();
  int ZFdotout();
  int ZFend();
  unsigned int ZFstdwidth();
  unsigned int ZFstdheight();
  int ZFeoln();
  int ZFeod();
  /* "+0" is used to deny assignment */
# define ZFwidth(wk) (((wk)->width)+0)
# define ZFheight(wk) (((wk)->height)+0)

#endif

extern int ZFerrno;

#endif /* _ZFout_H */
