/* @(#) xbm2free.c  Ver.1.10 1995/11/30 */
#include "xbm2free.h"

Display  *disp;
Pixmap    pix;
XImage   *image;
unsigned int  bmwidth, bmheight;

int reverse = FALSE;
int use_tmp = FALSE;

#ifdef USE_TMPNAM
  char fname_tmp[L_tmpnam];
#else
  char fname_tmp[256];
#endif

ZFwork *zfwp;

void print_usage()
{
    fprintf(stderr, "<<< %s : X11 bitmap file --> ZAURUS free hand memo >>>\n", PROGNAME);
    fprintf(stderr, "Usage:\n");
    fprintf(stderr, "  xbm2free [format] [-t title] [-display display] xbmfile\n");
    fprintf(stderr, "xbm-file:\n");
    fprintf(stderr, "  If - is appears as xbmfile, xbm2free uses standard input.\n");
    fprintf(stderr, "format:\n");
    fprintf(stderr, "  -d : DB-Z format\n");
    fprintf(stderr, "  -v : PV-F1 format (ignore title)\n");
#ifdef ZF_WIZ
    fprintf(stderr, "  -w : Wiz format\n");
#endif
    fprintf(stderr, "  -z : ZAURUS format\n");
    fprintf(stderr, "  -s : force image size to be equal to xbmfile\n");
    fprintf(stderr, "  -r : Black/White reverse\n");
    fprintf(stderr, "default:\n");
    fprintf(stderr, "  -z -t %s\n\n", TITLE_DEFAULT);
    fprintf(stderr, "NOTICE:\n");
    fprintf(stderr, " %s is X client.\n", PROGNAME);
    fprintf(stderr, " -s can't use with -d\n");
}

int getZFerr()
{
    switch (ZFerrno) {
    case ZF_FERROR:
      return FERROR;
    case ZF_NOMEM:
      return MEMERROR;
    default:
      return CNVERROR;
    }
}

void prog_end(retval, freeobj)
int retval;
int freeobj;
{
    if (freeobj & FREEIMG) XDestroyImage(image);
    if (freeobj & FREEDISP) XCloseDisplay(disp);
    if (freeobj & FREEZFWK) ZFend(zfwp);
    if (use_tmp == TRUE) remove(fname_tmp);
    if(retval == USAGE) {
      print_usage();
    } else {
      fprintf(stderr, "%s\n", endmsg[retval]);
    }
    exit(retval);
}

char *maketmp()
{
    FILE *fp;
    int c;
#ifdef USE_TMPNAM
    tmpnam(fname_tmp);
#else
    sprintf(fname_tmp,"%s/%s%ld",TMPDIR_DEFAULT,TMPBASE_DEFAULT, getpid());
#endif
    if ((fp = fopen(fname_tmp,"w")) == NULL) {
      use_tmp = FALSE;
      return NULL;
    }
    while ((c = getc(stdin)) != EOF) {;
      if (putc(c, fp) == EOF) {
	fclose(fp);
	return NULL;
      }
    }
    fclose(fp);
    if ferror(stdin) return NULL;
    return fname_tmp;
}

void readxbm(fname)
char *fname;
{
    int dummy;

    if (XReadBitmapFile(disp, RootWindow(disp, 0), fname,
         &bmwidth, &bmheight, &pix, &dummy, &dummy) != BitmapSuccess) {
      prog_end(XBMERROR, FREEDISP);
    }
    image = XGetImage(disp, pix, 0, 0, bmwidth, bmheight,
              ~0L, XYPixmap);
    XFreePixmap(disp, pix);
    if (image == NULL) prog_end(XBMERROR, FREEDISP);
}

int getdot(x, y)
unsigned int x, y;
{
    int retval = 0;
    if ((x < bmwidth) && (y < bmheight)) {
      retval = (XGetPixel(image, x, y) != 0L);
    }
    return (reverse == TRUE) ? !retval : retval;
}

void convert(outtyp, set_bmsize)
int outtyp;
int set_bmsize;
{
    unsigned int width;
    unsigned int height;
    if (set_bmsize) {
      width = bmwidth;
      height = bmheight;
    } else {
      width = ZFstdwidth(outtyp);
      height = ZFstdheight(outtyp);
    }
    if ((zfwp = ZFstart(stdout, outtyp, width, height)) == ZF_NULL) {
      prog_end(getZFerr(), FREEDISP | FREEIMG);
    }
    if (ZFptnout(zfwp, getdot) != ZF_OK) {
      prog_end(getZFerr(), FREEDISP | FREEIMG | FREEZFWK);
    }
    if (ZFend(zfwp) != ZF_OK) {
      prog_end(getZFerr(), FREEDISP | FREEIMG);
    }
    ZFeod(stdout);
    if (ferror(stdout)) prog_end(FERROR, FREEDISP | FREEIMG);
}

void main(argc, argv)
int argc;
char *argv[];
{
    int  i;
    char *fname = NULL;
    char *dispname = NULL;
    char *title = TITLE_DEFAULT;
    char *str;
    int  out_typ = ZF_ZAURUS;
    int  set_bm_size = FALSE;

    for (i = 1; i < argc; i++) {
      str = argv[i];
      if (str[0] == '-') {
        switch (str[1]) {
        case 'v': out_typ = ZF_PVF1;   break;
#ifdef ZF_WIZ
        case 'w': out_typ = ZF_ZAUWIZ; break;
#endif
        case 'z': out_typ = ZF_ZAURUS; break;
        case 's': set_bm_size = TRUE; break;
        case 'r': reverse = TRUE;     break;

        case 'd':
          if (str[2] == '\0') {  /* -d */
            out_typ = ZF_DBZ;
          } else {
            /* '-d*' is same as '-display'*/
            if (++i < argc) dispname = argv[i];
          }
          break;

        case 't':
         if (++i < argc) title = argv[i];
          break;
        case '\0':
	  use_tmp = TRUE;
          fname = str;
	  break;
        default:
          break;
        }
      } else {
	use_tmp = FALSE;
        fname = str;
      }
    }
    if (fname == NULL) prog_end(USAGE, 0);
#ifdef ZF_WIZ
    if ((out_typ == ZF_DBZ) || (out_typ == ZF_ZAUWIZ)) {
#else
    if (out_typ == ZF_DBZ) {
#endif
      set_bm_size = FALSE;
    }



    if (use_tmp == TRUE) {
      if ((fname=maketmp()) == NULL) {
	prog_end(TMPERROR, 0);
      }
    }

    if ((disp = XOpenDisplay(dispname)) == NULL) {
      prog_end(DISPERROR, 0);
    }

    readxbm(fname);
    if (ZFstdhd(stdout, out_typ, title) != ZF_OK) {
      prog_end(getZFerr(), FREEDISP |FREEIMG);
    }
    convert(out_typ, set_bm_size);
    prog_end(CNV_OK, FREEDISP | FREEIMG);
}
