############### Makefile for xbm2free & ZFoutlib #################
GZIP	   = /usr/local/bin/gzip
TAR        = tar
CC         = cc
CFLAGS     = -g
SHELL      = /bin/sh

DISTDIR    = /usr/local/bin

STDINCDIRS = -I/usr/include

################# Macros for xbm2free ##############################
# Extra libs. if malloc() requires extra library, change this macro
# like as '-L/usr/local/lib/malloc -lmalloc'
EXTRALIBS =
# Xlib include file directory
XINCDIR    = -I/usr/include/X11R5
# Xlib library directory
XLIBDIR    = -L/usr/lib/X11R5

# directory for temporary file
XBM2FREETMP=/tmp

## change temporary file name makeing.
# if USETMPNAM is defined as '-DUSE_TMPNAM', XBM2FREETMP is ignored.
#USETMPNAM = -DUSE_TMPNAM

# C Compiler flags
CFLAGSXBM2F = $(CFLAGS) $(STDINCDIRS) $(USETMPNAM)

################# Macros for ZFoutlib ###############################
## If mallc() requires <malloc.h>, change REQMALLOCH to be 'define'
REQMALLOCH = undef
# REQMALLOCH = define

## If mallc() requires <alloc.h>, change REQALLOC to be 'define'
REQALLOCH = undef
# REQALLOCH = define

## If free() is decleared as free(char *), change FREECHRPNT to be 'define'.
FREECHRPNT = undef
# FREECHRPNT = define

## C Compiler flags
CFLAGSZF = $(CFLAGS) $(STDINCDIRS)

###################################################################
ZFOUTDIR   = ./ZFout111
ZFMAKEIN   = $(ZFOUTDIR)/Makefile.in
ZFMAKEFILE = $(ZFOUTDIR)/Makefile
ZFSITEH    = $(ZFOUTDIR)/site.h
ZFSITEIN   = $(ZFOUTDIR)/site_h.in
ZFOUTLIBA  = $(ZFOUTDIR)/libZFout.a

XBM2FREEDIR  = ./xbm2free-1.10
XBM2FREEMKIN = $(XBM2FREEDIR)/Makefile.in
XBM2FREEMK   = $(XBM2FREEDIR)/Makefile
XBM2FREE     = $(XBM2FREEDIR)/xbm2free
XBM2FMKFLAGS  = "XINCDIR=$(XINCDIR) $(UNISDTHDIR)" "XLIBDIR=$(XLIBDIR)" \
    "TMPDIR_DEFALUT=$(XBM2FREETMP)" \
    "ZFOUTLIBDIR=-L../$(ZFOUTDIR)" "ZFOUTINCDIR=-I../$(ZFOUTDIR)" \
    "ZFOUTLIB=-lZFout $(EXTRALIBS)"
#####################################################################
all : extract $(XBM2FREE)

install : all
	cp $(XBM2FREE) $(DISTDIR)

############# EXTRACT ########################################
extract :  $(ZFOUTDIR) $(XBM2FREEDIR)

$(ZFOUTDIR) : ZFout111.tar.gz
	$(GZIP) -d -c ZFout111.tar.gz | $(TAR) xvf -

$(XBM2FREEDIR) : xbm2free-1.10.tar.gz
	$(GZIP) -d -c xbm2free-1.10.tar.gz | $(TAR) xvf -

############# CLEAN ##########################################
clean-all :
	rm -rf $(ZFOUTDIR) $(XBM2FREEDIR)
clean :
	cd $(ZFOUTDIR); make clean
	cd $(XBM2FREEDIR); make clean

############# make ZFoutlib.a ##################################
$(ZFOUTLIBA) : $(ZFOUTDIR)
	cat $(ZFSITEIN) \
	  | sed -e 's/undef REQ_MALLOC_H/$(REQMALLOCH) REQ_MALLOC_H/' \
	  | sed -e 's/undef REQ_ALLOC_H/$(REQALLOCH) REQ_ALLOC_H/' \
	  | sed -e 's/undef FREE_CHAR_PNT/$(FREECHRPNT) FREE_CHAR_PNT/' \
	  > $(ZFSITEH)
	cp $(ZFMAKEIN) $(ZFMAKEFILE)
	cd $(ZFOUTDIR); make "CFLAGS=$(CFLAGSZF)" "CC=$(CC)"
############# make xbm2free ####################################
$(XBM2FREE) : $(XBM2FREEDIR) $(ZFOUTLIBA)
	cp $(XBM2FREEMKIN) $(XBM2FREEMK)
	cd $(XBM2FREEDIR); \
	make "CFLAGS=$(CFLAGSXBM2F)" "CC=$(CC)" $(XBM2FMKFLAGS)
