// Q's Nicolatter for X
// Copyright (c) 1998-2002 HORIKAWA Hisashi. All rights reserved.
//     mailto:vzw00011@nifty.ne.jp
//     http://www2.airnet.ne.jp/pak04955/

#ifndef QSNICOLA_LEVELSELECTOR_H
#define QSNICOLA_LEVELSELECTOR_H

#include <X11/Xlib.h> // XKeyEvent
#include <string>
using namespace std;

//////////////////////////////////////////////////////////////////////
// LevelSelector

struct KeyEvent {
    int type; // KeyPress, KeyRelease
    int keycode;
    int keychar;
    int modifier; // ControlMask, ShiftMask, Mod1Mask
    int time;
    XKeyEvent* xk;

    KeyEvent();
    KeyEvent(const KeyEvent& x);
    explicit KeyEvent(const XKeyEvent& xk);
    virtual ~KeyEvent();
    KeyEvent& operator = (const KeyEvent& x);
};

class LevelSelector
    // ON/OFFsequence򥭡/٥Ȥ߹碌Ѵ
    // ޻ѴϡʸѴθʤǤäơ
    // Υ饹ʤ饹ˤϴΤʤ
{
public:
    virtual void input(class InputContext* ic, const KeyEvent& event) = 0;
    virtual string getStatus() const = 0;
    virtual ~LevelSelector() { }
};

extern LevelSelector* keyChar;

//////////////////////////////////////////////////////////////////////
// NormalSelector

class NormalSelector: public LevelSelector
    // Ʊեư
{
public:
    NormalSelector();
    virtual ~NormalSelector();
    virtual void input(InputContext* ic, const KeyEvent& event);
    virtual string getStatus() const;
};

//////////////////////////////////////////////////////////////////////
// PrefixSelector

class PrefixSelector: public LevelSelector
    // prefix style shift
{
    bool is_shift;
public:
    PrefixSelector();
    virtual ~PrefixSelector();
    virtual void input(InputContext* ic, const KeyEvent& event);
    virtual string getStatus() const;
};

#endif
